/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.categorisation;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.exteca.categorisation.CategorisationException;
import org.exteca.ontology.Concept;

public class DefaultRulesElement {
    public static final String ELEMENT_TYPE_CONCEPT = "concept";
    public static final String ELEMENT_TYPE_SIGNPOST = "signpost";
    public static final String ELEMENT_TYPE_LINK = "link";
    public static final String MORPHER_ATTRIBUTE = "morpher";
    public static final String WEIGHT_ATTRIBUTE = "weight";
    public static final String ASSOCIATION_ATTRIBUTE = "association";
    private String type;
    private Map attributeMap;
    private Map weightMap;
    private String morpher = "";

    public DefaultRulesElement(String string) {
        this.setType(string);
        this.weightMap = new HashMap();
        this.attributeMap = new HashMap();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getMorpher() {
        return this.morpher;
    }

    public void setMorpher(String string) {
        this.morpher = string;
    }

    public void addWeight(Integer n, Integer n2) {
        if (!this.weightMap.containsKey(n)) {
            this.weightMap.put(n, n2);
        }
    }

    public Integer getWeight(Integer n) {
        Integer n2 = (Integer)this.weightMap.get(n);
        if (n2 == null) {
            n2 = (Integer)this.weightMap.get(new Integer(0));
        }
        return n2;
    }

    public void addAttribute(String string, String string2) {
        if (!this.attributeMap.containsKey(string)) {
            this.attributeMap.put(string, string2);
        }
    }

    public String getAttribute(String string) {
        String string2 = (String)this.attributeMap.get(string);
        return string2;
    }

    public void addRuleAttribute(String string, String string2) throws CategorisationException {
        if (string.equals(MORPHER_ATTRIBUTE)) {
            this.morpher = string2;
        } else if (string.startsWith(WEIGHT_ATTRIBUTE)) {
            this.processWeight(string, string2);
        }
    }

    public String[] getOntologyElements(Concept concept) throws CategorisationException {
        if (this.type.equals(ELEMENT_TYPE_CONCEPT)) {
            return this.getConceptElement(concept);
        }
        if (this.type.equals(ELEMENT_TYPE_SIGNPOST)) {
            return this.getSignPostElement(concept);
        }
        if (this.type.equals(ELEMENT_TYPE_LINK)) {
            return this.getLinkElement(concept);
        }
        throw new CategorisationException("Element type not supported:" + this.type);
    }

    private void processWeight(String string, String string2) throws CategorisationException {
        block7: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", false);
            try {
                int n = stringTokenizer.countTokens();
                if (n == 1) {
                    this.addWeight(new Integer(0), new Integer(string2));
                    break block7;
                }
                if (n == 2) {
                    int n2 = 0;
                    String string3 = "";
                    String string4 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        string3 = string3.trim();
                        if (n2 == 1) {
                            string4 = string3;
                        }
                        ++n2;
                    }
                    this.addWeight(new Integer(string4), new Integer(string2));
                    break block7;
                }
                throw new CategorisationException("weight attribute on rule is invalid:" + this.type);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CategorisationException("Check format of rule weights:" + this.type);
            }
            catch (Exception exception) {
                throw new CategorisationException(exception);
            }
        }
    }

    private String[] getConceptElement(Concept concept) {
        int n = 1;
        String[] stringArray = new String[n];
        stringArray[0] = concept.getId();
        return stringArray;
    }

    private String[] getSignPostElement(Concept concept) {
        try {
            Concept[] conceptArray = concept.getSignposts();
            int n = conceptArray.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = conceptArray[n2].getId();
                ++n2;
            }
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String[] getLinkElement(Concept concept) {
        try {
            Concept[] conceptArray = concept.getConcepts((String)this.attributeMap.get(ASSOCIATION_ATTRIBUTE));
            int n = conceptArray.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = conceptArray[n2].getId();
                ++n2;
            }
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type:" + this.type);
        stringBuffer.append("\nattributeMap:" + this.attributeMap.toString());
        stringBuffer.append("\nmorpher:" + this.morpher);
        stringBuffer.append("\nweightMap:" + this.weightMap.toString());
        return stringBuffer.toString();
    }
}

