/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.categorisation;

import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exteca.categorisation.CategorisationException;
import org.exteca.categorisation.DefaultRules;
import org.exteca.categorisation.DefaultRulesElement;
import org.exteca.categorisation.Markup;
import org.exteca.categorisation.MorphemeProcessor;
import org.exteca.categorisation.RuleProcessor;
import org.exteca.language.Morpher;
import org.exteca.language.Token;
import org.exteca.language.Tokeniser;
import org.exteca.language.Tokens;
import org.exteca.ontology.Concept;
import org.exteca.ontology.Ontology;
import org.exteca.ontology.OntologyException;
import org.exteca.ontology.Rule;
import org.exteca.ontology.rule.RuleListener;
import org.exteca.ontology.rule.RuleParser;
import org.exteca.pattern.AndRule;
import org.exteca.pattern.ConceptRule;
import org.exteca.pattern.MatchRule;
import org.exteca.pattern.OrRule;
import org.exteca.pattern.ProbabilityRule;
import org.exteca.pattern.RuleElement;
import org.exteca.pattern.RuleLeaf;
import org.exteca.pattern.RuleNode;
import org.exteca.pattern.SequenceRule;
import org.exteca.utils.Stack;

class OntologyRuleLoader
implements RuleListener {
    Log log = LogFactory.getLog((Class)(class$org$exteca$categorisation$OntologyRuleLoader == null ? (class$org$exteca$categorisation$OntologyRuleLoader = OntologyRuleLoader.class$("org.exteca.categorisation.OntologyRuleLoader")) : class$org$exteca$categorisation$OntologyRuleLoader));
    private RuleProcessor ruleProcessor;
    private Stack currentParents = new Stack();
    private MorphemeProcessor morphemeProcessor;
    private RuleParser logicParser = new RuleParser();
    private DefaultRules defaultRules = null;
    private Tokeniser tokeniser = null;
    static /* synthetic */ Class class$org$exteca$categorisation$OntologyRuleLoader;

    public OntologyRuleLoader(RuleProcessor ruleProcessor, MorphemeProcessor morphemeProcessor) {
        this.ruleProcessor = ruleProcessor;
        this.morphemeProcessor = morphemeProcessor;
        this.logicParser.addRuleListener((RuleListener)this);
    }

    public void load(Ontology ontology, DefaultRules defaultRules, Tokeniser tokeniser) throws OntologyException, CategorisationException {
        this.defaultRules = defaultRules;
        this.tokeniser = tokeniser;
        Concept[] conceptArray = ontology.getConcepts();
        int n = conceptArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.loadConcept(conceptArray[n2]);
            ++n2;
        }
    }

    private void loadConcept(Concept concept) throws OntologyException, CategorisationException {
        Concept[] conceptArray = concept.getSignpostsOf();
        if (conceptArray.length > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(concept.getId() + "=signpost - no conceptrule"));
            }
            return;
        }
        ConceptRule conceptRule = this.createConceptRule(concept);
        boolean bl = false;
        Rule[] ruleArray = concept.getRules();
        int n = ruleArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found rule " + ruleArray[n2].getLogic()));
            }
            this.addRuleLogic(ruleArray[n2].getLogic(), conceptRule);
            bl = true;
            ++n2;
        }
        if (this.defaultRules != null) {
            this.generateDefaultRules((RuleNode)conceptRule, concept, bl);
        }
        Concept[] conceptArray2 = concept.getChildren();
        n = conceptArray2.length;
        n2 = 0;
        while (n2 < n) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found child concept " + conceptArray2[n2]));
            }
            ConceptRule conceptRule2 = this.createConceptRule(conceptArray2[n2]);
            this.ruleProcessor.ruleNetwork.add((RuleElement)conceptRule2, (RuleNode)conceptRule);
            ++n2;
        }
    }

    private ConceptRule createConceptRule(Concept concept) {
        ConceptRule conceptRule = this.ruleProcessor.conceptDictionary.lookup(concept.getId());
        if (conceptRule == null) {
            conceptRule = new ConceptRule(this.ruleProcessor.ruleNetwork, 100);
            this.ruleProcessor.ruleNetwork.add((RuleElement)conceptRule, null);
            this.ruleProcessor.conceptDictionary.add(concept.getId(), conceptRule);
        }
        return conceptRule;
    }

    private void addRuleLogic(String string, ConceptRule conceptRule) throws CategorisationException {
        try {
            this.currentParents.push((Object)conceptRule);
            this.logicParser.parse(string.toCharArray());
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    private void generateDefaultRules(RuleNode ruleNode, Concept concept, boolean bl) throws CategorisationException {
        if (bl && !this.defaultRules.getGenerateRulesIfExist()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("NO default rules generated for concept:" + concept.getId()));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"");
            this.log.debug((Object)("generateDefaultRules:START OF CONCEPT:" + concept.getId()));
        }
        ListIterator listIterator = this.defaultRules.getDefaultRulesElementList().listIterator();
        DefaultRulesElement defaultRulesElement = null;
        while (listIterator.hasNext()) {
            defaultRulesElement = (DefaultRulesElement)listIterator.next();
            if (defaultRulesElement == null) continue;
            this.generateDefaultRulesElement(defaultRulesElement, ruleNode, concept);
        }
    }

    private void generateDefaultRulesElement(DefaultRulesElement defaultRulesElement, RuleNode ruleNode, Concept concept) throws CategorisationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("generateDefaultRulesElement:START OF RULETYPE" + defaultRulesElement));
        }
        String[] stringArray = null;
        Integer n = null;
        int n2 = 100;
        int n3 = 100;
        Tokens tokens = null;
        int n4 = 0;
        String string = "";
        SequenceRule sequenceRule = null;
        RuleLeaf ruleLeaf = null;
        Token token = null;
        Iterator iterator = null;
        stringArray = defaultRulesElement.getOntologyElements(concept);
        String string2 = defaultRulesElement.getMorpher();
        boolean bl = false;
        if (string2 != null && string2.length() != 0) {
            bl = true;
        }
        if (stringArray == null) {
            return;
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            tokens = new Tokens();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ontologyelement:" + stringArray[n5]));
            }
            try {
                this.tokeniser.tokenise(stringArray[n5], 0, tokens);
            }
            catch (Exception exception) {
                throw new CategorisationException(exception);
            }
            n4 = tokens.size();
            n = defaultRulesElement.getWeight(new Integer(n4));
            if (n4 > 1) {
                sequenceRule = new SequenceRule(this.ruleProcessor.ruleNetwork, n.intValue());
            }
            iterator = tokens.iterator();
            while (iterator.hasNext()) {
                token = (Token)iterator.next();
                string = token.getText();
                string = string.trim();
                string = string.toLowerCase();
                n3 = n4 == 1 ? n : n2;
                if (bl) {
                    string = this.getMorphemeText(string2, string);
                }
                ruleLeaf = new RuleLeaf(this.ruleProcessor.ruleNetwork, n3);
                this.ruleProcessor.leafDictionary.add(string, ruleLeaf);
                if (sequenceRule != null) {
                    this.ruleProcessor.ruleNetwork.add((RuleElement)ruleLeaf, (RuleNode)sequenceRule);
                    continue;
                }
                this.ruleProcessor.ruleNetwork.add((RuleElement)ruleLeaf, ruleNode);
            }
            if (sequenceRule != null) {
                this.ruleProcessor.ruleNetwork.add((RuleElement)sequenceRule, ruleNode);
            }
            ++n5;
        }
    }

    public void ruleStarted(String string, int n) {
        OrRule orRule;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("startRule " + string + ":" + n));
        }
        if (string.toLowerCase().equals("or")) {
            orRule = new OrRule(this.ruleProcessor.ruleNetwork, n);
        } else if (string.toLowerCase().equals("and")) {
            orRule = new AndRule(this.ruleProcessor.ruleNetwork, n);
        } else if (string.toLowerCase().equals("probability")) {
            orRule = new ProbabilityRule(this.ruleProcessor.ruleNetwork, n);
        } else if (string.toLowerCase().equals("sequence")) {
            orRule = new SequenceRule(this.ruleProcessor.ruleNetwork, n);
        } else {
            Markup markup = this.ruleProcessor.markupPlaceholders.add(string);
            orRule = new MatchRule(this.ruleProcessor.ruleNetwork, n, markup.spans);
        }
        this.ruleProcessor.ruleNetwork.add((RuleElement)orRule, (RuleNode)this.currentParents.top());
        this.currentParents.push((Object)orRule);
    }

    public void ruleEnded() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"endRule");
        }
        this.currentParents.pop();
    }

    public void textFound(String string, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("text " + string + ":" + n));
        }
        RuleLeaf ruleLeaf = new RuleLeaf(this.ruleProcessor.ruleNetwork, n);
        this.ruleProcessor.ruleNetwork.add((RuleElement)ruleLeaf, (RuleNode)this.currentParents.top());
        this.ruleProcessor.leafDictionary.add(string, ruleLeaf);
    }

    public void morphemeFound(String string, int n, String string2, boolean bl) {
        String string3;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("morph " + string2 + ":" + string + "," + n));
        }
        Morpher morpher = this.morphemeProcessor.getMorpher(string2);
        String string4 = string3 = this.morphemeProcessor.getPrefix(string2);
        string4 = bl ? string4 + string : string4 + morpher.morph(string);
        this.textFound(string4, n);
    }

    private String getMorphemeText(String string, String string2) {
        Morpher morpher = this.morphemeProcessor.getMorpher(string);
        if (morpher != null) {
            String string3;
            String string4 = string3 = this.morphemeProcessor.getPrefix(string);
            string4 = string4 + morpher.morph(string2);
            return string4;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

