/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.categorisation;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exteca.categorisation.Markups;
import org.exteca.language.Token;
import org.exteca.language.Tokeniser;
import org.exteca.language.Tokens;
import org.exteca.utils.Span;
import org.exteca.utils.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    Log log = LogFactory.getLog((Class)(class$org$exteca$categorisation$Parser == null ? (class$org$exteca$categorisation$Parser = Parser.class$("org.exteca.categorisation.Parser")) : class$org$exteca$categorisation$Parser));
    static /* synthetic */ Class class$org$exteca$categorisation$Parser;

    public void initialise() {
    }

    void parse(Reader reader, Tokeniser tokeniser, Tokens tokens, Markups markups) {
        try {
            XmlParser xmlParser = new XmlParser(tokeniser, tokens, markups);
            XMLReader xMLReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").newInstance();
            xMLReader.setContentHandler(xmlParser);
            xMLReader.setErrorHandler(xmlParser);
            xMLReader.parse(new InputSource(reader));
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class XmlParser
    extends DefaultHandler {
        private Tokeniser tokeniser;
        private Tokens tokens;
        private Markups markups;
        private Stack startTokenPosStack = new Stack();
        private int currentTokenPos;
        private int currentCharPos;
        private StringBuffer chars;

        XmlParser(Tokeniser tokeniser, Tokens tokens, Markups markups) {
            this.tokeniser = tokeniser;
            this.tokens = tokens;
            this.markups = markups;
        }

        public void startDocument() {
            this.currentTokenPos = 0;
            this.currentCharPos = 0;
        }

        public void endDocument() {
            if (this.tokens.size() > 0) {
                Token token = (Token)this.tokens.get(this.tokens.size() - 1);
                if (token.type != Token.SENT) {
                    this.tokens.add(new Token(Token.SENT, ".", token.endChar + 1, token.endChar + 1));
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (Parser.this.log.isDebugEnabled()) {
                Parser.this.log.debug((Object)("startElement '" + string2 + "'"));
            }
            if (this.chars != null) {
                try {
                    this.currentTokenPos += this.tokeniser.tokenise(this.chars, this.currentCharPos, this.tokens);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.currentCharPos += this.chars.length();
            }
            this.chars = new StringBuffer();
            this.startTokenPosStack.push((Object)new Integer(this.currentTokenPos));
        }

        public void endElement(String string, String string2, String string3) {
            if (Parser.this.log.isDebugEnabled()) {
                Parser.this.log.debug((Object)("endElement '" + string2 + "chars=" + this.chars + "'"));
            }
            try {
                this.currentTokenPos += this.tokeniser.tokenise(this.chars, this.currentCharPos, this.tokens);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentCharPos += this.chars.length();
            this.chars = new StringBuffer();
            Span span = new Span(((Integer)this.startTokenPosStack.pop()).intValue(), this.currentTokenPos - 1);
            this.markups.add(string2, span);
        }

        public void characters(char[] cArray, int n, int n2) {
            if (Parser.this.log.isDebugEnabled()) {
                Parser.this.log.debug((Object)("characters '" + new String(cArray, n, n2) + "'"));
            }
            this.chars.append(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }
}

