/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.categorisation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exteca.categorisation.CategorisationException;
import org.exteca.categorisation.ConceptDictionary;
import org.exteca.categorisation.ConceptResult;
import org.exteca.categorisation.ConceptResults;
import org.exteca.categorisation.DefaultRules;
import org.exteca.categorisation.LeafDictionary;
import org.exteca.categorisation.Markups;
import org.exteca.categorisation.MorphemeProcessor;
import org.exteca.categorisation.OntologyRuleLoader;
import org.exteca.language.Morpher;
import org.exteca.language.Token;
import org.exteca.language.Tokeniser;
import org.exteca.language.Tokens;
import org.exteca.ontology.Ontology;
import org.exteca.pattern.ConceptRule;
import org.exteca.pattern.ConceptRuntime;
import org.exteca.pattern.RuleElement;
import org.exteca.pattern.RuleLeaf;
import org.exteca.pattern.RuleLeafs;
import org.exteca.pattern.RuleNetwork;
import org.exteca.pattern.RuleNode;
import org.exteca.pattern.RuleTrigger;
import org.exteca.utils.Span;

public class RuleProcessor {
    Log log = LogFactory.getLog((Class)(class$org$exteca$categorisation$RuleProcessor == null ? (class$org$exteca$categorisation$RuleProcessor = RuleProcessor.class$("org.exteca.categorisation.RuleProcessor")) : class$org$exteca$categorisation$RuleProcessor));
    RuleNetwork ruleNetwork;
    LeafDictionary leafDictionary;
    ConceptDictionary conceptDictionary;
    Markups markupPlaceholders;
    MorphemeProcessor morphemeProcessor = new MorphemeProcessor();
    Map ruleToConcept;
    Map ruleToWord;
    static /* synthetic */ Class class$org$exteca$categorisation$RuleProcessor;

    public void load(Ontology ontology, DefaultRules defaultRules, Tokeniser tokeniser) throws CategorisationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RuleProcessor::load()");
        }
        try {
            this.ruleNetwork = new RuleNetwork();
            this.leafDictionary = new LeafDictionary();
            this.conceptDictionary = new ConceptDictionary();
            this.markupPlaceholders = new Markups();
            OntologyRuleLoader ontologyRuleLoader = new OntologyRuleLoader(this, this.morphemeProcessor);
            ontologyRuleLoader.load(ontology, defaultRules, tokeniser);
            this.ruleToConcept = null;
            this.ruleToWord = null;
        }
        catch (CategorisationException categorisationException) {
            throw categorisationException;
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    public void unload() throws CategorisationException {
        System.gc();
    }

    void process(Tokens tokens, Markups markups, ConceptResults conceptResults) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RuleProcessor::process()");
        }
        this.ruleNetwork.initialise(tokens.size());
        this.processTokens(tokens);
        this.processMarkups(markups);
        this.ruleNetwork.evaluate();
        this.extractConceptResults(conceptResults, tokens.size());
    }

    private void createRuleMaps() {
        String string;
        Map.Entry entry;
        Iterator iterator;
        if (this.ruleToConcept == null) {
            this.ruleToConcept = new HashMap();
            iterator = this.conceptDictionary.iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                string = (String)entry.getKey();
                this.ruleToConcept.put(entry.getValue(), string);
            }
            this.ruleNetwork.setRuleToConcept(this.ruleToConcept);
        }
        if (this.ruleToWord == null) {
            this.ruleToWord = new HashMap();
            iterator = this.leafDictionary.iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                string = (String)entry.getKey();
                RuleLeafs ruleLeafs = (RuleLeafs)entry.getValue();
                Iterator iterator2 = ruleLeafs.iterator();
                while (iterator2.hasNext()) {
                    RuleLeaf ruleLeaf = (RuleLeaf)iterator2.next();
                    this.ruleToWord.put(ruleLeaf, string);
                }
            }
            this.ruleNetwork.setRuleToWord(this.ruleToWord);
        }
    }

    public String explain() {
        this.createRuleMaps();
        return this.ruleNetwork.explain();
    }

    public String explain(String string) {
        this.createRuleMaps();
        ConceptRule conceptRule = this.conceptDictionary.lookup(string);
        if (conceptRule != null) {
            return this.ruleNetwork.explain((RuleNode)conceptRule);
        }
        return "";
    }

    private void processTokens(Tokens tokens) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RuleProcessor::processTokens()");
        }
        Iterator iterator = tokens.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            this.processToken(token.text.toLowerCase(), n);
            int n2 = this.morphemeProcessor.getNumMorphers();
            int n3 = 0;
            while (n3 < n2) {
                Morpher morpher = this.morphemeProcessor.getMorpher(n3);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)morpher.getName());
                }
                this.processToken(this.morphemeProcessor.getPrefix(n3) + morpher.morph(token.text), n);
                ++n3;
            }
            ++n;
        }
    }

    private void processToken(String string, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("token " + string + " (" + n + ")"));
        }
        Span span = new Span(n, n);
        RuleLeafs ruleLeafs = this.leafDictionary.lookup(string);
        if (ruleLeafs != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("found " + ruleLeafs.size() + " matching rules"));
            }
            Iterator iterator = ruleLeafs.iterator();
            while (iterator.hasNext()) {
                RuleLeaf ruleLeaf = (RuleLeaf)iterator.next();
                ruleLeaf.trigger(span);
            }
        }
    }

    private void processMarkups(Markups markups) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RuleProcessor::processMarkups()");
        }
    }

    private void extractConceptResults(ConceptResults conceptResults, int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RuleProcessor::extractConceptResults()");
        }
        Iterator iterator = this.conceptDictionary.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            ConceptRule conceptRule = (ConceptRule)entry.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RuleProcessor::process(): evaluating concept " + string));
            }
            ConceptRuntime conceptRuntime = this.ruleNetwork.getConceptRuntime(conceptRule);
            RuleTrigger ruleTrigger = this.ruleNetwork.getTrigger((RuleElement)conceptRule);
            if (ruleTrigger == null || conceptRuntime == null || ruleTrigger.score <= 0) continue;
            ConceptResult conceptResult = new ConceptResult(string, ruleTrigger.score, conceptRuntime.conceptRelevance, conceptRuntime.documentRelevance, conceptRuntime.defaultRelevance, ruleTrigger.spans);
            conceptResults.add(conceptResult);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

