/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk;

import fm.feed.android.playersdk.models.webservice.FeedFMError;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\b\u0080\u0001\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001e"}, d2={"Lfm/feed/android/playersdk/ApiErrorEnum;", "", "code", "", "message", "", "status", "(Ljava/lang/String;IILjava/lang/String;I)V", "getCode", "()I", "getMessage", "()Ljava/lang/String;", "getStatus", "toString", "INVALID_CREDENTIALS", "FORBIDDEN", "SKIP_LIMIT_REACHED", "END_OF_PLAYLIST", "CANT_SKIP_NO_PLAY", "INVALID_PARAMETER", "MISSING_PARAMETER", "NO_SUCH_OBJECT", "UNHANDLED_INTERNAL_ERROR", "NOT_IN_US", "PLAYBACK_ALREADY_STARTED", "PLAYBACK_COMPLETE", "THROTTLED", "NOT_ON_DEMAND", "FORMAT_UNAVAILABLE", "Companion", "PlayerSdk_exo2118Release"})
public final class ApiErrorEnum
extends Enum<ApiErrorEnum> {
    public static final /* enum */ ApiErrorEnum INVALID_CREDENTIALS;
    public static final /* enum */ ApiErrorEnum FORBIDDEN;
    public static final /* enum */ ApiErrorEnum SKIP_LIMIT_REACHED;
    public static final /* enum */ ApiErrorEnum END_OF_PLAYLIST;
    public static final /* enum */ ApiErrorEnum CANT_SKIP_NO_PLAY;
    public static final /* enum */ ApiErrorEnum INVALID_PARAMETER;
    public static final /* enum */ ApiErrorEnum MISSING_PARAMETER;
    public static final /* enum */ ApiErrorEnum NO_SUCH_OBJECT;
    public static final /* enum */ ApiErrorEnum UNHANDLED_INTERNAL_ERROR;
    public static final /* enum */ ApiErrorEnum NOT_IN_US;
    public static final /* enum */ ApiErrorEnum PLAYBACK_ALREADY_STARTED;
    public static final /* enum */ ApiErrorEnum PLAYBACK_COMPLETE;
    public static final /* enum */ ApiErrorEnum THROTTLED;
    public static final /* enum */ ApiErrorEnum NOT_ON_DEMAND;
    public static final /* enum */ ApiErrorEnum FORMAT_UNAVAILABLE;
    private static final /* synthetic */ ApiErrorEnum[] $VALUES;
    private final int code;
    @NotNull
    private final String message;
    private final int status;
    @NotNull
    public static final Companion Companion;

    static {
        ApiErrorEnum[] apiErrorEnumArray = new ApiErrorEnum[15];
        ApiErrorEnum[] apiErrorEnumArray2 = apiErrorEnumArray;
        apiErrorEnumArray[0] = INVALID_CREDENTIALS = new ApiErrorEnum(5, "Invalid credentials. Credentials are missing or invalid.", 401);
        apiErrorEnumArray[1] = FORBIDDEN = new ApiErrorEnum(6, "Forbidden. Access forbidden to the requested resource.", 401);
        apiErrorEnumArray[2] = SKIP_LIMIT_REACHED = new ApiErrorEnum(7, "User has reached their skip limit and may not skip this song.", 200);
        apiErrorEnumArray[3] = END_OF_PLAYLIST = new ApiErrorEnum(9, "End of available music. There is no more music that can be played from this station.", 200);
        apiErrorEnumArray[4] = CANT_SKIP_NO_PLAY = new ApiErrorEnum(12, "This play is not currently being played so we can't determine skippability.", 200);
        apiErrorEnumArray[5] = INVALID_PARAMETER = new ApiErrorEnum(15, "Invalid parameter value. See error message for details.", 400);
        apiErrorEnumArray[6] = MISSING_PARAMETER = new ApiErrorEnum(16, "400\tMissing required parameter. See error message for details.", 400);
        apiErrorEnumArray[7] = NO_SUCH_OBJECT = new ApiErrorEnum(17, "No such object. The requested resource couldn't be found.", 404);
        apiErrorEnumArray[8] = UNHANDLED_INTERNAL_ERROR = new ApiErrorEnum(18, "Unhandled internal error.", 500);
        apiErrorEnumArray[9] = NOT_IN_US = new ApiErrorEnum(19, "The client's IP address does not map to one in the United States, and so cannot play music.", 403);
        apiErrorEnumArray[10] = PLAYBACK_ALREADY_STARTED = new ApiErrorEnum(20, "Playback of this song has already started.", 403);
        apiErrorEnumArray[11] = PLAYBACK_COMPLETE = new ApiErrorEnum(21, "This play has already completed playback", 403);
        apiErrorEnumArray[12] = THROTTLED = new ApiErrorEnum(22, "You have exceeded normal request limits and are being throttled", 429);
        apiErrorEnumArray[13] = NOT_ON_DEMAND = new ApiErrorEnum(23, "This station is not on-demand", 403);
        apiErrorEnumArray[14] = FORMAT_UNAVAILABLE = new ApiErrorEnum(24, "Unable to find a version of this file that meets format and bitrate constriants", 200);
        $VALUES = apiErrorEnumArray;
        Companion = new Companion(null);
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "{type: \"Api Error\", code: %d, message: \"%s\", status: %s}";
        Object[] objectArray = new Object[]{this.code, this.message, this.status};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public final int getCode() {
        return this.code;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final int getStatus() {
        return this.status;
    }

    private ApiErrorEnum(int code, String message, int status) {
        this.code = code;
        this.message = message;
        this.status = status;
    }

    public static ApiErrorEnum[] values() {
        return (ApiErrorEnum[])$VALUES.clone();
    }

    public static ApiErrorEnum valueOf(String string) {
        return Enum.valueOf(ApiErrorEnum.class, string);
    }

    @JvmStatic
    @Nullable
    public static final ApiErrorEnum fromCode(int code) {
        return Companion.fromCode(code);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lfm/feed/android/playersdk/ApiErrorEnum$Companion;", "", "()V", "fromCode", "Lfm/feed/android/playersdk/ApiErrorEnum;", "code", "", "fromError", "error", "Lfm/feed/android/playersdk/models/webservice/FeedFMError;", "PlayerSdk_exo2118Release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final ApiErrorEnum fromCode(int code) {
            for (ApiErrorEnum apiError : ApiErrorEnum.values()) {
                if (apiError.getCode() != code) continue;
                return apiError;
            }
            return null;
        }

        @Nullable
        public final ApiErrorEnum fromError(@Nullable FeedFMError error) {
            if (error == null) {
                return null;
            }
            for (ApiErrorEnum apiError : ApiErrorEnum.values()) {
                if (apiError.getCode() != error.getCode()) continue;
                return apiError;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

