/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import fm.feed.android.playersdk.AvailabilityListener;
import fm.feed.android.playersdk.FMLog;
import fm.feed.android.playersdk.FeedAudioPlayer;
import fm.feed.android.playersdk.FeedPlayerService;
import fm.feed.android.playersdk.PlayerService;
import fm.feed.android.playersdk.State;
import fm.feed.android.playersdk.StateListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\r\u0010\u001a\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001c"}, d2={"Lfm/feed/android/playersdk/FeedPlayerService;", "", "()V", "feedAudioPlayer", "Lfm/feed/android/playersdk/FeedAudioPlayer;", "log", "Lfm/feed/android/playersdk/FMLog;", "mContext", "Landroid/content/Context;", "mPlayerService", "Lfm/feed/android/playersdk/PlayerService;", "mServerConn", "fm/feed/android/playersdk/FeedPlayerService$mServerConn$1", "Lfm/feed/android/playersdk/FeedPlayerService$mServerConn$1;", "getInstance", "", "listener", "Lfm/feed/android/playersdk/AvailabilityListener;", "initialize", "context", "token", "", "secret", "builder", "Lfm/feed/android/playersdk/FeedAudioPlayer$Builder;", "startService", "stopService", "stopService$PlayerSdk_exo2118Release", "PlayerSdk_exo2118Release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class FeedPlayerService {
    private static final FMLog log;
    private static FeedAudioPlayer feedAudioPlayer;
    private static PlayerService mPlayerService;
    private static Context mContext;
    private static final mServerConn.1 mServerConn;
    @NotNull
    public static final FeedPlayerService INSTANCE;

    @JvmStatic
    @NotNull
    public static final FeedAudioPlayer getInstance() {
        FeedAudioPlayer feedAudioPlayer = FeedPlayerService.feedAudioPlayer;
        Intrinsics.checkNotNull((Object)feedAudioPlayer);
        return feedAudioPlayer;
    }

    @JvmStatic
    public static final void initialize(@NotNull Context context, @NotNull String token, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        if (feedAudioPlayer != null) {
            FMLog.w$default(log, "initialize() called a second time, so resetting original player", null, 2, null);
            INSTANCE.stopService$PlayerSdk_exo2118Release();
            FeedAudioPlayer feedAudioPlayer = FeedPlayerService.feedAudioPlayer;
            if (feedAudioPlayer != null) {
                feedAudioPlayer.destroyInstance();
            }
            FeedPlayerService.feedAudioPlayer = null;
        }
        Context context2 = mContext = context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context2);
        FeedAudioPlayer feedAudioPlayer = FeedPlayerService.feedAudioPlayer = new FeedAudioPlayer(context2, token, secret);
        Intrinsics.checkNotNull((Object)feedAudioPlayer);
        feedAudioPlayer.addStateListener(new StateListener(){

            public void onStateChanged(@NotNull State state) {
                Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
                if (state == State.PAUSED && FeedPlayerService.access$getMPlayerService$p(FeedPlayerService.INSTANCE) != null) {
                    PlayerService playerService = FeedPlayerService.access$getMPlayerService$p(FeedPlayerService.INSTANCE);
                    Intrinsics.checkNotNull((Object)playerService);
                    playerService.stopForeground(false);
                } else if (state == State.PLAYING) {
                    FMLog.d$default(FeedPlayerService.access$getLog$p(FeedPlayerService.INSTANCE), "starting service", null, 2, null);
                    FeedPlayerService.access$startService(FeedPlayerService.INSTANCE);
                }
            }
        });
    }

    @JvmStatic
    public static final void initialize(@NotNull FeedAudioPlayer.Builder builder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            mContext = builder.getContext().getApplicationContext();
            feedAudioPlayer = builder.build();
            if (feedAudioPlayer == null) {
                throw (Throwable)new IllegalArgumentException("The builder provided to FeedPlayerService.initialize() wasn't fully configured, and build() returned null");
            }
            FeedAudioPlayer feedAudioPlayer = FeedPlayerService.feedAudioPlayer;
            if (feedAudioPlayer == null) break block1;
            feedAudioPlayer.addStateListener(new StateListener(){

                public void onStateChanged(@NotNull State state) {
                    Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
                    if (state == State.PAUSED && FeedPlayerService.access$getMPlayerService$p(FeedPlayerService.INSTANCE) != null) {
                        PlayerService playerService = FeedPlayerService.access$getMPlayerService$p(FeedPlayerService.INSTANCE);
                        Intrinsics.checkNotNull((Object)playerService);
                        playerService.stopForeground(false);
                    } else if (state == State.PLAYING) {
                        FMLog.d$default(FeedPlayerService.access$getLog$p(FeedPlayerService.INSTANCE), "starting service", null, 2, null);
                        FeedPlayerService.access$startService(FeedPlayerService.INSTANCE);
                    }
                }
            });
        }
    }

    @JvmStatic
    public static final void getInstance(@NotNull AvailabilityListener listener2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            if (feedAudioPlayer == null) break block1;
            FeedAudioPlayer feedAudioPlayer = FeedPlayerService.feedAudioPlayer;
            if (feedAudioPlayer != null) {
                feedAudioPlayer.addAvailabilityListener(listener2);
            }
        }
    }

    private final void startService() {
        if (mPlayerService == null) {
            Intent intent = new Intent(mContext, PlayerService.class);
            if (Build.VERSION.SDK_INT >= 26) {
                Context context = mContext;
                Intrinsics.checkNotNull((Object)context);
                context.startForegroundService(intent);
            } else {
                Context context = mContext;
                Intrinsics.checkNotNull((Object)context);
                context.startService(intent);
            }
            Context context = mContext;
            Intrinsics.checkNotNull((Object)context);
            context.bindService(intent, (ServiceConnection)mServerConn, 64);
        }
    }

    public final void stopService$PlayerSdk_exo2118Release() {
        if (mContext != null && mPlayerService != null) {
            Context context = mContext;
            Intrinsics.checkNotNull((Object)context);
            context.unbindService((ServiceConnection)mServerConn);
            PlayerService playerService = mPlayerService;
            Intrinsics.checkNotNull((Object)playerService);
            playerService.stopForeground(false);
            Context context2 = mContext;
            Intrinsics.checkNotNull((Object)context2);
            context2.stopService(new Intent(mContext, PlayerService.class));
            mPlayerService = null;
        }
    }

    private FeedPlayerService() {
    }

    static {
        FeedPlayerService feedPlayerService;
        INSTANCE = feedPlayerService = new FeedPlayerService();
        log = new FMLog("fm.feed.PlayerService");
        mServerConn = new ServiceConnection(){

            public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder binder) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                PlayerService.LocalBinder localBinder = (PlayerService.LocalBinder)binder;
                FeedPlayerService.access$setMPlayerService$p(FeedPlayerService.INSTANCE, localBinder.getPlayerInstance());
                PlayerService playerService = FeedPlayerService.access$getMPlayerService$p(FeedPlayerService.INSTANCE);
                Intrinsics.checkNotNull((Object)playerService);
                FeedAudioPlayer feedAudioPlayer = FeedPlayerService.access$getFeedAudioPlayer$p(FeedPlayerService.INSTANCE);
                Intrinsics.checkNotNull((Object)feedAudioPlayer);
                playerService.setPlayer(feedAudioPlayer);
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                FeedPlayerService.access$setMPlayerService$p(FeedPlayerService.INSTANCE, null);
            }
        };
    }

    public static final /* synthetic */ PlayerService access$getMPlayerService$p(FeedPlayerService $this) {
        FeedPlayerService feedPlayerService = $this;
        return mPlayerService;
    }

    public static final /* synthetic */ void access$setMPlayerService$p(FeedPlayerService $this, PlayerService playerService) {
        FeedPlayerService feedPlayerService = $this;
        mPlayerService = playerService;
    }

    public static final /* synthetic */ FMLog access$getLog$p(FeedPlayerService $this) {
        FeedPlayerService feedPlayerService = $this;
        return log;
    }

    public static final /* synthetic */ void access$startService(FeedPlayerService $this) {
        $this.startService();
    }

    public static final /* synthetic */ FeedAudioPlayer access$getFeedAudioPlayer$p(FeedPlayerService $this) {
        FeedPlayerService feedPlayerService = $this;
        return feedAudioPlayer;
    }

    public static final /* synthetic */ void access$setFeedAudioPlayer$p(FeedPlayerService $this, FeedAudioPlayer feedAudioPlayer) {
        FeedPlayerService feedPlayerService = $this;
        FeedPlayerService.feedAudioPlayer = feedAudioPlayer;
    }
}

