/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.google.gson.Gson;
import fm.feed.android.playersdk.ApiErrorEnum;
import fm.feed.android.playersdk.FMLog;
import fm.feed.android.playersdk.FeedAudioPlayer;
import fm.feed.android.playersdk.FeedSession$WhenMappings;
import fm.feed.android.playersdk.MockLocations;
import fm.feed.android.playersdk.RestApi;
import fm.feed.android.playersdk.SearchResults;
import fm.feed.android.playersdk.StationDownloadListener;
import fm.feed.android.playersdk.models.AudioFile;
import fm.feed.android.playersdk.models.CacheInfo;
import fm.feed.android.playersdk.models.Play;
import fm.feed.android.playersdk.models.Session;
import fm.feed.android.playersdk.models.Station;
import fm.feed.android.playersdk.models.TrackResults;
import fm.feed.android.playersdk.models.webservice.ClientResponse;
import fm.feed.android.playersdk.models.webservice.FeedFMError;
import fm.feed.android.playersdk.models.webservice.FeedFMResponse;
import fm.feed.android.playersdk.models.webservice.IDInfoResponse;
import fm.feed.android.playersdk.models.webservice.PlayResponse;
import fm.feed.android.playersdk.models.webservice.PlayStartResponse;
import fm.feed.android.playersdk.models.webservice.PrepareCacheResponse;
import fm.feed.android.playersdk.models.webservice.SearchResultsResponse;
import fm.feed.android.playersdk.models.webservice.SessionResponse;
import fm.feed.android.playersdk.models.webservice.SyncResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u009a\u00012\u00020\u0001:\u000e\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u009d\u0001\u009e\u0001B?\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\r\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\bJ\u0006\u0010L\u001a\u00020\u0016J\u0006\u0010M\u001a\u00020\u0016J\b\u0010N\u001a\u00020JH\u0002J,\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020D2\u0006\u0010Q\u001a\u00020.2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050C2\u0006\u0010S\u001a\u00020TJ\u0010\u0010U\u001a\u00020J2\b\u0010\u0007\u001a\u0004\u0018\u00010VJ\u0018\u0010W\u001a\u0004\u0018\u00010\u00052\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00050CH\u0002J\u001b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010P\u001a\u00020DH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J\u000e\u0010\\\u001a\u00020J2\u0006\u0010]\u001a\u00020\u0005J\u0016\u0010\\\u001a\u00020J2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0001J\u000e\u0010_\u001a\u00020J2\u0006\u0010`\u001a\u00020ZJ3\u0010a\u001a\u00020\u00162\b\u0010P\u001a\u0004\u0018\u00010D2\u0006\u0010`\u001a\u00020Z2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020.H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010eJ\u0006\u0010f\u001a\u00020JJ\u0014\u0010g\u001a\u00020J2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020D0CJ!\u0010i\u001a\u00020\u00162\u0006\u0010`\u001a\u00020Z2\u0006\u0010j\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010kJ'\u0010l\u001a\u0004\u0018\u00010Z2\b\u0010P\u001a\u0004\u0018\u00010D2\b\u0010m\u001a\u0004\u0018\u00010nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010oJ\u000e\u0010p\u001a\u00020J2\u0006\u0010m\u001a\u00020nJ\u0016\u0010p\u001a\u00020J2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\u0005J\u000e\u0010s\u001a\u00020J2\u0006\u0010`\u001a\u00020ZJ\u000e\u0010t\u001a\u00020J2\u0006\u0010m\u001a\u00020nJ\u000e\u0010t\u001a\u00020J2\u0006\u0010`\u001a\u00020ZJ\u0018\u0010t\u001a\u00020J2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\u0005H\u0002J\u0006\u0010u\u001a\u00020JJ\u001e\u0010v\u001a\u00020J2\u0006\u0010`\u001a\u00020Z2\u0006\u0010w\u001a\u00020=2\u0006\u0010x\u001a\u00020yJ\u000e\u0010z\u001a\u00020J2\u0006\u0010m\u001a\u00020nJ\u000e\u0010z\u001a\u00020J2\u0006\u0010`\u001a\u00020ZJ\u0016\u0010z\u001a\u00020J2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\u0005J\u0006\u0010{\u001a\u00020JJ\u0006\u0010|\u001a\u00020JJ;\u0010}\u001a\u0004\u0018\u00010~2\u0006\u0010\u007f\u001a\u00020\u00052\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020.2\u0007\u0010\u0083\u0001\u001a\u00020.H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0085\u0001J\u001c\u0010\u0086\u0001\u001a\u00020J2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\t\u0010\u0007\u001a\u0005\u0018\u00010\u0089\u0001J:\u0010\u008a\u0001\u001a\u00020J\"\n\b\u0000\u0010\u008b\u0001*\u00030\u008c\u00012\u000e\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u0003H\u008b\u0001082\u0013\u0010\u008e\u0001\u001a\u000e\u0012\u0005\u0012\u0003H\u008b\u00010\u008f\u0001R\u00020\u0000H\u0002JC\u0010\u008a\u0001\u001a\u00020J\"\n\b\u0000\u0010\u008b\u0001*\u00030\u008c\u00012\u000e\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u0003H\u008b\u0001082\u0007\u0010\u0090\u0001\u001a\u00020\u00162\u0013\u0010\u008e\u0001\u001a\u000e\u0012\u0005\u0012\u0003H\u008b\u00010\u008f\u0001R\u00020\u0000H\u0002J\u0017\u0010\u0091\u0001\u001a\u00020J2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J=\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u00012\u0006\u0010r\u001a\u00020\u00052\b\u0010\u0080\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0082\u0001\u001a\u00020.2\u0007\u0010\u0083\u0001\u001a\u00020.H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0095\u0001\u0010\u0096\u0001J\u0017\u0010\u0097\u0001\u001a\u00020J2\u0006\u0010`\u001a\u00020Z2\u0006\u0010w\u001a\u00020=R(\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR!\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00050#j\b\u0012\u0004\u0012\u00020\u0005`$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\b0#j\b\u0012\u0004\u0012\u00020\b`$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0012\u00100\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u001a\u00101\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0018\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030807X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001c\"\u0004\b;\u0010\u001eR\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR*\u0010E\u001a\b\u0012\u0004\u0012\u00020D0C2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0010\u0010H\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u009f\u0001"}, d2={"Lfm/feed/android/playersdk/FeedSession;", "", "context", "Landroid/content/Context;", "token", "", "secret", "listener", "Lfm/feed/android/playersdk/FeedSession$EventListener;", "clientId", "location", "Lfm/feed/android/playersdk/MockLocations;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lfm/feed/android/playersdk/FeedSession$EventListener;Ljava/lang/String;Lfm/feed/android/playersdk/MockLocations;)V", "mContext", "(Landroid/content/Context;)V", "getClientId", "()Ljava/lang/String;", "setClientId", "(Ljava/lang/String;)V", "clientIdCookie", "getClientIdCookie", "isAvailable", "", "()Ljava/lang/Boolean;", "log", "Lfm/feed/android/playersdk/FMLog;", "logEverything", "getLogEverything", "()Z", "setLogEverything", "(Z)V", "loggingEnabled", "getLoggingEnabled", "setLoggingEnabled", "mAudioFormat", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getMAudioFormat", "()Ljava/util/ArrayList;", "mCanSkipCurrent", "mCurrentSession", "Lfm/feed/android/playersdk/models/Session;", "mEncodedAuthorization", "mEventListeners", "mNextPlayInProgress", "mOfflinePlacement", "", "Ljava/lang/Integer;", "mPlacementId", "maxBitrate", "getMaxBitrate", "()I", "setMaxBitrate", "(I)V", "pendingRequests", "", "Lretrofit2/Call;", "remoteCrossfadeEnabled", "getRemoteCrossfadeEnabled", "setRemoteCrossfadeEnabled", "remoteCrossfadeTime", "", "getRemoteCrossfadeTime", "()F", "setRemoteCrossfadeTime", "(F)V", "<set-?>", "", "Lfm/feed/android/playersdk/models/Station;", "stationList", "getStationList", "()Ljava/util/List;", "testLocation", "addEventListener", "", "eventListener", "canRequestPlays", "canSkip", "cancelOutstandingRequests", "downloadAndSync", "station", "targetMins", "audioFileIds", "downloadListener", "Lfm/feed/android/playersdk/StationDownloadListener;", "generateClientId", "Lfm/feed/android/playersdk/FeedSession$ClientIdListener;", "getFormatString", "stringList", "getNextPlayForStation", "Lfm/feed/android/playersdk/models/Play;", "(Lfm/feed/android/playersdk/models/Station;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logEvent", "event", "parameters", "playCompleted", "play", "playStarted", "bufferingTime", "", "waitingTime", "(Lfm/feed/android/playersdk/models/Station;Lfm/feed/android/playersdk/models/Play;JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareCache", "prepareStationCache", "stations", "rejectPlay", "reason", "(Lfm/feed/android/playersdk/models/Play;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestAudioFile", "audioFile", "Lfm/feed/android/playersdk/models/AudioFile;", "(Lfm/feed/android/playersdk/models/Station;Lfm/feed/android/playersdk/models/AudioFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestDislike", "type", "id", "requestDislikeForItem", "requestLike", "requestSession", "requestSkip", "elapsedTime", "skipRequestListener", "Lfm/feed/android/playersdk/FeedSession$SkipRequestListener;", "requestUnlike", "reset", "resetSessionToNull", "search", "Lfm/feed/android/playersdk/SearchResults;", "query", "searchType", "Lfm/feed/android/playersdk/FeedAudioPlayer$SearchType;", "page", "resultsPerPage", "search$PlayerSdk_exo2118Release", "(Ljava/lang/String;Lfm/feed/android/playersdk/FeedAudioPlayer$SearchType;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendOfflineLogs", "logs", "Lorg/json/JSONArray;", "Lfm/feed/android/playersdk/FeedSession$OfflineLogsListener;", "sendRequest", "T", "Lfm/feed/android/playersdk/models/webservice/FeedFMResponse;", "call", "callback", "Lfm/feed/android/playersdk/FeedSession$WrappedCallback;", "cancellable", "setClientTokenAndSecret", "tracksForID", "Lfm/feed/android/playersdk/models/TrackResults;", "Lfm/feed/android/playersdk/FeedAudioPlayer$IDSearchType;", "tracksForID$PlayerSdk_exo2118Release", "(Ljava/lang/String;Lfm/feed/android/playersdk/FeedAudioPlayer$IDSearchType;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updatePlayTime", "CancelledRequest", "ClientIdListener", "Companion", "EventListener", "OfflineLogsListener", "SkipRequestListener", "WrappedCallback", "PlayerSdk_exo2118Release"})
public final class FeedSession {
    private final FMLog log;
    private String mEncodedAuthorization;
    private Session mCurrentSession;
    private boolean mCanSkipCurrent;
    private boolean mNextPlayInProgress;
    private int maxBitrate;
    private Integer mPlacementId;
    private Integer mOfflinePlacement;
    @NotNull
    private List<Station> stationList;
    private float remoteCrossfadeTime;
    private boolean remoteCrossfadeEnabled;
    private boolean loggingEnabled;
    private boolean logEverything;
    private List<Call<?>> pendingRequests;
    @NotNull
    private final ArrayList<String> mAudioFormat;
    private ArrayList<EventListener> mEventListeners;
    private String testLocation;
    private final Context mContext;
    private static final int FORCE_CODE = 1;
    private static final String AUDIO_FORMAT_MP3 = "mp3";
    private static final String AUDIO_FORMAT_AAC = "aac";
    private static final String AUDIO_FORMAT_M4A = "m4a";
    private static RestApi mRestApi;
    private static final String CLIENT_ID = "Client_id";
    @NotNull
    public static final Companion Companion;

    public final int getMaxBitrate() {
        return this.maxBitrate;
    }

    public final void setMaxBitrate(int n) {
        this.maxBitrate = n;
    }

    @NotNull
    public final List<Station> getStationList() {
        return this.stationList;
    }

    public final float getRemoteCrossfadeTime() {
        return this.remoteCrossfadeTime;
    }

    public final void setRemoteCrossfadeTime(float f) {
        this.remoteCrossfadeTime = f;
    }

    public final boolean getRemoteCrossfadeEnabled() {
        return this.remoteCrossfadeEnabled;
    }

    public final void setRemoteCrossfadeEnabled(boolean bl) {
        this.remoteCrossfadeEnabled = bl;
    }

    public final boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public final void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
    }

    public final boolean getLogEverything() {
        return this.logEverything;
    }

    public final void setLogEverything(boolean bl) {
        this.logEverything = bl;
    }

    @NotNull
    public final ArrayList<String> getMAudioFormat() {
        return this.mAudioFormat;
    }

    @Nullable
    public final Boolean isAvailable() {
        Session session = this.mCurrentSession;
        return session != null ? Boolean.valueOf(session.isAvailable()) : null;
    }

    @Nullable
    public final String getClientId() {
        return Companion.retrieveClientId(this.mContext);
    }

    public final void setClientId(@Nullable String clientId) {
        block1: {
            if (clientId == null && this.mCurrentSession != null) {
                throw (Throwable)new Error("cannot reset client id after session is created");
            }
            Companion.persistClientId(this.mContext, clientId);
            Session session = this.mCurrentSession;
            if (session == null) break block1;
            session.setClientId(clientId);
        }
    }

    private final String getClientIdCookie() {
        String currentClientId = this.getClientId();
        return currentClientId == null ? null : "cid=" + currentClientId;
    }

    public final void generateClientId(@Nullable ClientIdListener listener2) {
        Call<ClientResponse> call = mRestApi.createClient(this.mEncodedAuthorization, 1);
        this.sendRequest(call, new WrappedCallback<ClientResponse>(this, listener2){
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ ClientIdListener $listener;

            public void onSuccess(@NotNull ClientResponse response) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    ClientIdListener clientIdListener = this.$listener;
                    if (clientIdListener == null) break block0;
                    String string = response.getClientId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.clientId");
                    clientIdListener.onSuccess(string);
                }
            }

            public void onError(@NotNull Throwable t) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ClientIdListener clientIdListener = this.$listener;
                    if (clientIdListener == null) break block0;
                    clientIdListener.onError(t);
                }
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final <T extends FeedFMResponse> void sendRequest(Call<T> call, WrappedCallback<T> callback2) {
        this.sendRequest(call, true, callback2);
    }

    private final <T extends FeedFMResponse> void sendRequest(Call<T> call, boolean cancellable, WrappedCallback<T> callback2) {
        if (cancellable) {
            this.pendingRequests.add(call);
        }
        FMLog.d$default(this.log, call.request().method() + " " + call.request().url() + " with call " + call, null, 2, null);
        call.enqueue(new Callback<T>(this, cancellable, callback2){
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ WrappedCallback $callback;

            public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (this.$cancellable && !FeedSession.access$getPendingRequests$p(this.this$0).contains(call)) {
                    FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "call " + call + " was cancelled", null, 2, null);
                    this.$callback.onError(new CancelledRequest());
                    return;
                }
                FeedSession.access$getPendingRequests$p(this.this$0).remove(call);
                if (!response.isSuccessful()) {
                    FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "call " + call + " returned non 2xx response", null, 2, null);
                    String error = "";
                    try {
                        ResponseBody responseBody = response.errorBody();
                        Intrinsics.checkNotNull((Object)responseBody);
                        error = responseBody.string();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CharSequence charSequence = error;
                    boolean bl = false;
                    if (charSequence.length() == 0) {
                        error = "response was non-2xx response";
                    }
                    this.$callback.onError(new Error(error));
                } else {
                    FeedFMResponse body = (FeedFMResponse)response.body();
                    if (body == null) {
                        FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "call " + call + " returned null body in response", null, 2, null);
                        this.$callback.onError(new Error("Null body in response"));
                    } else if (body.isSuccess()) {
                        FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "call " + call + " succeeded! " + body, null, 2, null);
                        this.$callback.onSuccess(body);
                    } else {
                        FMLog.e$default(FeedSession.access$getLog$p(this.this$0), "call " + call + " returned error " + body, null, 2, null);
                        FeedFMError feedFMError = body.getError();
                        Intrinsics.checkNotNullExpressionValue((Object)feedFMError, (String)"body.error");
                        this.$callback.onError(feedFMError);
                    }
                }
            }

            public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (this.$cancellable && !FeedSession.access$getPendingRequests$p(this.this$0).contains(call)) {
                    FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "call returned failure, but was cancelled", null, 2, null);
                    this.$callback.onError(new CancelledRequest());
                    return;
                }
                FeedSession.access$getPendingRequests$p(this.this$0).remove(call);
                this.$callback.onError(t);
            }
            {
                this.this$0 = this$0;
                this.$cancellable = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        });
    }

    private final void cancelOutstandingRequests() {
        FMLog.d$default(this.log, "cancelling all outstanding requests", null, 2, null);
        List<Call<?>> pendingRequestsCopy = this.pendingRequests;
        this.pendingRequests = new ArrayList();
        for (Call<?> call : pendingRequestsCopy) {
            call.cancel();
        }
        pendingRequestsCopy.clear();
        this.mNextPlayInProgress = false;
    }

    public final void prepareStationCache(@NotNull List<Station> stations) {
        Intrinsics.checkNotNullParameter(stations, (String)"stations");
        ArrayList<String> strings = new ArrayList<String>();
        for (Station station : stations) {
            Integer n = station.getId();
            Intrinsics.checkNotNull((Object)n);
            strings.add(String.valueOf(n));
        }
        Call<PrepareCacheResponse> call = mRestApi.prepare(this.mEncodedAuthorization, this.getFormatString((List<String>)strings), this.mPlacementId, this.getClientIdCookie(), this.getFormatString((List<String>)this.mAudioFormat), this.maxBitrate);
        this.sendRequest(call, new WrappedCallback<PrepareCacheResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull PrepareCacheResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getCacheInfoList() != null) {
                    for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        List<CacheInfo> list = response.getCacheInfoList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"response.cacheInfoList");
                        listener2.cacheFilesAvailable(list);
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void prepareCache() {
        Call<PrepareCacheResponse> call = mRestApi.prepare(this.mEncodedAuthorization, null, this.mPlacementId, this.getClientIdCookie(), this.getFormatString((List<String>)this.mAudioFormat), this.maxBitrate);
        this.sendRequest(call, new WrappedCallback<PrepareCacheResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull PrepareCacheResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getCacheInfoList() != null) {
                    for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        List<CacheInfo> list = response.getCacheInfoList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"response.cacheInfoList");
                        listener2.cacheFilesAvailable(list);
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void downloadAndSync(@NotNull Station station, int targetMins, @NotNull List<String> audioFileIds, @NotNull StationDownloadListener downloadListener) {
        Intrinsics.checkNotNullParameter((Object)station, (String)"station");
        Intrinsics.checkNotNullParameter(audioFileIds, (String)"audioFileIds");
        Intrinsics.checkNotNullParameter((Object)downloadListener, (String)"downloadListener");
        Integer target = null;
        if (targetMins != -1) {
            target = targetMins;
        }
        Integer n = station.getId();
        Intrinsics.checkNotNull((Object)n);
        Call<SyncResponse> call = mRestApi.downloadAndSync(this.mEncodedAuthorization, String.valueOf(n), this.mOfflinePlacement, this.getClientIdCookie(), this.getFormatString((List<String>)this.mAudioFormat), this.maxBitrate, target, this.getFormatString(audioFileIds));
        this.sendRequest(call, new WrappedCallback<SyncResponse>(this, station, downloadListener){
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Station $station;
            final /* synthetic */ StationDownloadListener $downloadListener;

            public void onSuccess(@NotNull SyncResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getAudioFileList() != null) {
                    this.$station.setAudioFiles(response.getAudioFileList());
                    for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        listener2.stationInfoAvailable(this.$station, this.$downloadListener);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$station = $captured_local_variable$1;
                this.$downloadListener = $captured_local_variable$2;
            }
        });
    }

    public final void requestSession() {
        Call<SessionResponse> call = mRestApi.createSession(this.mEncodedAuthorization, this.getClientIdCookie(), 1, this.testLocation);
        this.sendRequest(call, new WrappedCallback<SessionResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull SessionResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Session session = response.getSession();
                List<Station> remoteOfflineStations = response.getRemoteOfflineStations();
                if (remoteOfflineStations != null) {
                    for (Station station : remoteOfflineStations) {
                        station.setOfflineType(true);
                    }
                    FeedSession.access$setMOfflinePlacement$p(this.this$0, response.getOfflinePlacement().getId());
                    for (Object listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        listener2.remoteOfflineStationListAvailable(remoteOfflineStations);
                    }
                }
                if (session.isAvailable()) {
                    this.this$0.setLoggingEnabled(session.getLoggingEnabled());
                    this.this$0.setLogEverything(session.getLogEverything());
                    this.this$0.setClientId(session.getClientId());
                    List<Station> list = response.getStations();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"response.stations");
                    FeedSession.access$setStationList$p(this.this$0, list);
                    FeedSession.access$setMPlacementId$p(this.this$0, response.getPlacement().getId());
                    if (response.getPlacement().containsOption("crossfade_seconds")) {
                        Object listener2;
                        this.this$0.setRemoteCrossfadeEnabled(true);
                        Object object = response.getPlacement().getOption("crossfade_seconds");
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        listener2 = (String)object;
                        boolean bl = false;
                        this.this$0.setRemoteCrossfadeTime(Float.parseFloat((String)listener2));
                    }
                    FeedSession.access$setMCurrentSession$p(this.this$0, session);
                    if (this.this$0.getStationList().isEmpty()) {
                        FMLog.e$default(FeedSession.access$getLog$p(this.this$0), "no stations returned with station", null, 2, null);
                    }
                    for (Object listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        listener2.stationListAvailable(this.this$0.getStationList());
                        listener2.sessionAvailable();
                    }
                } else {
                    for (Object listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        listener2.sessionNotAvailable(new Exception(session.getMessage()));
                    }
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (!t.getClass().isInstance(new CancelledRequest())) {
                    for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        listener2.sessionNotAvailable(new Exception(t));
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void sendOfflineLogs(@NotNull JSONArray logs, @Nullable OfflineLogsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)logs, (String)"logs");
        JSONObject object = null;
        try {
            JSONObject jSONObject = new JSONObject().put("events", (Object)logs);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"JSONObject().put(\"events\", logs)");
            object = jSONObject;
            String string = object.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"`object`.toString()");
            RequestBody body = RequestBody.Companion.create(string, MediaType.Companion.parse("application/json; charset=utf-8"));
            Call<FeedFMResponse> call = mRestApi.sendLogs(this.mEncodedAuthorization, this.getClientIdCookie(), body);
            this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this, listener2, logs){
                final /* synthetic */ FeedSession this$0;
                final /* synthetic */ OfflineLogsListener $listener;
                final /* synthetic */ JSONArray $logs;

                public void onSuccess(@NotNull FeedFMResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    FMLog fMLog = FeedSession.access$getLog$p(this.this$0);
                    String string = response.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.toString()");
                    FMLog.i$default(fMLog, string, null, 2, null);
                }

                public void onError(@NotNull Throwable t) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        FMLog.w$default(FeedSession.access$getLog$p(this.this$0), "Log storage failed", null, 2, null);
                        OfflineLogsListener offlineLogsListener = this.$listener;
                        if (offlineLogsListener == null) break block0;
                        offlineLogsListener.offlineLogSaveFailed(this.$logs);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$listener = $captured_local_variable$1;
                    this.$logs = $captured_local_variable$2;
                }
            });
        }
        catch (JSONException e) {
            FMLog.e$default(this.log, "Problem parsing offline logs " + e.getMessage(), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object search$PlayerSdk_exo2118Release(@NotNull String query, @NotNull FeedAudioPlayer.SearchType searchType, int page, int resultsPerPage, @NotNull Continuation<? super SearchResults> $completion) {
        void call;
        String string;
        boolean bl;
        String string2;
        switch (FeedSession$WhenMappings.$EnumSwitchMapping$0[searchType.ordinal()]) {
            case 1: {
                string2 = FeedAudioPlayer.SearchType.ALL.name();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(locale2);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                break;
            }
            case 2: {
                string2 = FeedAudioPlayer.SearchType.TRACK.name();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string6 = string3;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase(locale2);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
                break;
            }
            case 3: {
                string2 = FeedAudioPlayer.SearchType.ARTIST.name();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string8 = string3;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.toLowerCase(locale2);
                string = string9;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase(locale)");
                break;
            }
            case 4: {
                string2 = FeedAudioPlayer.SearchType.RELEASE.name();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string10 = string3;
                if (string10 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string11 = string10.toLowerCase(locale2);
                string = string11;
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).toLowerCase(locale)");
                break;
            }
            case 5: {
                string2 = FeedAudioPlayer.SearchType.PLAYLIST.name();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string12 = string3;
                if (string12 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string13 = string12.toLowerCase(locale2);
                string = string13;
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.String).toLowerCase(locale)");
                break;
            }
            case 6: {
                string2 = FeedAudioPlayer.SearchType.STATION.name();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string14 = string3;
                if (string14 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string15 = string14.toLowerCase(locale2);
                string = string15;
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"(this as java.lang.String).toLowerCase(locale)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String type = string;
        string2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)string2).element = mRestApi.search(this.mEncodedAuthorization, this.getClientIdCookie(), this.mPlacementId, query, Boxing.boxInt((int)page), Boxing.boxInt((int)resultsPerPage), type, Boxing.boxInt((int)1));
        boolean bl3 = false;
        bl = false;
        Continuation<? super SearchResults> continuation = $completion;
        boolean bl4 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl5 = false;
        this.sendRequest((Call)call.element, false, new WrappedCallback<SearchResultsResponse>(continuation2, this, (Ref.ObjectRef)call){
            final /* synthetic */ Continuation $continuation;
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Ref.ObjectRef $call$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.this$0 = feedSession;
                this.$call$inlined = objectRef;
            }

            public void onSuccess(@NotNull SearchResultsResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getResults() != null && response.isSuccess()) {
                    Continuation continuation = this.$continuation;
                    SearchResults searchResults = response.getResults();
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)searchResults));
                } else {
                    Continuation continuation = this.$continuation;
                    Object var3_5 = null;
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl(var3_5));
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                super.onError(t);
                Continuation continuation = this.$continuation;
                Object var3_3 = null;
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl2 = false;
                continuation.resumeWith(Result.constructor-impl(var3_3));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object tracksForID$PlayerSdk_exo2118Release(@NotNull String id, @NotNull FeedAudioPlayer.IDSearchType searchType, int page, int resultsPerPage, @NotNull Continuation<? super TrackResults> $completion) {
        void call;
        Call<IDInfoResponse> call2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        switch (FeedSession$WhenMappings.$EnumSwitchMapping$1[searchType.ordinal()]) {
            case 1: {
                call2 = mRestApi.artistTracks(this.mEncodedAuthorization, this.getClientIdCookie(), id, this.mPlacementId, Boxing.boxInt((int)page), Boxing.boxInt((int)resultsPerPage), Boxing.boxInt((int)1));
                break;
            }
            case 2: {
                call2 = mRestApi.releaseTracks(this.mEncodedAuthorization, this.getClientIdCookie(), id, this.mPlacementId, Boxing.boxInt((int)page), Boxing.boxInt((int)resultsPerPage), Boxing.boxInt((int)1));
                break;
            }
            case 3: {
                call2 = mRestApi.playlistTracks(this.mEncodedAuthorization, this.getClientIdCookie(), id, this.mPlacementId, Boxing.boxInt((int)page), Boxing.boxInt((int)resultsPerPage), Boxing.boxInt((int)1));
                break;
            }
            case 4: {
                call2 = mRestApi.stationTracks(this.mEncodedAuthorization, this.getClientIdCookie(), id, this.mPlacementId, Boxing.boxInt((int)page), Boxing.boxInt((int)resultsPerPage), Boxing.boxInt((int)1));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        objectRef.element = call2;
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super TrackResults> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl4 = false;
        this.sendRequest((Call)call.element, false, new WrappedCallback<IDInfoResponse>(continuation2, this, (Ref.ObjectRef)call){
            final /* synthetic */ Continuation $continuation;
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Ref.ObjectRef $call$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.this$0 = feedSession;
                this.$call$inlined = objectRef;
            }

            public void onSuccess(@NotNull IDInfoResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getResults() != null && response.isSuccess()) {
                    Continuation continuation = this.$continuation;
                    TrackResults trackResults = response.getResults();
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)trackResults));
                } else {
                    Continuation continuation = this.$continuation;
                    Object var3_5 = null;
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl(var3_5));
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                super.onError(t);
                Continuation continuation = this.$continuation;
                Object var3_3 = null;
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl2 = false;
                continuation.resumeWith(Result.constructor-impl(var3_3));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void addEventListener(@NotNull EventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.mEventListeners.add(eventListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canRequestPlays() {
        if (this.mCurrentSession == null) return false;
        String string = this.mEncodedAuthorization;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() != 0) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object getNextPlayForStation(@NotNull Station station, @NotNull Continuation<? super Play> $completion) {
        void call;
        if (this.mCurrentSession == null) {
            FMLog.e$default(this.log, "cannot request next item with no current session", null, 2, null);
            return null;
        }
        String str = this.getFormatString((List<String>)this.mAudioFormat);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = mRestApi.getPlayWithID(this.mEncodedAuthorization, this.getClientIdCookie(), this.mPlacementId, null, station.getId(), str, Boxing.boxInt((int)this.maxBitrate), Boxing.boxInt((int)1));
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super Play> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl4 = false;
        this.sendRequest((Call)call.element, new WrappedCallback<PlayResponse>(continuation2, this, (Ref.ObjectRef)call){
            final /* synthetic */ Continuation $continuation;
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Ref.ObjectRef $call$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.this$0 = feedSession;
                this.$call$inlined = objectRef;
            }

            public void onSuccess(@NotNull PlayResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.getError() != null) {
                    FeedFMError feedFMError = response.getError();
                    Intrinsics.checkNotNullExpressionValue((Object)feedFMError, (String)"response.error");
                    if (feedFMError.getCode() == ApiErrorEnum.END_OF_PLAYLIST.getCode()) {
                        Object listener22;
                        FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "end of playlist for a new station", null, 2, null);
                        for (Object listener22 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            listener22.noMoreMusic();
                        }
                        listener22 = this.$continuation;
                        Iterator<E> iterator = null;
                        boolean bl = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl2 = false;
                        listener22.resumeWith(Result.constructor-impl(iterator));
                    } else {
                        Object listener32;
                        FMLog.e$default(FeedSession.access$getLog$p(this.this$0), "unexpected error " + response.getError().getMessage(), null, 2, null);
                        for (Object listener32 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            FeedFMError feedFMError2 = response.getError();
                            Intrinsics.checkNotNullExpressionValue((Object)feedFMError2, (String)"response.error");
                            listener32.unexpectedError(feedFMError2);
                        }
                        listener32 = this.$continuation;
                        Iterator<E> iterator = null;
                        boolean bl = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl3 = false;
                        listener32.resumeWith(Result.constructor-impl(iterator));
                    }
                } else {
                    Play play2 = response.getPlay();
                    if (play2 == null) {
                        FMLog.e$default(FeedSession.access$getLog$p(this.this$0), "returned play was null!", null, 2, null);
                        Exception ex = new Exception("Next play was null");
                        for (EventListener listener4 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            listener4.unexpectedError(ex);
                        }
                        Continuation continuation = this.$continuation;
                        Iterator<E> iterator = null;
                        boolean bl = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl4 = false;
                        continuation.resumeWith(Result.constructor-impl(iterator));
                    } else {
                        FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "Got new play" + response.getPlay().toString(), null, 2, null);
                        Continuation continuation = this.$continuation;
                        boolean bl = false;
                        Result.Companion companion = Result.Companion;
                        boolean bl5 = false;
                        continuation.resumeWith(Result.constructor-impl((Object)play2));
                    }
                }
            }

            public void onError(@NotNull Throwable t) {
                boolean bl;
                String string;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                String string2 = t.getMessage();
                if (string2 != null) {
                    string = string2;
                    boolean bl2 = false;
                    bl = false;
                    String it = string;
                    boolean bl3 = false;
                    if (StringsKt.contains((CharSequence)it, (CharSequence)"This station may not be played more than once", (boolean)true) || StringsKt.contains((CharSequence)it, (CharSequence)"End of available music", (boolean)true) || StringsKt.contains((CharSequence)it, (CharSequence)"Either no songs match requested format/bitrate", (boolean)true)) {
                        FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "end of playlist for a station", null, 2, null);
                        for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            listener2.noMoreMusic();
                        }
                    } else {
                        FMLog.e$default(FeedSession.access$getLog$p(this.this$0), "unexpected error " + it, null, 2, null);
                        for (EventListener listener3 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            listener3.unexpectedError(new Exception(t));
                        }
                    }
                }
                string = this.$continuation;
                Object var3_4 = null;
                bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                string.resumeWith(Result.constructor-impl(var3_4));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object requestAudioFile(@Nullable Station station, @Nullable AudioFile audioFile, @NotNull Continuation<? super Play> $completion) {
        void call;
        if (this.mCurrentSession == null) {
            FMLog.e$default(this.log, "cannot request next item with no current session", null, 2, null);
            return null;
        }
        if (this.mNextPlayInProgress) {
            FMLog.d$default(this.log, "next item request already in progress", null, 2, null);
            return null;
        }
        this.mNextPlayInProgress = true;
        String str = this.getFormatString((List<String>)this.mAudioFormat);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        AudioFile audioFile2 = audioFile;
        Station station2 = station;
        objectRef.element = mRestApi.getPlayWithID(this.mEncodedAuthorization, this.getClientIdCookie(), this.mPlacementId, audioFile2 != null ? audioFile2.getId() : null, station2 != null ? station2.getId() : null, str, Boxing.boxInt((int)this.maxBitrate), Boxing.boxInt((int)1));
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super Play> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl4 = false;
        this.sendRequest((Call)call.element, new WrappedCallback<PlayResponse>(continuation2, this, (Ref.ObjectRef)call){
            final /* synthetic */ Continuation $continuation;
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Ref.ObjectRef $call$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.this$0 = feedSession;
                this.$call$inlined = objectRef;
            }

            public void onSuccess(@NotNull PlayResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                FeedSession.access$setMNextPlayInProgress$p(this.this$0, false);
                FMLog.e$default(FeedSession.access$getLog$p(this.this$0), response.getPlay().toString(), null, 2, null);
                Continuation continuation = this.$continuation;
                Play play2 = response.getPlay();
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl2 = false;
                continuation.resumeWith(Result.constructor-impl((Object)play2));
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof CancelledRequest) {
                    FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "audio file request cancelled", null, 2, null);
                    return;
                }
                FeedSession.access$setMNextPlayInProgress$p(this.this$0, false);
                if (t instanceof FeedFMError && ((FeedFMError)t).getCode() == ApiErrorEnum.END_OF_PLAYLIST.getCode()) {
                    FMLog.d$default(FeedSession.access$getLog$p(this.this$0), "end of playlist", null, 2, null);
                    for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                        listener2.noMoreMusic();
                    }
                } else {
                    FMLog.e$default(FeedSession.access$getLog$p(this.this$0), "error while retrieving next play: " + t, null, 2, null);
                }
                Continuation continuation = this.$continuation;
                Iterator<E> iterator = null;
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                boolean bl2 = false;
                continuation.resumeWith(Result.constructor-impl(iterator));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final String getFormatString(List<String> stringList) {
        int i;
        StringBuilder sAudioFormat = new StringBuilder();
        int n = 0;
        int n2 = ((Collection)stringList).size();
        while (n < n2) {
            sAudioFormat.append(stringList.get(i));
            sAudioFormat.append(",");
            ++i;
        }
        i = sAudioFormat.lastIndexOf(",");
        if (i != -1) {
            sAudioFormat.deleteCharAt(i);
            return sAudioFormat.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object playStarted(@Nullable Station station, @NotNull Play play2, long bufferingTime, int waitingTime, @NotNull Continuation<? super Boolean> $completion) {
        void call;
        FMLog.d$default(this.log, "Play ID Started = " + play2, null, 2, null);
        Station station2 = station;
        if (station2 != null) {
            station2.setLastPlayStart(new Date());
        }
        for (Station st : this.stationList) {
            if (!Intrinsics.areEqual((Object)st, (Object)station)) continue;
            st.setLastPlayStart(new Date());
        }
        Integer time = null;
        Integer bufferTime = null;
        if (waitingTime >= 0) {
            time = Boxing.boxInt((int)waitingTime);
        }
        if (bufferingTime >= 0L) {
            bufferTime = Boxing.boxInt((int)((int)bufferingTime));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = mRestApi.playStarted(this.mEncodedAuthorization, this.getClientIdCookie(), play2.getId(), bufferTime, time, Boxing.boxInt((int)1));
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super Boolean> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl4 = false;
        this.sendRequest((Call)call.element, new WrappedCallback<PlayStartResponse>(continuation2, this, (Ref.ObjectRef)call){
            final /* synthetic */ Continuation $continuation;
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Ref.ObjectRef $call$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.this$0 = feedSession;
                this.$call$inlined = objectRef;
            }

            public void onSuccess(@NotNull PlayStartResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.isSuccess()) {
                    if (response.getError() != null) {
                        for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            FeedFMError feedFMError = response.getError();
                            Intrinsics.checkNotNullExpressionValue((Object)feedFMError, (String)"response.error");
                            listener2.unexpectedError(feedFMError);
                        }
                    }
                    if (response.canSkip() != FeedSession.access$getMCanSkipCurrent$p(this.this$0)) {
                        FeedSession.access$setMCanSkipCurrent$p(this.this$0, response.canSkip());
                        for (EventListener listener2 : FeedSession.access$getMEventListeners$p(this.this$0)) {
                            listener2.skipStatusDidChange(FeedSession.access$getMCanSkipCurrent$p(this.this$0));
                        }
                    }
                    Continuation continuation = this.$continuation;
                    Iterator<E> iterator = true;
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    continuation.resumeWith(Result.constructor-impl(iterator));
                } else {
                    Continuation continuation = this.$continuation;
                    Boolean bl = false;
                    boolean bl3 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)bl));
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                super.onError(t);
                Continuation continuation = this.$continuation;
                Boolean bl = false;
                boolean bl2 = false;
                Result.Companion companion = Result.Companion;
                boolean bl3 = false;
                continuation.resumeWith(Result.constructor-impl((Object)bl));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void updatePlayTime(@NotNull Play play2, float elapsedTime) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
        Call<FeedFMResponse> call = mRestApi.elapsed(this.mEncodedAuthorization, play2.getId(), Float.valueOf(elapsedTime), this.getClientIdCookie(), Float.valueOf(play2.getAudioFile().getDurationInSeconds()), 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void playCompleted(@NotNull Play play2) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
        String playId = play2.getId();
        FMLog.d$default(this.log, "Play ID completed = " + play2, null, 2, null);
        Call<FeedFMResponse> call = mRestApi.playCompleted(this.mEncodedAuthorization, this.getClientIdCookie(), playId, 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void requestSkip(@NotNull Play play2, float elapsedTime, @NotNull SkipRequestListener skipRequestListener) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
        Intrinsics.checkNotNullParameter((Object)skipRequestListener, (String)"skipRequestListener");
        Call<FeedFMResponse> call = mRestApi.skip(this.mEncodedAuthorization, play2.getId(), Float.valueOf(elapsedTime), this.getClientIdCookie(), 1, 0);
        this.sendRequest(call, new WrappedCallback<FeedFMResponse>(this, skipRequestListener){
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ SkipRequestListener $skipRequestListener;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$skipRequestListener.onSuccess();
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof FeedFMError && ((FeedFMError)t).getCode() == ApiErrorEnum.SKIP_LIMIT_REACHED.getCode()) {
                    FeedSession.access$setMCanSkipCurrent$p(this.this$0, false);
                }
                this.$skipRequestListener.onFailure(new Exception(t.getMessage()));
            }
            {
                this.this$0 = this$0;
                this.$skipRequestListener = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object rejectPlay(@NotNull Play play2, @NotNull String reason, @NotNull Continuation<? super Boolean> $completion) {
        void call;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = mRestApi.invalidate(this.mEncodedAuthorization, play2.getId(), this.getClientIdCookie(), reason, Boxing.boxInt((int)1));
        boolean bl = false;
        boolean bl2 = false;
        Continuation<? super Boolean> continuation = $completion;
        boolean bl3 = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl4 = false;
        this.sendRequest((Call)call.element, new WrappedCallback<FeedFMResponse>(continuation2, this, (Ref.ObjectRef)call){
            final /* synthetic */ Continuation $continuation;
            final /* synthetic */ FeedSession this$0;
            final /* synthetic */ Ref.ObjectRef $call$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.this$0 = feedSession;
                this.$call$inlined = objectRef;
            }

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.isSuccess()) {
                    Continuation continuation = this.$continuation;
                    Boolean bl = true;
                    boolean bl2 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl3 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)bl));
                } else {
                    Continuation continuation = this.$continuation;
                    Boolean bl = false;
                    boolean bl4 = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl5 = false;
                    continuation.resumeWith(Result.constructor-impl((Object)bl));
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                super.onError(t);
                Continuation continuation = this.$continuation;
                Boolean bl = false;
                boolean bl2 = false;
                Result.Companion companion = Result.Companion;
                boolean bl3 = false;
                continuation.resumeWith(Result.constructor-impl((Object)bl));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void requestLike(@NotNull Play play2) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
        this.requestLike("play", play2.getId());
    }

    public final void requestLike(@NotNull AudioFile audioFile) {
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        this.requestLike("audio_file", audioFile.getId());
    }

    private final void requestLike(String type, String id) {
        Call<FeedFMResponse> call = mRestApi.like(this.mEncodedAuthorization, this.getClientIdCookie(), type, id, 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void requestUnlike(@NotNull Play play2) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
        this.requestUnlike("play", play2.getId());
    }

    public final void requestUnlike(@NotNull AudioFile audioFile) {
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        this.requestUnlike("audio_file", audioFile.getId());
    }

    public final void requestUnlike(@NotNull String type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Call<FeedFMResponse> call = mRestApi.unlike(this.mEncodedAuthorization, this.getClientIdCookie(), type, id, 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void requestDislikeForItem(@NotNull Play play2) {
        Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
        this.requestDislike("play", play2.getId());
    }

    public final void requestDislike(@NotNull AudioFile audioFile) {
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        this.requestDislike("audio_file", audioFile.getId());
    }

    public final void requestDislike(@NotNull String type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Call<FeedFMResponse> call = mRestApi.dislike(this.mEncodedAuthorization, this.getClientIdCookie(), type, id, 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final boolean canSkip() {
        return this.mCanSkipCurrent;
    }

    public final void setClientTokenAndSecret(@NotNull String token, @NotNull String secret) {
        String concat;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        String string = concat = token + ':' + secret;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.mEncodedAuthorization = Base64.encodeToString((byte[])byArray, (int)2);
        StringBuilder stringBuilder = new StringBuilder().append("Basic ");
        String string3 = this.mEncodedAuthorization;
        Intrinsics.checkNotNull((Object)string3);
        this.mEncodedAuthorization = stringBuilder.append(string3).toString();
    }

    public final void logEvent(@NotNull String event, @NotNull Object parameters) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Gson gson = new Gson();
        String parametersAsJSON = gson.toJson(parameters);
        Call<FeedFMResponse> call = mRestApi.logEvent(this.mEncodedAuthorization, this.getClientIdCookie(), event, parametersAsJSON, 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                FMLog fMLog = FeedSession.access$getLog$p(this.this$0);
                String string = response.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.toString()");
                FMLog.v$default(fMLog, string, null, 2, null);
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                FMLog.v$default(FeedSession.access$getLog$p(this.this$0), t.toString(), null, 2, null);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void logEvent(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Call<FeedFMResponse> call = mRestApi.logEvent(this.mEncodedAuthorization, this.getClientIdCookie(), event, 1);
        this.sendRequest(call, false, new WrappedCallback<FeedFMResponse>(this){
            final /* synthetic */ FeedSession this$0;

            public void onSuccess(@NotNull FeedFMResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void reset() {
        this.cancelOutstandingRequests();
    }

    public final void resetSessionToNull() {
        this.reset();
        this.mCurrentSession = null;
    }

    public FeedSession(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.log = new FMLog("fm.feed.FeedSession");
        this.maxBitrate = 128;
        this.stationList = CollectionsKt.emptyList();
        this.pendingRequests = new ArrayList();
        this.mAudioFormat = new ArrayList();
        this.mEventListeners = new ArrayList();
        RestApi.Companion.getHttpLog().level(HttpLoggingInterceptor.Level.BODY);
        this.mAudioFormat.add(AUDIO_FORMAT_AAC);
        this.mAudioFormat.add(AUDIO_FORMAT_MP3);
        this.mAudioFormat.add(AUDIO_FORMAT_M4A);
        this.mNextPlayInProgress = false;
        this.mCanSkipCurrent = true;
    }

    @JvmOverloads
    public FeedSession(@NotNull Context context, @NotNull String token, @NotNull String secret, @NotNull EventListener listener2, @Nullable String clientId, @Nullable MockLocations location) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this(context);
        if (location != null) {
            String string = location.name();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            this.testLocation = string4;
        }
        if (clientId != null) {
            this.setClientId(clientId);
        }
        this.setClientTokenAndSecret(token, secret);
        this.mEventListeners.add(listener2);
    }

    public /* synthetic */ FeedSession(Context context, String string, String string2, EventListener eventListener, String string3, MockLocations mockLocations, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            mockLocations = null;
        }
        this(context, string, string2, eventListener, string3, mockLocations);
    }

    @JvmOverloads
    public FeedSession(@NotNull Context context, @NotNull String token, @NotNull String secret, @NotNull EventListener listener2, @Nullable String clientId) {
        this(context, token, secret, listener2, clientId, null, 32, null);
    }

    @JvmOverloads
    public FeedSession(@NotNull Context context, @NotNull String token, @NotNull String secret, @NotNull EventListener listener2) {
        this(context, token, secret, listener2, null, null, 48, null);
    }

    static {
        Companion = new Companion(null);
        Object object = RestApi.Companion.getRetrofit().create(RestApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RestApi.retrofit.create(RestApi::class.java)");
        mRestApi = (RestApi)object;
    }

    public static final /* synthetic */ void access$setMEventListeners$p(FeedSession $this, ArrayList arrayList) {
        $this.mEventListeners = arrayList;
    }

    public static final /* synthetic */ List access$getPendingRequests$p(FeedSession $this) {
        return $this.pendingRequests;
    }

    public static final /* synthetic */ void access$setPendingRequests$p(FeedSession $this, List list) {
        $this.pendingRequests = list;
    }

    public static final /* synthetic */ FMLog access$getLog$p(FeedSession $this) {
        return $this.log;
    }

    public static final /* synthetic */ Integer access$getMOfflinePlacement$p(FeedSession $this) {
        return $this.mOfflinePlacement;
    }

    public static final /* synthetic */ void access$setMOfflinePlacement$p(FeedSession $this, Integer n) {
        $this.mOfflinePlacement = n;
    }

    public static final /* synthetic */ List access$getStationList$p(FeedSession $this) {
        return $this.stationList;
    }

    public static final /* synthetic */ void access$setStationList$p(FeedSession $this, List list) {
        $this.stationList = list;
    }

    public static final /* synthetic */ Integer access$getMPlacementId$p(FeedSession $this) {
        return $this.mPlacementId;
    }

    public static final /* synthetic */ void access$setMPlacementId$p(FeedSession $this, Integer n) {
        $this.mPlacementId = n;
    }

    public static final /* synthetic */ Session access$getMCurrentSession$p(FeedSession $this) {
        return $this.mCurrentSession;
    }

    public static final /* synthetic */ void access$setMCurrentSession$p(FeedSession $this, Session session) {
        $this.mCurrentSession = session;
    }

    public static final /* synthetic */ boolean access$getMNextPlayInProgress$p(FeedSession $this) {
        return $this.mNextPlayInProgress;
    }

    public static final /* synthetic */ void access$setMNextPlayInProgress$p(FeedSession $this, boolean bl) {
        $this.mNextPlayInProgress = bl;
    }

    public static final /* synthetic */ boolean access$getMCanSkipCurrent$p(FeedSession $this) {
        return $this.mCanSkipCurrent;
    }

    public static final /* synthetic */ void access$setMCanSkipCurrent$p(FeedSession $this, boolean bl) {
        $this.mCanSkipCurrent = bl;
    }

    public static final /* synthetic */ RestApi access$getMRestApi$cp() {
        return mRestApi;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lfm/feed/android/playersdk/FeedSession$ClientIdListener;", "", "onError", "", "t", "", "onSuccess", "clientId", "", "PlayerSdk_exo2118Release"})
    public static interface ClientIdListener {
        public void onSuccess(@NotNull String var1);

        public void onError(@NotNull Throwable var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lfm/feed/android/playersdk/FeedSession$CancelledRequest;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "PlayerSdk_exo2118Release"})
    public static final class CancelledRequest
    extends Exception {
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00a2\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lfm/feed/android/playersdk/FeedSession$WrappedCallback;", "T", "Lfm/feed/android/playersdk/models/webservice/FeedFMResponse;", "", "(Lfm/feed/android/playersdk/FeedSession;)V", "onError", "", "t", "", "onSuccess", "response", "(Lfm/feed/android/playersdk/models/webservice/FeedFMResponse;)V", "PlayerSdk_exo2118Release"})
    private abstract class WrappedCallback<T extends FeedFMResponse> {
        public abstract void onSuccess(@NotNull T var1);

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (t instanceof CancelledRequest) {
                return;
            }
            Exception ex = new Exception(t);
            for (EventListener listener2 : FeedSession.this.mEventListeners) {
                listener2.unexpectedError(ex);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lfm/feed/android/playersdk/FeedSession$OfflineLogsListener;", "", "offlineLogSaveFailed", "", "logs", "Lorg/json/JSONArray;", "PlayerSdk_exo2118Release"})
    public static interface OfflineLogsListener {
        public void offlineLogSaveFailed(@NotNull JSONArray var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lfm/feed/android/playersdk/FeedSession$SkipRequestListener;", "", "onFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "PlayerSdk_exo2118Release"})
    public static interface SkipRequestListener {
        public void onSuccess();

        public void onFailure(@NotNull Exception var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\b\u0010\u0007\u001a\u00020\u0003H&J\u0016\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&J\b\u0010\f\u001a\u00020\u0003H&J\u0014\u0010\r\u001a\u00020\u00032\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H&J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&J\u0014\u0010\u0019\u001a\u00020\u00032\n\u0010\u001a\u001a\u00060\u000fj\u0002`\u0010H&\u00a8\u0006\u001b"}, d2={"Lfm/feed/android/playersdk/FeedSession$EventListener;", "", "cacheFilesAvailable", "", "cacheInfoList", "", "Lfm/feed/android/playersdk/models/CacheInfo;", "noMoreMusic", "remoteOfflineStationListAvailable", "stations", "", "Lfm/feed/android/playersdk/models/Station;", "sessionAvailable", "sessionNotAvailable", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "skipStatusDidChange", "canSkip", "", "stationInfoAvailable", "station", "listener", "Lfm/feed/android/playersdk/StationDownloadListener;", "stationListAvailable", "unexpectedError", "e", "PlayerSdk_exo2118Release"})
    public static interface EventListener {
        public void stationInfoAvailable(@NotNull Station var1, @NotNull StationDownloadListener var2);

        public void remoteOfflineStationListAvailable(@NotNull List<Station> var1);

        public void stationListAvailable(@NotNull List<Station> var1);

        public void sessionNotAvailable(@NotNull Exception var1);

        public void sessionAvailable();

        public void unexpectedError(@NotNull Exception var1);

        public void skipStatusDidChange(boolean var1);

        public void noMoreMusic();

        public void cacheFilesAvailable(@NotNull List<CacheInfo> var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lfm/feed/android/playersdk/FeedSession$Companion;", "", "()V", "AUDIO_FORMAT_AAC", "", "AUDIO_FORMAT_M4A", "AUDIO_FORMAT_MP3", "CLIENT_ID", "FORCE_CODE", "", "mRestApi", "Lfm/feed/android/playersdk/RestApi;", "changeBaseURL", "", "url", "persistClientId", "context", "Landroid/content/Context;", "clientId", "resetClientId", "retrieveClientId", "PlayerSdk_exo2118Release"})
    public static final class Companion {
        public final void changeBaseURL(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Retrofit retrofit = new Retrofit.Builder().client(RestApi.Companion.getOkHttpClient()).baseUrl(url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026                 .build()");
            RestApi.Companion.setRetrofit(retrofit);
            Object object = RestApi.Companion.getRetrofit().create(RestApi.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RestApi.retrofit.create(RestApi::class.java)");
            mRestApi = (RestApi)object;
        }

        @Nullable
        public final String retrieveClientId(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SharedPreferences sharedPref = context.getSharedPreferences(FeedSession.class.getSimpleName(), 0);
            return sharedPref.getString(FeedSession.CLIENT_ID, null);
        }

        public final void persistClientId(@NotNull Context context, @Nullable String clientId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SharedPreferences sharedPref = context.getSharedPreferences(FeedSession.class.getSimpleName(), 0);
            SharedPreferences.Editor editor = sharedPref.edit();
            if (clientId == null) {
                editor.remove(FeedSession.CLIENT_ID);
            } else {
                editor.putString(FeedSession.CLIENT_ID, clientId);
            }
            editor.apply();
        }

        public final void resetClientId(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.persistClientId(context, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

