/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import fm.feed.android.playersdk.ExoSimulcastAudioPlayer;
import fm.feed.android.playersdk.FMLog;
import fm.feed.android.playersdk.FeedSession;
import fm.feed.android.playersdk.FeedSimulcastStreamer;
import fm.feed.android.playersdk.SimulcastApi;
import fm.feed.android.playersdk.SimulcastEventListener;
import fm.feed.android.playersdk.SimulcastPlaybackState;
import fm.feed.android.playersdk.models.AudioFile;
import fm.feed.android.playersdk.models.Play;
import fm.feed.android.playersdk.models.webservice.FeedFMError;
import fm.feed.android.playersdk.models.webservice.SimulcastConnectResponse;
import fm.feed.android.playersdk.models.webservice.SimulcastPlayResponse;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007*\u0001\"\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0002J\u0006\u0010;\u001a\u000209J\u0006\u0010<\u001a\u000209J\b\u0010=\u001a\u000209H\u0002J\b\u0010>\u001a\u000209H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR*\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u001bj\b\u0012\u0004\u0012\u00020\u0007`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0019\"\u0004\b6\u00107\u00a8\u0006@"}, d2={"Lfm/feed/android/playersdk/FeedSimulcastStreamer;", "", "context", "Landroid/content/Context;", "token", "", "eventListener", "Lfm/feed/android/playersdk/SimulcastEventListener;", "(Landroid/content/Context;Ljava/lang/String;Lfm/feed/android/playersdk/SimulcastEventListener;)V", "bPlayFlag", "", "clientId", "getContext", "()Landroid/content/Context;", "play", "Lfm/feed/android/playersdk/models/Play;", "currentItem", "getCurrentItem", "()Lfm/feed/android/playersdk/models/Play;", "setCurrentItem", "(Lfm/feed/android/playersdk/models/Play;)V", "<set-?>", "", "currentTime", "getCurrentTime", "()F", "eventListeners", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "fetchTimeInMs", "", "isPlayer", "lastConfirmedTrackPlayTimeByServerInSeconds", "listener", "fm/feed/android/playersdk/FeedSimulcastStreamer$listener$1", "Lfm/feed/android/playersdk/FeedSimulcastStreamer$listener$1;", "log", "Lfm/feed/android/playersdk/FMLog;", "mMainHandler", "Landroid/os/Handler;", "mSimulcastApi", "Lfm/feed/android/playersdk/SimulcastApi;", "playWhenReady", "player", "Lfm/feed/android/playersdk/ExoSimulcastAudioPlayer;", "value", "Lfm/feed/android/playersdk/SimulcastPlaybackState;", "state", "getState", "()Lfm/feed/android/playersdk/SimulcastPlaybackState;", "setState", "(Lfm/feed/android/playersdk/SimulcastPlaybackState;)V", "volume", "getVolume", "setVolume", "(F)V", "checkAvailability", "", "checkUpdateNeeded", "connect", "disconnect", "getCurrentPlay", "processUpdate", "Companion", "PlayerSdk_exo2118Release"})
public final class FeedSimulcastStreamer {
    private boolean playWhenReady;
    private boolean isPlayer;
    private long fetchTimeInMs;
    private final FMLog log;
    private ExoSimulcastAudioPlayer player;
    private float lastConfirmedTrackPlayTimeByServerInSeconds;
    private Handler mMainHandler;
    private boolean bPlayFlag;
    private final SimulcastApi mSimulcastApi;
    private String clientId;
    private float currentTime;
    private float volume;
    @Nullable
    private Play currentItem;
    @NotNull
    private SimulcastPlaybackState state;
    private final ArrayList<SimulcastEventListener> eventListeners;
    private final listener.1 listener;
    @NotNull
    private final Context context;
    private final String token;
    private static final int UPDATE_MESSAGE = 1;
    private static final int CANCEL_MESSAGE = 2;
    private static int UPDATE_INTERVAL;
    @NotNull
    public static final Companion Companion;

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final void setVolume(float value) {
        ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = this.player;
        if (exoSimulcastAudioPlayer != null) {
            exoSimulcastAudioPlayer.setVolume(value);
        }
        this.volume = value;
    }

    @Nullable
    public final Play getCurrentItem() {
        Play play2;
        if (this.isPlayer) {
            ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = this.player;
            play2 = exoSimulcastAudioPlayer != null ? exoSimulcastAudioPlayer.getCurrentPlay() : null;
        } else {
            play2 = this.currentItem;
        }
        return play2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setCurrentItem(@Nullable Play play2) {
        Play play3 = play2;
        if (play3 == null) return;
        Play play4 = play3;
        boolean bl = false;
        boolean bl2 = false;
        Play it = play4;
        boolean bl3 = false;
        if (this.getCurrentItem() != null) {
            Play play5 = this.getCurrentItem();
            if (!(Intrinsics.areEqual((Object)(play5 != null ? play5.getAudioFile() : null), (Object)it.getAudioFile()) ^ true)) {
                this.fetchTimeInMs = System.currentTimeMillis();
                this.currentItem = play2;
                this.lastConfirmedTrackPlayTimeByServerInSeconds = it.getElapsedSeconds();
                return;
            }
        }
        this.fetchTimeInMs = System.currentTimeMillis();
        this.currentItem = play2;
        this.lastConfirmedTrackPlayTimeByServerInSeconds = it.getElapsedSeconds();
        Iterator<SimulcastEventListener> iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            SimulcastEventListener event = iterator.next();
            event.onPlayItemBeganPlayback(it);
        }
    }

    @NotNull
    public final SimulcastPlaybackState getState() {
        SimulcastPlaybackState simulcastPlaybackState;
        if (this.state == SimulcastPlaybackState.Unintialized) {
            simulcastPlaybackState = SimulcastPlaybackState.Unintialized;
        } else if (this.isPlayer) {
            ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = this.player;
            Intrinsics.checkNotNull((Object)exoSimulcastAudioPlayer);
            simulcastPlaybackState = exoSimulcastAudioPlayer.getPlayerState();
        } else {
            simulcastPlaybackState = this.state;
        }
        return simulcastPlaybackState;
    }

    public final void setState(@NotNull SimulcastPlaybackState value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.state != value) {
            this.state = value;
            for (SimulcastEventListener event : this.eventListeners) {
                event.onPlayerStateChanged(value);
            }
        }
    }

    private final void checkAvailability() {
        Call<SimulcastConnectResponse> call = this.mSimulcastApi.simulcastGetStream(this.clientId, 1, this.token);
        call.enqueue((Callback)new Callback<SimulcastConnectResponse>(this){
            final /* synthetic */ FeedSimulcastStreamer this$0;

            public void onResponse(@NotNull Call<SimulcastConnectResponse> call, @NotNull Response<SimulcastConnectResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    SimulcastConnectResponse simulcastConnectResponse = (SimulcastConnectResponse)response.body();
                    if (simulcastConnectResponse != null) {
                        SimulcastConnectResponse simulcastConnectResponse2 = simulcastConnectResponse;
                        boolean bl = false;
                        boolean bl2 = false;
                        SimulcastConnectResponse it = simulcastConnectResponse2;
                        boolean bl3 = false;
                        Context context = this.this$0.getContext();
                        SimulcastConnectResponse simulcastConnectResponse3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)simulcastConnectResponse3, (String)"it");
                        FeedSession.Companion.persistClientId(context, simulcastConnectResponse3.getClientId());
                        FeedSimulcastStreamer.access$setClientId$p(this.this$0, it.getClientId());
                        if (it.getStreamUrl() != null) {
                            FeedSimulcastStreamer.access$setPlayer$p(this.this$0, true);
                            Context context2 = this.this$0.getContext();
                            Looper looper = Looper.getMainLooper();
                            Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"Looper.getMainLooper()");
                            FeedSimulcastStreamer.access$setPlayer$p(this.this$0, new ExoSimulcastAudioPlayer(context2, looper, FeedSimulcastStreamer.access$getToken$p(this.this$0)));
                            if (FeedSimulcastStreamer.access$getPlayWhenReady$p(this.this$0)) {
                                ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = FeedSimulcastStreamer.access$getPlayer$p(this.this$0);
                                if (exoSimulcastAudioPlayer != null) {
                                    exoSimulcastAudioPlayer.play();
                                }
                            }
                            ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = FeedSimulcastStreamer.access$getPlayer$p(this.this$0);
                            if (exoSimulcastAudioPlayer != null) {
                                exoSimulcastAudioPlayer.setEventListener(FeedSimulcastStreamer.access$getListener$p(this.this$0));
                            }
                        } else {
                            FeedSimulcastStreamer.access$setPlayer$p(this.this$0, false);
                            if (FeedSimulcastStreamer.access$getPlayWhenReady$p(this.this$0)) {
                                FeedSimulcastStreamer.access$getMMainHandler$p(this.this$0).sendEmptyMessage(1);
                            }
                        }
                        if (it.getError() == null) {
                            this.this$0.setState(SimulcastPlaybackState.Available);
                        } else {
                            this.this$0.setState(SimulcastPlaybackState.Unavailable);
                            for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                                FeedFMError feedFMError = it.getError();
                                Intrinsics.checkNotNullExpressionValue((Object)feedFMError, (String)"it.error");
                                event.onPlayerError(feedFMError);
                            }
                        }
                    }
                } else {
                    for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                        event.onPlayerError(new Exception(response.message()));
                    }
                }
            }

            public void onFailure(@NotNull Call<SimulcastConnectResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayerError(new Exception(t));
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void connect() {
        if (this.getState() == SimulcastPlaybackState.Unintialized) {
            this.playWhenReady = true;
            return;
        }
        if (this.getState() == SimulcastPlaybackState.Unavailable) {
            for (SimulcastEventListener event : this.eventListeners) {
                event.onPlayerError(new Exception("Player is Unavailable"));
            }
        }
        if (this.isPlayer) {
            ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = this.player;
            if (exoSimulcastAudioPlayer != null) {
                exoSimulcastAudioPlayer.play();
            }
        } else {
            this.mMainHandler.sendEmptyMessage(1);
        }
    }

    public final void disconnect() {
        if (this.isPlayer) {
            ExoSimulcastAudioPlayer exoSimulcastAudioPlayer = this.player;
            if (exoSimulcastAudioPlayer != null) {
                exoSimulcastAudioPlayer.stop();
            }
        } else {
            this.mMainHandler.sendEmptyMessage(2);
        }
    }

    private final void getCurrentPlay() {
        if (this.bPlayFlag) {
            FMLog.d$default(this.log, "Already fetching a play", null, 2, null);
            return;
        }
        this.bPlayFlag = true;
        SimulcastApi.Companion.getHttpLog().level(HttpLoggingInterceptor.Level.BODY);
        Call<SimulcastPlayResponse> call = this.mSimulcastApi.simulcastGetInStudioPlay("cid=" + this.clientId, this.token);
        call.enqueue((Callback)new Callback<SimulcastPlayResponse>(this){
            final /* synthetic */ FeedSimulcastStreamer this$0;

            public void onResponse(@NotNull Call<SimulcastPlayResponse> call, @NotNull Response<SimulcastPlayResponse> response) {
                block12: {
                    block11: {
                        SimulcastPlayResponse it;
                        block13: {
                            block14: {
                                block16: {
                                    block15: {
                                        block17: {
                                            Intrinsics.checkNotNullParameter(call, (String)"call");
                                            Intrinsics.checkNotNullParameter(response, (String)"response");
                                            FeedSimulcastStreamer.access$setBPlayFlag$p(this.this$0, false);
                                            if (!response.isSuccessful()) break block11;
                                            SimulcastPlayResponse simulcastPlayResponse = (SimulcastPlayResponse)response.body();
                                            if (simulcastPlayResponse == null) break block12;
                                            SimulcastPlayResponse simulcastPlayResponse2 = simulcastPlayResponse;
                                            boolean bl = false;
                                            boolean bl2 = false;
                                            it = simulcastPlayResponse2;
                                            boolean bl3 = false;
                                            SimulcastPlayResponse simulcastPlayResponse3 = it;
                                            Intrinsics.checkNotNullExpressionValue((Object)simulcastPlayResponse3, (String)"it");
                                            if (!simulcastPlayResponse3.isSuccess()) break block13;
                                            if (it.getState() == null) break block14;
                                            if (it.getPlay() != null) {
                                                this.this$0.setCurrentItem(it.getPlay());
                                                FMLog.d$default(FeedSimulcastStreamer.access$getLog$p(this.this$0), "Got new play " + this.this$0.getCurrentItem(), null, 2, null);
                                            }
                                            FeedSimulcastStreamer.access$setLastConfirmedTrackPlayTimeByServerInSeconds$p(this.this$0, it.getElapsedSeconds());
                                            String string = it.getState();
                                            if (string == null) break block12;
                                            String string2 = string;
                                            switch (string2.hashCode()) {
                                                case -995321554: {
                                                    if (!string2.equals("paused")) break block12;
                                                    break block15;
                                                }
                                                case 3227604: {
                                                    if (string2.equals("idle")) {
                                                        break;
                                                    }
                                                    break block12;
                                                }
                                                case -524171096: {
                                                    if (!string2.equals("music-unavailable")) break block12;
                                                    break block16;
                                                }
                                                case -493563858: {
                                                    if (!string2.equals("playing")) break block12;
                                                    break block17;
                                                }
                                            }
                                            this.this$0.setState(SimulcastPlaybackState.Idle);
                                            break block12;
                                        }
                                        this.this$0.setState(SimulcastPlaybackState.Playing);
                                        break block12;
                                    }
                                    this.this$0.setState(SimulcastPlaybackState.Stopped);
                                    break block12;
                                }
                                this.this$0.setState(SimulcastPlaybackState.Unavailable);
                                break block12;
                            }
                            FMLog.e$default(FeedSimulcastStreamer.access$getLog$p(this.this$0), "Server did not return a state", null, 2, null);
                            for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                                event.onPlayerError(new Exception("Server did not return a state"));
                            }
                            break block12;
                        }
                        FMLog.e$default(FeedSimulcastStreamer.access$getLog$p(this.this$0), "Server returned an error", null, 2, null);
                        FMLog fMLog = FeedSimulcastStreamer.access$getLog$p(this.this$0);
                        String string = it.getError().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.error.toString()");
                        FMLog.e$default(fMLog, string, null, 2, null);
                        for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                            event.onPlayerError(new Exception("Server returned an error " + it.getError()));
                        }
                        break block12;
                    }
                    Object object = response.errorBody();
                    if (object == null || (object = object.string()) == null) break block12;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object it = object2;
                    boolean bl5 = false;
                    for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                        event.onPlayerError(new Exception("Request to server unsuccessful " + (String)it));
                    }
                    FMLog.e$default(FeedSimulcastStreamer.access$getLog$p(this.this$0), it, null, 2, null);
                }
            }

            public void onFailure(@NotNull Call<SimulcastPlayResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                FeedSimulcastStreamer.access$setBPlayFlag$p(this.this$0, false);
                for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayerError(new Exception(t));
                }
                FMLog fMLog = FeedSimulcastStreamer.access$getLog$p(this.this$0);
                t.printStackTrace();
                FMLog.e$default(fMLog, Unit.INSTANCE, null, 2, null);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void processUpdate() {
        FMLog.d$default(this.log, "Processing update", null, 2, null);
        this.checkUpdateNeeded();
        long time = System.currentTimeMillis();
        float interval = (int)(time - this.fetchTimeInMs) / 1000;
        this.currentTime = this.lastConfirmedTrackPlayTimeByServerInSeconds + interval;
        Play play2 = this.getCurrentItem();
        if (play2 != null) {
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            for (SimulcastEventListener event : this.eventListeners) {
                event.onProgressUpdate(it, this.currentTime, it.getAudioFile().getDurationInSeconds());
            }
        }
    }

    private final void checkUpdateNeeded() {
        Object object = this.getCurrentItem();
        if (object != null && (object = ((Play)object).getAudioFile()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            if (this.currentTime - ((AudioFile)it).getDurationInSeconds() > 0.0f && !this.bPlayFlag) {
                this.getCurrentPlay();
            } else if (this.currentTime - this.lastConfirmedTrackPlayTimeByServerInSeconds > (float)10 && !this.bPlayFlag) {
                this.getCurrentPlay();
            }
        }
        if (this.getCurrentItem() == null) {
            UPDATE_INTERVAL = this.getState() == SimulcastPlaybackState.Idle ? 5000 : 1000;
            this.getCurrentPlay();
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public FeedSimulcastStreamer(@NotNull Context context, @NotNull String token, @NotNull SimulcastEventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.context = context;
        this.token = token;
        this.log = new FMLog("fm.feed.FeedSimulcastStreamer");
        Object object = SimulcastApi.Companion.getRetrofitInStudio().create(SimulcastApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SimulcastApi.retrofitInS\u2026SimulcastApi::class.java)");
        this.mSimulcastApi = (SimulcastApi)object;
        this.clientId = FeedSession.Companion.retrieveClientId(this.context);
        this.volume = 1.0f;
        this.state = SimulcastPlaybackState.Unintialized;
        this.eventListeners = new ArrayList();
        this.listener = new SimulcastEventListener(this){
            final /* synthetic */ FeedSimulcastStreamer this$0;

            public void onPlayItemBeganPlayback(@NotNull Play play2) {
                Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
                this.this$0.setCurrentItem(play2);
                for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayItemBeganPlayback(play2);
                }
            }

            public void onPlayerStateChanged(@NotNull SimulcastPlaybackState playerState) {
                Intrinsics.checkNotNullParameter((Object)((Object)playerState), (String)"playerState");
                for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayerStateChanged(playerState);
                }
            }

            public void onProgressUpdate(@NotNull Play play2, float elapsedTime, float duration) {
                Intrinsics.checkNotNullParameter((Object)play2, (String)"play");
                for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onProgressUpdate(play2, elapsedTime, duration);
                }
            }

            public void onPlayerError(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                for (SimulcastEventListener event : FeedSimulcastStreamer.access$getEventListeners$p(this.this$0)) {
                    event.onPlayerError(error);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.eventListeners.add(eventListener);
        this.mMainHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                switch (msg.what) {
                    case 1: {
                        this.processUpdate();
                        this.removeMessages(1);
                        this.sendEmptyMessageDelayed(1, UPDATE_INTERVAL);
                        break;
                    }
                    case 2: {
                        this.removeMessages(1);
                        break;
                    }
                }
            }
        };
        this.checkAvailability();
    }

    static {
        Companion = new Companion(null);
        UPDATE_INTERVAL = 1000;
    }

    public static final /* synthetic */ String access$getClientId$p(FeedSimulcastStreamer $this) {
        return $this.clientId;
    }

    public static final /* synthetic */ void access$setClientId$p(FeedSimulcastStreamer $this, String string) {
        $this.clientId = string;
    }

    public static final /* synthetic */ boolean access$isPlayer$p(FeedSimulcastStreamer $this) {
        return $this.isPlayer;
    }

    public static final /* synthetic */ void access$setPlayer$p(FeedSimulcastStreamer $this, boolean bl) {
        $this.isPlayer = bl;
    }

    public static final /* synthetic */ ExoSimulcastAudioPlayer access$getPlayer$p(FeedSimulcastStreamer $this) {
        return $this.player;
    }

    public static final /* synthetic */ void access$setPlayer$p(FeedSimulcastStreamer $this, ExoSimulcastAudioPlayer exoSimulcastAudioPlayer) {
        $this.player = exoSimulcastAudioPlayer;
    }

    public static final /* synthetic */ String access$getToken$p(FeedSimulcastStreamer $this) {
        return $this.token;
    }

    public static final /* synthetic */ boolean access$getPlayWhenReady$p(FeedSimulcastStreamer $this) {
        return $this.playWhenReady;
    }

    public static final /* synthetic */ void access$setPlayWhenReady$p(FeedSimulcastStreamer $this, boolean bl) {
        $this.playWhenReady = bl;
    }

    public static final /* synthetic */ listener.1 access$getListener$p(FeedSimulcastStreamer $this) {
        return $this.listener;
    }

    public static final /* synthetic */ Handler access$getMMainHandler$p(FeedSimulcastStreamer $this) {
        return $this.mMainHandler;
    }

    public static final /* synthetic */ void access$setMMainHandler$p(FeedSimulcastStreamer $this, Handler handler) {
        $this.mMainHandler = handler;
    }

    public static final /* synthetic */ ArrayList access$getEventListeners$p(FeedSimulcastStreamer $this) {
        return $this.eventListeners;
    }

    public static final /* synthetic */ boolean access$getBPlayFlag$p(FeedSimulcastStreamer $this) {
        return $this.bPlayFlag;
    }

    public static final /* synthetic */ void access$setBPlayFlag$p(FeedSimulcastStreamer $this, boolean bl) {
        $this.bPlayFlag = bl;
    }

    public static final /* synthetic */ FMLog access$getLog$p(FeedSimulcastStreamer $this) {
        return $this.log;
    }

    public static final /* synthetic */ float access$getLastConfirmedTrackPlayTimeByServerInSeconds$p(FeedSimulcastStreamer $this) {
        return $this.lastConfirmedTrackPlayTimeByServerInSeconds;
    }

    public static final /* synthetic */ void access$setLastConfirmedTrackPlayTimeByServerInSeconds$p(FeedSimulcastStreamer $this, float f) {
        $this.lastConfirmedTrackPlayTimeByServerInSeconds = f;
    }

    public static final /* synthetic */ void access$setUPDATE_INTERVAL$cp(int n) {
        UPDATE_INTERVAL = n;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lfm/feed/android/playersdk/FeedSimulcastStreamer$Companion;", "", "()V", "CANCEL_MESSAGE", "", "UPDATE_INTERVAL", "UPDATE_MESSAGE", "PlayerSdk_exo2118Release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

