/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.media.MediaMetadata;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.media.app.NotificationCompat;
import fm.feed.android.playersdk.FMLog;
import fm.feed.android.playersdk.FeedAudioPlayer;
import fm.feed.android.playersdk.FeedPlayerService;
import fm.feed.android.playersdk.MediaNotificationManager;
import fm.feed.android.playersdk.PlayerService;
import fm.feed.android.playersdk.models.NotificationStyle;
import fm.feed.android.playersdk.models.Play;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0097\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u000e\b\u0000\u0018\u0000 @2\u00020\u0001:\u0002?@B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0002J\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020&H\u0003J\b\u0010(\u001a\u00020)H\u0003J\n\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0018\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u000bJ\b\u00103\u001a\u00020&H\u0002Jb\u00104\u001a\u00020&2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0015H\u0002R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lfm/feed/android/playersdk/MediaNotificationManager;", "Landroid/content/BroadcastReceiver;", "mAudioPlayer", "Lfm/feed/android/playersdk/FeedAudioPlayer;", "mPlayerService", "Lfm/feed/android/playersdk/PlayerService;", "mMediaController", "Landroid/support/v4/media/session/MediaControllerCompat;", "mContentIntent", "Landroid/app/PendingIntent;", "mNotificationStyle", "Lfm/feed/android/playersdk/models/NotificationStyle;", "(Lfm/feed/android/playersdk/FeedAudioPlayer;Lfm/feed/android/playersdk/PlayerService;Landroid/support/v4/media/session/MediaControllerCompat;Landroid/app/PendingIntent;Lfm/feed/android/playersdk/models/NotificationStyle;)V", "callback", "fm/feed/android/playersdk/MediaNotificationManager$callback$1", "Lfm/feed/android/playersdk/MediaNotificationManager$callback$1;", "log", "Lfm/feed/android/playersdk/FMLog;", "mCancelIntent", "mDislikeIntent", "mForeground", "", "mLikeIntent", "mNextIntent", "mNotificationManager", "Landroidx/core/app/NotificationManagerCompat;", "mPauseIntent", "mPlayIntent", "addActions", "", "notificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "thumbsDownState", "Lfm/feed/android/playersdk/MediaNotificationManager$ButtonState;", "thumbsUpState", "playPauseState", "skipState", "cancelNotification", "", "createChannel", "createMediaMetaData", "", "createNotification", "Landroid/app/Notification;", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "setNotificationIcons", "ni", "updateNotification", "wireUpRemoteViews", "remoteViews", "Landroid/widget/RemoteViews;", "title", "", "artist", "album", "bm", "Landroid/graphics/Bitmap;", "buffering", "big", "ButtonState", "Companion", "PlayerSdk_exo2118Release"})
public final class MediaNotificationManager
extends BroadcastReceiver {
    private final FMLog log;
    private final NotificationManagerCompat mNotificationManager;
    private final PendingIntent mPauseIntent;
    private final PendingIntent mPlayIntent;
    private final PendingIntent mNextIntent;
    private final PendingIntent mCancelIntent;
    private final PendingIntent mLikeIntent;
    private final PendingIntent mDislikeIntent;
    private boolean mForeground;
    private final callback.1 callback;
    private final FeedAudioPlayer mAudioPlayer;
    private final PlayerService mPlayerService;
    private MediaControllerCompat mMediaController;
    private final PendingIntent mContentIntent;
    private NotificationStyle mNotificationStyle;
    private static final String CHANNEL_ID = "media_playback_channel";
    @NotNull
    public static final String ACTION_PAUSE = "fm.feed.android.playersdk.pause";
    @NotNull
    public static final String ACTION_PLAY = "fm.feed.android.playersdk.play";
    @NotNull
    public static final String ACTION_NEXT = "fm.feed.android.playersdk.next";
    @NotNull
    public static final String ACTION_CANCEL = "fm.feed.android.playersdk.cancel";
    @NotNull
    public static final String ACTION_LIKE = "fm.feed.android.playersdk.like";
    @NotNull
    public static final String ACTION_DISLIKE = "fm.feed.android.playersdk.dislike";
    private static final int NOTIFICATION_ID = 53376;
    private static final int REQUEST_CODE = 808;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @RequiresApi(value=21)
    private final Object createMediaMetaData() {
        MediaMetadata mediaMetadata = new MediaMetadata.Builder().putText("android.media.metadata.DISPLAY_TITLE", (CharSequence)" ").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata, (String)"MediaMetadata.Builder().\u2026SPLAY_TITLE, \" \").build()");
        return mediaMetadata;
    }

    @RequiresApi(value=26)
    private final void createChannel() {
        Object object = this.mPlayerService.getSystemService("notification");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager mNotificationManager = (NotificationManager)object;
        String name = "Media playback";
        String description = "Media playback controls";
        int importance = 2;
        NotificationChannel mChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)name, importance);
        mChannel.setDescription(description);
        mChannel.setShowBadge(false);
        mChannel.setLockscreenVisibility(1);
        mNotificationManager.createNotificationChannel(mChannel);
    }

    public final void cancelNotification() {
        FMLog.d$default(this.log, "cancelling notification and quitting", null, 2, null);
        if (this.mMediaController == null) {
            return;
        }
        MediaControllerCompat mediaControllerCompat = this.mMediaController;
        Intrinsics.checkNotNull((Object)mediaControllerCompat);
        mediaControllerCompat.unregisterCallback((MediaControllerCompat.Callback)this.callback);
        this.mMediaController = null;
        try {
            this.mPlayerService.unregisterReceiver(this);
            this.mNotificationManager.cancel(53376);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mPlayerService.stopForeground(true);
    }

    public final void setNotificationIcons(@NotNull NotificationStyle ni) {
        Intrinsics.checkNotNullParameter((Object)ni, (String)"ni");
        this.mNotificationStyle = ni;
        this.updateNotification();
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String action = intent.getAction();
        if (action != null) {
            FMLog.d$default(this.log, "Received intent with action " + action, null, 2, null);
            switch (action) {
                case "fm.feed.android.playersdk.pause": {
                    this.mAudioPlayer.pause();
                    break;
                }
                case "fm.feed.android.playersdk.play": {
                    this.mAudioPlayer.play();
                    break;
                }
                case "fm.feed.android.playersdk.next": {
                    this.mAudioPlayer.skip();
                    break;
                }
                case "fm.feed.android.playersdk.cancel": {
                    FeedPlayerService.INSTANCE.stopService$PlayerSdk_exo2118Release();
                    break;
                }
                case "fm.feed.android.playersdk.like": {
                    if (this.mAudioPlayer.getCurrentPlay() == null) break;
                    Play play2 = this.mAudioPlayer.getCurrentPlay();
                    Intrinsics.checkNotNull((Object)play2);
                    if (play2.getAudioFile().isLiked()) {
                        this.mAudioPlayer.unlike();
                        break;
                    }
                    this.mAudioPlayer.like();
                    break;
                }
                case "fm.feed.android.playersdk.dislike": {
                    if (this.mAudioPlayer.getCurrentPlay() == null) break;
                    Play play3 = this.mAudioPlayer.getCurrentPlay();
                    Intrinsics.checkNotNull((Object)play3);
                    if (play3.getAudioFile().isDisliked()) {
                        this.mAudioPlayer.unlike();
                        break;
                    }
                    this.mAudioPlayer.dislike();
                    break;
                }
                default: {
                    FMLog.w$default(this.log, "Unknown intent ignored. Action=" + action, null, 2, null);
                }
            }
        }
    }

    private final void updateNotification() {
        boolean ongoing;
        if (this.mMediaController == null) {
            return;
        }
        Notification notification = this.createNotification();
        if (notification == null) {
            return;
        }
        Notification notification2 = notification;
        FMLog.d$default(this.log, "Updating notification " + notification2, null, 2, null);
        boolean bl = ongoing = (notification2.flags & 2) != 0;
        if (ongoing && !this.mForeground) {
            FMLog.d$default(this.log, "mPlayerService.startForeground", null, 2, null);
            this.mPlayerService.startForeground(53376, notification2);
            this.mForeground = true;
        } else if (!ongoing && this.mForeground) {
            FMLog.d$default(this.log, "mPlayerService.stopForeground(true)", null, 2, null);
            this.mPlayerService.stopForeground(false);
            this.mNotificationManager.notify(53376, notification2);
            this.mForeground = false;
        } else {
            FMLog.d$default(this.log, "no change in fore/background", null, 2, null);
            try {
                this.mNotificationManager.notify(53376, notification2);
            }
            catch (RuntimeException e) {
                FMLog.e$default(this.log, "Ignoring runtime exception while setting notification. Probably the 'bad array lengths' error." + e.getStackTrace(), null, 2, null);
            }
        }
    }

    private final Notification createNotification() {
        RemoteViews contentView;
        Bitmap bm;
        if (this.mMediaController == null) {
            FMLog.e$default(this.log, "no media controller - unable to create notification", null, 2, null);
            return null;
        }
        MediaControllerCompat mediaControllerCompat = this.mMediaController;
        Intrinsics.checkNotNull((Object)mediaControllerCompat);
        MediaMetadataCompat metadata = mediaControllerCompat.getMetadata();
        MediaControllerCompat mediaControllerCompat2 = this.mMediaController;
        Intrinsics.checkNotNull((Object)mediaControllerCompat2);
        PlaybackStateCompat playbackState = mediaControllerCompat2.getPlaybackState();
        if (metadata == null) {
            if (Build.VERSION.SDK_INT >= 21) {
                metadata = MediaMetadataCompat.fromMediaMetadata((Object)this.createMediaMetaData());
            } else {
                FMLog.d$default(this.log, "not creating notification with null metadata", null, 2, null);
                return null;
            }
        }
        if (playbackState == null) {
            FMLog.e$default(this.log, "playback state is null - unable to create notification", null, 2, null);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Setting updating notification from ");
        MediaMetadataCompat mediaMetadataCompat = metadata;
        Intrinsics.checkNotNull((Object)mediaMetadataCompat);
        FMLog.d$default(this.log, stringBuilder.append(mediaMetadataCompat).toString(), null, 2, null);
        ButtonState thumbsDownState = ButtonState.DISABLED;
        NotificationStyle notificationStyle = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle);
        if (notificationStyle.getThumbsDownIcon() != -1) {
            RatingCompat rating = metadata.getRating("android.media.metadata.RATING");
            thumbsDownState = rating != null && !rating.isThumbUp() ? ButtonState.SELECTED : ButtonState.NORMAL;
        }
        ButtonState thumbsUpState = ButtonState.DISABLED;
        NotificationStyle notificationStyle2 = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle2);
        if (notificationStyle2.getThumbsUpIcon() != -1) {
            RatingCompat rating = metadata.getRating("android.media.metadata.RATING");
            thumbsUpState = rating != null && rating.isThumbUp() ? ButtonState.SELECTED : ButtonState.NORMAL;
        }
        ButtonState playPauseState = null;
        playPauseState = playbackState.getState() == 3 || playbackState.getState() == 6 ? ButtonState.SELECTED : ButtonState.NORMAL;
        int state = playbackState.getState();
        boolean onGoing = state == 3 || state == 10 || state == 6;
        ButtonState skipState = ButtonState.DISABLED;
        if ((playbackState.getActions() & 0x20L) != 0L) {
            skipState = ButtonState.NORMAL;
        }
        FMLog.d$default(this.log, "Button states are: " + (Object)((Object)thumbsDownState) + ", " + (Object)((Object)thumbsUpState) + ", " + (Object)((Object)playPauseState) + ", " + (Object)((Object)skipState), null, 2, null);
        CharSequence title = metadata.getText("android.media.metadata.TITLE");
        CharSequence artist = metadata.getText("android.media.metadata.ARTIST");
        CharSequence album = metadata.getText("android.media.metadata.ALBUM");
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder((Context)this.mPlayerService, "");
        int[] smallButtons = this.addActions(notificationBuilder, thumbsDownState, thumbsUpState, playPauseState, skipState);
        NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle().setShowActionsInCompactView(Arrays.copyOf(smallButtons, smallButtons.length)).setShowCancelButton(!onGoing).setCancelButtonIntent(this.mCancelIntent);
        MediaControllerCompat mediaControllerCompat3 = this.mMediaController;
        Intrinsics.checkNotNull((Object)mediaControllerCompat3);
        NotificationCompat.MediaStyle mediaStyle2 = mediaStyle.setMediaSession(mediaControllerCompat3.getSessionToken());
        NotificationCompat.Builder builder = notificationBuilder.setStyle((NotificationCompat.Style)mediaStyle2);
        NotificationStyle notificationStyle3 = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle3);
        NotificationCompat.Builder builder2 = builder.setSmallIcon(notificationStyle3.getSmallIcon()).setVisibility(1).setUsesChronometer(false).setContentTitle(title).setContentText(artist).setChannelId(CHANNEL_ID).setSubText(album);
        NotificationStyle notificationStyle4 = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle4);
        builder2.setColor(notificationStyle4.getColor()).setWhen(0L).setShowWhen(false).setOngoing(onGoing);
        if (this.mContentIntent != null) {
            notificationBuilder.setContentIntent(this.mContentIntent);
        }
        if ((bm = metadata.getBitmap("android.media.metadata.ART")) != null) {
            notificationBuilder.setLargeIcon(bm);
        }
        Notification notification = notificationBuilder.build();
        if (Build.VERSION.SDK_INT >= 16) {
            NotificationStyle notificationStyle5 = this.mNotificationStyle;
            if (notificationStyle5 != null) {
                if (notificationStyle5.hasBigContentView()) {
                    FMLog.d$default(this.log, "adding big content view", null, 2, null);
                    NotificationStyle notificationStyle6 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle6);
                    contentView = notificationStyle6.getBigContentView();
                    CharSequence charSequence = title;
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"title");
                    CharSequence charSequence2 = artist;
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"artist");
                    CharSequence charSequence3 = album;
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"album");
                    this.wireUpRemoteViews(contentView, charSequence, charSequence2, charSequence3, bm, thumbsDownState, thumbsUpState, playPauseState, skipState, state == 6, true);
                    if (Build.VERSION.SDK_INT < 24) {
                        notification.bigContentView = contentView;
                    }
                }
            }
        }
        NotificationStyle notificationStyle7 = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle7);
        if (notificationStyle7.hasContentView()) {
            FMLog.d$default(this.log, "adding normal content view", null, 2, null);
            NotificationStyle notificationStyle8 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle8);
            contentView = notificationStyle8.getContentView();
            CharSequence charSequence = title;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"title");
            CharSequence charSequence4 = artist;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence4, (String)"artist");
            CharSequence charSequence5 = album;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence5, (String)"album");
            this.wireUpRemoteViews(contentView, charSequence, charSequence4, charSequence5, bm, thumbsDownState, thumbsUpState, playPauseState, skipState, state == 6, false);
            if (Build.VERSION.SDK_INT < 24) {
                notification.contentView = contentView;
            }
        }
        return notification;
    }

    private final int[] addActions(NotificationCompat.Builder notificationBuilder, ButtonState thumbsDownState, ButtonState thumbsUpState, ButtonState playPauseState, ButtonState skipState) {
        int icon;
        int likeButtonCount = 0;
        if (thumbsDownState != ButtonState.DISABLED) {
            int n;
            if (thumbsDownState == ButtonState.NORMAL) {
                NotificationStyle notificationStyle = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle);
                n = notificationStyle.getThumbsDownIcon();
            } else {
                NotificationStyle notificationStyle = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle);
                n = notificationStyle.getThumbsDownSelectedIcon();
            }
            icon = n;
            notificationBuilder.addAction(new NotificationCompat.Action(icon, (CharSequence)"Dislike", this.mDislikeIntent));
            ++likeButtonCount;
        }
        if (thumbsUpState != ButtonState.DISABLED) {
            int n;
            if (thumbsUpState == ButtonState.NORMAL) {
                NotificationStyle notificationStyle = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle);
                n = notificationStyle.getThumbsUpIcon();
            } else {
                NotificationStyle notificationStyle = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle);
                n = notificationStyle.getThumbsUpSelectedIcon();
            }
            icon = n;
            notificationBuilder.addAction(new NotificationCompat.Action(icon, (CharSequence)"Like", this.mLikeIntent));
            ++likeButtonCount;
        }
        if (playPauseState != ButtonState.DISABLED) {
            String label = null;
            int icon2 = 0;
            PendingIntent intent = null;
            if (playPauseState == ButtonState.NORMAL) {
                label = "Play";
                NotificationStyle notificationStyle = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle);
                icon2 = notificationStyle.getPlayIcon();
                intent = this.mPlayIntent;
            } else {
                label = "Pause";
                NotificationStyle notificationStyle = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle);
                icon2 = notificationStyle.getPauseIcon();
                intent = this.mPauseIntent;
            }
            notificationBuilder.addAction(new NotificationCompat.Action(icon2, (CharSequence)label, intent));
        }
        if (skipState == ButtonState.NORMAL) {
            NotificationStyle notificationStyle = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle);
            int icon3 = notificationStyle.getSkipIcon();
            notificationBuilder.addAction(icon3, (CharSequence)"Next", this.mNextIntent);
            return new int[]{likeButtonCount, likeButtonCount + 1};
        }
        return new int[]{likeButtonCount};
    }

    private final void wireUpRemoteViews(RemoteViews remoteViews, CharSequence title, CharSequence artist, CharSequence album, Bitmap bm, ButtonState thumbsDownState, ButtonState thumbsUpState, ButtonState playPauseState, ButtonState skipState, boolean buffering, boolean big) {
        NotificationStyle notificationStyle = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle);
        if (notificationStyle.getTrackTextId() > -1) {
            NotificationStyle notificationStyle2 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle2);
            remoteViews.setTextViewText(notificationStyle2.getTrackTextId(), title);
        }
        NotificationStyle notificationStyle3 = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle3);
        if (notificationStyle3.getArtistTextId() > -1) {
            NotificationStyle notificationStyle4 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle4);
            remoteViews.setTextViewText(notificationStyle4.getArtistTextId(), artist);
        }
        NotificationStyle notificationStyle5 = this.mNotificationStyle;
        Intrinsics.checkNotNull((Object)notificationStyle5);
        if (notificationStyle5.getReleaseTextId() > -1) {
            NotificationStyle notificationStyle6 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle6);
            remoteViews.setTextViewText(notificationStyle6.getReleaseTextId(), album);
        }
        if (buffering) {
            NotificationStyle notificationStyle7 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle7);
            if (notificationStyle7.getProgressId() > -1) {
                NotificationStyle notificationStyle8 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle8);
                remoteViews.setViewVisibility(notificationStyle8.getProgressId(), 0);
                NotificationStyle notificationStyle9 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle9);
                if (notificationStyle9.getMediaImageId() > -1) {
                    NotificationStyle notificationStyle10 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle10);
                    remoteViews.setViewVisibility(notificationStyle10.getMediaImageId(), 8);
                }
            } else {
                NotificationStyle notificationStyle11 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle11);
                if (notificationStyle11.getMediaImageId() > -1) {
                    NotificationStyle notificationStyle12 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle12);
                    remoteViews.setViewVisibility(notificationStyle12.getMediaImageId(), 0);
                    NotificationStyle notificationStyle13 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle13);
                    remoteViews.setImageViewBitmap(notificationStyle13.getMediaImageId(), bm);
                }
            }
        } else {
            NotificationStyle notificationStyle14 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle14);
            if (notificationStyle14.getMediaImageId() > -1) {
                NotificationStyle notificationStyle15 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle15);
                remoteViews.setViewVisibility(notificationStyle15.getMediaImageId(), 0);
                NotificationStyle notificationStyle16 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle16);
                remoteViews.setImageViewBitmap(notificationStyle16.getMediaImageId(), bm);
                NotificationStyle notificationStyle17 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle17);
                if (notificationStyle17.getProgressId() > -1) {
                    NotificationStyle notificationStyle18 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle18);
                    remoteViews.setViewVisibility(notificationStyle18.getProgressId(), 8);
                }
            }
        }
        if (thumbsDownState == ButtonState.DISABLED) {
            NotificationStyle notificationStyle19 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle19);
            remoteViews.setViewVisibility(notificationStyle19.getDislikeButtonId(), 4);
        } else if (thumbsDownState == ButtonState.NORMAL) {
            NotificationStyle notificationStyle20 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle20);
            int n = notificationStyle20.getDislikeButtonId();
            NotificationStyle notificationStyle21 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle21);
            remoteViews.setImageViewResource(n, notificationStyle21.getThumbsDownIcon());
            NotificationStyle notificationStyle22 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle22);
            remoteViews.setOnClickPendingIntent(notificationStyle22.getDislikeButtonId(), this.mDislikeIntent);
            NotificationStyle notificationStyle23 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle23);
            remoteViews.setViewVisibility(notificationStyle23.getDislikeButtonId(), 0);
        } else {
            NotificationStyle notificationStyle24 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle24);
            int n = notificationStyle24.getDislikeButtonId();
            NotificationStyle notificationStyle25 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle25);
            remoteViews.setImageViewResource(n, notificationStyle25.getThumbsDownSelectedIcon());
            NotificationStyle notificationStyle26 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle26);
            remoteViews.setOnClickPendingIntent(notificationStyle26.getDislikeButtonId(), this.mDislikeIntent);
            NotificationStyle notificationStyle27 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle27);
            remoteViews.setViewVisibility(notificationStyle27.getDislikeButtonId(), 0);
        }
        if (thumbsUpState == ButtonState.DISABLED) {
            NotificationStyle notificationStyle28 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle28);
            remoteViews.setViewVisibility(notificationStyle28.getLikeButtonId(), 4);
        } else if (thumbsUpState == ButtonState.NORMAL) {
            NotificationStyle notificationStyle29 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle29);
            int n = notificationStyle29.getLikeButtonId();
            NotificationStyle notificationStyle30 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle30);
            remoteViews.setImageViewResource(n, notificationStyle30.getThumbsUpIcon());
            NotificationStyle notificationStyle31 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle31);
            remoteViews.setOnClickPendingIntent(notificationStyle31.getLikeButtonId(), this.mLikeIntent);
            NotificationStyle notificationStyle32 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle32);
            remoteViews.setViewVisibility(notificationStyle32.getLikeButtonId(), 0);
        } else {
            NotificationStyle notificationStyle33 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle33);
            int n = notificationStyle33.getLikeButtonId();
            NotificationStyle notificationStyle34 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle34);
            remoteViews.setImageViewResource(n, notificationStyle34.getThumbsUpSelectedIcon());
            NotificationStyle notificationStyle35 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle35);
            remoteViews.setOnClickPendingIntent(notificationStyle35.getLikeButtonId(), this.mLikeIntent);
            NotificationStyle notificationStyle36 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle36);
            remoteViews.setViewVisibility(notificationStyle36.getLikeButtonId(), 0);
        }
        if (playPauseState == ButtonState.NORMAL) {
            NotificationStyle notificationStyle37 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle37);
            int n = notificationStyle37.getPlayPauseButtonId();
            NotificationStyle notificationStyle38 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle38);
            remoteViews.setImageViewResource(n, notificationStyle38.getPlayIcon());
            NotificationStyle notificationStyle39 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle39);
            remoteViews.setOnClickPendingIntent(notificationStyle39.getPlayPauseButtonId(), this.mPlayIntent);
        } else {
            NotificationStyle notificationStyle40 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle40);
            int n = notificationStyle40.getPlayPauseButtonId();
            NotificationStyle notificationStyle41 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle41);
            remoteViews.setImageViewResource(n, notificationStyle41.getPauseIcon());
            NotificationStyle notificationStyle42 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle42);
            remoteViews.setOnClickPendingIntent(notificationStyle42.getPlayPauseButtonId(), this.mPauseIntent);
        }
        if (Build.VERSION.SDK_INT < 21) {
            NotificationStyle notificationStyle43 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle43);
            if (notificationStyle43.getCancelButtonId() == -1) {
                if (playPauseState == ButtonState.NORMAL) {
                    NotificationStyle notificationStyle44 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle44);
                    int n = notificationStyle44.getSkipButtonId();
                    NotificationStyle notificationStyle45 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle45);
                    remoteViews.setImageViewResource(n, notificationStyle45.getCancelIcon());
                    NotificationStyle notificationStyle46 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle46);
                    remoteViews.setOnClickPendingIntent(notificationStyle46.getSkipButtonId(), this.mCancelIntent);
                    NotificationStyle notificationStyle47 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle47);
                    remoteViews.setViewVisibility(notificationStyle47.getSkipButtonId(), 0);
                } else if (skipState == ButtonState.NORMAL) {
                    NotificationStyle notificationStyle48 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle48);
                    int n = notificationStyle48.getSkipButtonId();
                    NotificationStyle notificationStyle49 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle49);
                    remoteViews.setImageViewResource(n, notificationStyle49.getSkipIcon());
                    NotificationStyle notificationStyle50 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle50);
                    remoteViews.setOnClickPendingIntent(notificationStyle50.getSkipButtonId(), this.mNextIntent);
                    NotificationStyle notificationStyle51 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle51);
                    remoteViews.setViewVisibility(notificationStyle51.getSkipButtonId(), 0);
                } else {
                    NotificationStyle notificationStyle52 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle52);
                    remoteViews.setViewVisibility(notificationStyle52.getSkipButtonId(), 4);
                }
            } else if (playPauseState == ButtonState.NORMAL) {
                NotificationStyle notificationStyle53 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle53);
                int n = notificationStyle53.getCancelButtonId();
                NotificationStyle notificationStyle54 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle54);
                remoteViews.setImageViewResource(n, notificationStyle54.getCancelIcon());
                NotificationStyle notificationStyle55 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle55);
                remoteViews.setOnClickPendingIntent(notificationStyle55.getCancelButtonId(), this.mCancelIntent);
                NotificationStyle notificationStyle56 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle56);
                remoteViews.setViewVisibility(notificationStyle56.getCancelButtonId(), 0);
                if (big) {
                    if (skipState == ButtonState.NORMAL) {
                        NotificationStyle notificationStyle57 = this.mNotificationStyle;
                        Intrinsics.checkNotNull((Object)notificationStyle57);
                        int n2 = notificationStyle57.getSkipButtonId();
                        NotificationStyle notificationStyle58 = this.mNotificationStyle;
                        Intrinsics.checkNotNull((Object)notificationStyle58);
                        remoteViews.setImageViewResource(n2, notificationStyle58.getSkipIcon());
                        NotificationStyle notificationStyle59 = this.mNotificationStyle;
                        Intrinsics.checkNotNull((Object)notificationStyle59);
                        remoteViews.setOnClickPendingIntent(notificationStyle59.getSkipButtonId(), this.mNextIntent);
                        NotificationStyle notificationStyle60 = this.mNotificationStyle;
                        Intrinsics.checkNotNull((Object)notificationStyle60);
                        remoteViews.setViewVisibility(notificationStyle60.getSkipButtonId(), 0);
                    } else {
                        NotificationStyle notificationStyle61 = this.mNotificationStyle;
                        Intrinsics.checkNotNull((Object)notificationStyle61);
                        remoteViews.setViewVisibility(notificationStyle61.getSkipButtonId(), 4);
                    }
                } else {
                    NotificationStyle notificationStyle62 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle62);
                    remoteViews.setViewVisibility(notificationStyle62.getSkipButtonId(), 8);
                }
            } else {
                NotificationStyle notificationStyle63 = this.mNotificationStyle;
                Intrinsics.checkNotNull((Object)notificationStyle63);
                remoteViews.setViewVisibility(notificationStyle63.getCancelButtonId(), 8);
                if (skipState == ButtonState.NORMAL) {
                    NotificationStyle notificationStyle64 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle64);
                    int n = notificationStyle64.getSkipButtonId();
                    NotificationStyle notificationStyle65 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle65);
                    remoteViews.setImageViewResource(n, notificationStyle65.getSkipIcon());
                    NotificationStyle notificationStyle66 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle66);
                    remoteViews.setOnClickPendingIntent(notificationStyle66.getSkipButtonId(), this.mNextIntent);
                    NotificationStyle notificationStyle67 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle67);
                    remoteViews.setViewVisibility(notificationStyle67.getSkipButtonId(), 0);
                } else {
                    NotificationStyle notificationStyle68 = this.mNotificationStyle;
                    Intrinsics.checkNotNull((Object)notificationStyle68);
                    remoteViews.setViewVisibility(notificationStyle68.getSkipButtonId(), 4);
                }
            }
        } else if (skipState == ButtonState.NORMAL) {
            NotificationStyle notificationStyle69 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle69);
            int n = notificationStyle69.getSkipButtonId();
            NotificationStyle notificationStyle70 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle70);
            remoteViews.setImageViewResource(n, notificationStyle70.getSkipIcon());
            NotificationStyle notificationStyle71 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle71);
            remoteViews.setOnClickPendingIntent(notificationStyle71.getSkipButtonId(), this.mNextIntent);
            NotificationStyle notificationStyle72 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle72);
            remoteViews.setViewVisibility(notificationStyle72.getSkipButtonId(), 0);
        } else {
            NotificationStyle notificationStyle73 = this.mNotificationStyle;
            Intrinsics.checkNotNull((Object)notificationStyle73);
            remoteViews.setViewVisibility(notificationStyle73.getSkipButtonId(), 4);
        }
    }

    public MediaNotificationManager(@NotNull FeedAudioPlayer mAudioPlayer, @NotNull PlayerService mPlayerService, @Nullable MediaControllerCompat mMediaController, @Nullable PendingIntent mContentIntent, @Nullable NotificationStyle mNotificationStyle) {
        Notification notification;
        Intrinsics.checkNotNullParameter((Object)mAudioPlayer, (String)"mAudioPlayer");
        Intrinsics.checkNotNullParameter((Object)mPlayerService, (String)"mPlayerService");
        this.mAudioPlayer = mAudioPlayer;
        this.mPlayerService = mPlayerService;
        this.mMediaController = mMediaController;
        this.mContentIntent = mContentIntent;
        this.mNotificationStyle = mNotificationStyle;
        this.log = new FMLog("fm.feed.MediaNotif");
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)((Context)this.mPlayerService));
        Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"NotificationManagerCompat.from(mPlayerService)");
        this.mNotificationManager = notificationManagerCompat;
        this.callback = new MediaControllerCompat.Callback(this){
            final /* synthetic */ MediaNotificationManager this$0;

            public void onPlaybackStateChanged(@NotNull PlaybackStateCompat state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (state.getState() == 1 || state.getState() == 0) {
                    FMLog.d$default(MediaNotificationManager.access$getLog$p(this.this$0), "Playback state changed to STOPPED or NONE", null, 2, null);
                    return;
                }
                MediaNotificationManager.access$updateNotification(this.this$0);
            }

            public void onMetadataChanged(@Nullable MediaMetadataCompat metadata) {
                FMLog.d$default(MediaNotificationManager.access$getLog$p(this.this$0), "Metadata changed", null, 2, null);
                MediaNotificationManager.access$updateNotification(this.this$0);
            }

            public void onExtrasChanged(@Nullable Bundle extras) {
                FMLog.d$default(MediaNotificationManager.access$getLog$p(this.this$0), "Extras changed", null, 2, null);
                MediaNotificationManager.access$updateNotification(this.this$0);
            }

            public void onSessionDestroyed() {
                FMLog.d$default(MediaNotificationManager.access$getLog$p(this.this$0), "Session destroyed", null, 2, null);
                this.this$0.cancelNotification();
            }
            {
                this.this$0 = this$0;
            }
        };
        String pkg = this.mPlayerService.getPackageName();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)((Context)this.mPlayerService), (int)808, (Intent)new Intent(ACTION_PAUSE).setPackage(pkg), (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_CANCEL_CURRENT)");
        this.mPauseIntent = pendingIntent;
        PendingIntent pendingIntent2 = PendingIntent.getBroadcast((Context)((Context)this.mPlayerService), (int)808, (Intent)new Intent(ACTION_PLAY).setPackage(pkg), (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent2, (String)"PendingIntent.getBroadca\u2026tent.FLAG_CANCEL_CURRENT)");
        this.mPlayIntent = pendingIntent2;
        PendingIntent pendingIntent3 = PendingIntent.getBroadcast((Context)((Context)this.mPlayerService), (int)808, (Intent)new Intent(ACTION_NEXT).setPackage(pkg), (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent3, (String)"PendingIntent.getBroadca\u2026tent.FLAG_CANCEL_CURRENT)");
        this.mNextIntent = pendingIntent3;
        PendingIntent pendingIntent4 = PendingIntent.getBroadcast((Context)((Context)this.mPlayerService), (int)808, (Intent)new Intent(ACTION_CANCEL).setPackage(pkg), (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent4, (String)"PendingIntent.getBroadca\u2026tent.FLAG_CANCEL_CURRENT)");
        this.mCancelIntent = pendingIntent4;
        PendingIntent pendingIntent5 = PendingIntent.getBroadcast((Context)((Context)this.mPlayerService), (int)808, (Intent)new Intent(ACTION_LIKE).setPackage(pkg), (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent5, (String)"PendingIntent.getBroadca\u2026tent.FLAG_CANCEL_CURRENT)");
        this.mLikeIntent = pendingIntent5;
        PendingIntent pendingIntent6 = PendingIntent.getBroadcast((Context)((Context)this.mPlayerService), (int)808, (Intent)new Intent(ACTION_DISLIKE).setPackage(pkg), (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent6, (String)"PendingIntent.getBroadca\u2026tent.FLAG_CANCEL_CURRENT)");
        this.mDislikeIntent = pendingIntent6;
        this.mNotificationManager.cancelAll();
        MediaControllerCompat mediaControllerCompat = this.mMediaController;
        Intrinsics.checkNotNull((Object)mediaControllerCompat);
        mediaControllerCompat.registerCallback((MediaControllerCompat.Callback)this.callback);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_NEXT);
        filter.addAction(ACTION_PLAY);
        filter.addAction(ACTION_PAUSE);
        filter.addAction(ACTION_CANCEL);
        filter.addAction(ACTION_LIKE);
        filter.addAction(ACTION_DISLIKE);
        this.mPlayerService.registerReceiver(this, filter);
        this.mForeground = true;
        if (Build.VERSION.SDK_INT >= 26) {
            this.createChannel();
        }
        if ((notification = this.createNotification()) != null) {
            this.mPlayerService.startForeground(53376, notification);
        }
        this.updateNotification();
    }

    public static final /* synthetic */ FMLog access$getLog$p(MediaNotificationManager $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$updateNotification(MediaNotificationManager $this) {
        $this.updateNotification();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lfm/feed/android/playersdk/MediaNotificationManager$ButtonState;", "", "(Ljava/lang/String;I)V", "DISABLED", "NORMAL", "SELECTED", "PlayerSdk_exo2118Release"})
    private static final class ButtonState
    extends Enum<ButtonState> {
        public static final /* enum */ ButtonState DISABLED;
        public static final /* enum */ ButtonState NORMAL;
        public static final /* enum */ ButtonState SELECTED;
        private static final /* synthetic */ ButtonState[] $VALUES;

        static {
            ButtonState[] buttonStateArray = new ButtonState[3];
            ButtonState[] buttonStateArray2 = buttonStateArray;
            buttonStateArray[0] = DISABLED = new ButtonState();
            buttonStateArray[1] = NORMAL = new ButtonState();
            buttonStateArray[2] = SELECTED = new ButtonState();
            $VALUES = buttonStateArray;
        }

        public static ButtonState[] values() {
            return (ButtonState[])$VALUES.clone();
        }

        public static ButtonState valueOf(String string) {
            return Enum.valueOf(ButtonState.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfm/feed/android/playersdk/MediaNotificationManager$Companion;", "", "()V", "ACTION_CANCEL", "", "ACTION_DISLIKE", "ACTION_LIKE", "ACTION_NEXT", "ACTION_PAUSE", "ACTION_PLAY", "CHANNEL_ID", "NOTIFICATION_ID", "", "REQUEST_CODE", "PlayerSdk_exo2118Release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

