/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fm.feed.android.playersdk.FMLog;
import fm.feed.android.playersdk.OfflineStationManager;
import fm.feed.android.playersdk.StationDownloadListener;
import fm.feed.android.playersdk.models.AudioFile;
import fm.feed.android.playersdk.models.Play;
import fm.feed.android.playersdk.models.Station;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\n\b\u0000\u0018\u0000 X2\u00020\u0001:\u0002XYB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201J\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020503H\u0002J\u0006\u00106\u001a\u00020\u001bJ\u0006\u00107\u001a\u00020'J\u001e\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020\u00152\f\u0010:\u001a\b\u0012\u0004\u0012\u0002040\fH\u0002J\u0012\u0010;\u001a\u00020'2\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u000e\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020\u0017J\u0006\u0010@\u001a\u00020'J\u0014\u0010A\u001a\b\u0012\u0004\u0012\u0002040\f2\u0006\u0010?\u001a\u00020\u0017J\u0012\u0010B\u001a\u0004\u0018\u00010\u00152\u0006\u0010?\u001a\u00020\u0017H\u0002J\u000e\u0010C\u001a\u0002012\u0006\u0010?\u001a\u00020\u0017J\u0018\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020\u00172\b\u0010F\u001a\u0004\u0018\u00010\u0017J\u0006\u0010G\u001a\u00020'J\u000e\u0010H\u001a\u00020'2\u0006\u0010I\u001a\u00020\u001bJ\u000e\u0010J\u001a\u00020'2\u0006\u0010<\u001a\u000204J\u000e\u0010K\u001a\u00020'2\u0006\u0010<\u001a\u000204J\u000e\u0010L\u001a\u00020'2\u0006\u0010<\u001a\u000204J\u0006\u0010M\u001a\u00020'J\u000e\u0010N\u001a\u0002012\u0006\u0010O\u001a\u00020PJ\u000e\u0010Q\u001a\u00020'2\u0006\u0010<\u001a\u000204J\u0006\u0010R\u001a\u00020'J\b\u0010S\u001a\u00020'H\u0002J\u0016\u0010T\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u000e\u0010U\u001a\u00020'2\u0006\u0010?\u001a\u00020\u0017J\u0006\u0010V\u001a\u00020'J\u000e\u0010W\u001a\u00020'2\u0006\u0010O\u001a\u00020PR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001c\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000e\u00a8\u0006Z"}, d2={"Lfm/feed/android/playersdk/OfflineSession;", "", "context", "Landroid/content/Context;", "eventListener", "Lfm/feed/android/playersdk/OfflineSession$OfflineEventListener;", "(Landroid/content/Context;Lfm/feed/android/playersdk/OfflineSession$OfflineEventListener;)V", "activeStation", "Lfm/feed/android/playersdk/models/Station;", "getActiveStation", "()Lfm/feed/android/playersdk/models/Station;", "availableStationList", "", "getAvailableStationList", "()Ljava/util/List;", "<set-?>", "Lfm/feed/android/playersdk/models/Play;", "currentItem", "getCurrentItem", "()Lfm/feed/android/playersdk/models/Play;", "currentManager", "Lfm/feed/android/playersdk/OfflineStationManager;", "fileStoragePath", "", "log", "Lfm/feed/android/playersdk/FMLog;", "logs", "Lorg/json/JSONArray;", "nextItem", "getNextItem", "offlineStationManagers", "", "savedStationList", "getSavedStationList", "sharedPreferences", "Landroid/content/SharedPreferences;", "stationList", "getStationList", "addOfflineStation", "", "station", "listener", "Lfm/feed/android/playersdk/StationDownloadListener;", "appendLogEntry", "entry", "Lorg/json/JSONObject;", "calculateOfflineStorageUsed", "", "canSkip", "", "computeAudioItemCounts", "", "Lfm/feed/android/playersdk/models/AudioFile;", "", "copyAndResetLogs", "deleteAllStations", "deleteAudioItemsFromOfflineStationManager", "manager", "audioItems", "deleteExtraneousFilesIn", "file", "Ljava/io/File;", "deleteLocalStationWithName", "name", "destroy", "getAudioItemsForLocalStationWithName", "getStationManagerForStationName", "isStationAvailableWithName", "logEvent", "event", "parms", "playStarted", "prependLogs", "entries", "rejectItem", "requestDislikeForItem", "requestLikeForItem", "requestNextItem", "requestSkip", "time", "", "requestUnlikeForItem", "reset", "retrieveLogs", "saveStationList", "setActiveStationByName", "updatePlayCompleted", "updatePlayTime", "Companion", "OfflineEventListener", "PlayerSdk_exo2118Release"})
public final class OfflineSession {
    private final FMLog log;
    private final List<OfflineStationManager> offlineStationManagers;
    private JSONArray logs;
    @Nullable
    private Play currentItem;
    @Nullable
    private Play nextItem;
    private OfflineStationManager currentManager;
    private final SharedPreferences sharedPreferences;
    private final String fileStoragePath;
    private final OfflineEventListener eventListener;
    private static final String OFFLINE_PREFS_SHARED_PREF_KEY;
    private static final String OFFLINE_STATIONS_SHARED_PREF_KEY;
    private static final String LOGS_SHARED_PREF_KEY;
    private static final String FILES_SUBDIR;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Play getCurrentItem() {
        return this.currentItem;
    }

    @Nullable
    public final Play getNextItem() {
        return this.nextItem;
    }

    @Nullable
    public final Station getActiveStation() {
        OfflineStationManager offlineStationManager = this.currentManager;
        return offlineStationManager != null ? offlineStationManager.getStation() : null;
    }

    private final List<Station> getSavedStationList() {
        Gson gson = new Gson();
        String json = this.sharedPreferences.getString(OFFLINE_STATIONS_SHARED_PREF_KEY, "[]");
        List stationList = null;
        try {
            stationList = (List)gson.fromJson(json, new TypeToken<List<? extends Station>>(){}.getType());
        }
        catch (Exception e) {
            FMLog.e$default(this.log, "Unable to parse saved station list " + e, null, 2, null);
        }
        if (stationList == null) {
            stationList = new ArrayList();
        }
        return stationList;
    }

    @NotNull
    public final List<Station> getStationList() {
        ArrayList<Station> stationList = new ArrayList<Station>();
        for (OfflineStationManager stationManager : this.offlineStationManagers) {
            stationList.add(stationManager.getStation());
        }
        return stationList;
    }

    @NotNull
    public final List<Station> getAvailableStationList() {
        ArrayList<Station> stationList = new ArrayList<Station>();
        for (OfflineStationManager stationManager : this.offlineStationManagers) {
            if (!stationManager.isStationAvailableOffline()) continue;
            stationList.add(stationManager.getStation());
        }
        return stationList;
    }

    private final void retrieveLogs() {
        String str = this.sharedPreferences.getString(LOGS_SHARED_PREF_KEY, "[]");
        try {
            this.logs = new JSONArray(str);
        }
        catch (JSONException e) {
            FMLog.e$default(this.log, "Exception parsing stored logs" + (Object)((Object)e), null, 2, null);
        }
        this.logs = new JSONArray();
    }

    public final void appendLogEntry(@NotNull JSONObject entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        JSONArray jSONArray = this.logs;
        Intrinsics.checkNotNull((Object)jSONArray);
        jSONArray.put((Object)entry);
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        JSONArray jSONArray2 = this.logs;
        Intrinsics.checkNotNull((Object)jSONArray2);
        editor.putString(LOGS_SHARED_PREF_KEY, jSONArray2.toString()).apply();
    }

    @NotNull
    public final JSONArray copyAndResetLogs() {
        JSONArray retval = this.logs;
        this.logs = new JSONArray();
        JSONArray jSONArray = retval;
        Intrinsics.checkNotNull((Object)jSONArray);
        if (jSONArray.length() > 0) {
            this.sharedPreferences.edit().remove(LOGS_SHARED_PREF_KEY).apply();
        }
        return retval;
    }

    public final void prependLogs(@NotNull JSONArray entries) {
        int i;
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        JSONArray newLogs = new JSONArray();
        int n = 0;
        int n2 = entries.length();
        while (n < n2) {
            try {
                newLogs.put(entries.get(i));
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "Log parsing error" + (Object)((Object)e), null, 2, null);
            }
            ++i;
        }
        JSONArray jSONArray = this.logs;
        Intrinsics.checkNotNull((Object)jSONArray);
        n2 = jSONArray.length();
        for (i = 0; i < n2; ++i) {
            try {
                newLogs.put(entries.get(i));
                continue;
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "Log parsing error " + (Object)((Object)e), null, 2, null);
            }
        }
        this.logs = newLogs;
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        JSONArray jSONArray2 = this.logs;
        Intrinsics.checkNotNull((Object)jSONArray2);
        editor.putString(LOGS_SHARED_PREF_KEY, jSONArray2.toString()).apply();
    }

    public final void setActiveStationByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        OfflineStationManager manager = this.getStationManagerForStationName(name);
        if (manager == null) {
            FMLog.d$default(this.log, "Cannot find offline station with name " + name, null, 2, null);
            return;
        }
        if (this.currentManager != null) {
            OfflineStationManager offlineStationManager = this.currentManager;
            Intrinsics.checkNotNull((Object)offlineStationManager);
            if (Intrinsics.areEqual((Object)offlineStationManager.getStation().getName(), (Object)name)) {
                FMLog.d$default(this.log, "Not changing offline station to same station!", null, 2, null);
                return;
            }
        }
        FMLog.d$default(this.log, "Updating current offline station to " + name, null, 2, null);
        this.reset();
        this.currentManager = manager;
        this.eventListener.activeStationDidChange();
    }

    public final void reset() {
        this.nextItem = null;
        this.currentItem = null;
    }

    public final void destroy() {
        this.reset();
        this.currentManager = null;
    }

    public final void addOfflineStation(@NotNull Station station, @NotNull StationDownloadListener listener2) {
        Intrinsics.checkNotNullParameter((Object)station, (String)"station");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        OfflineStationManager manager = this.getStationManagerForStationName(station.getName());
        List<Station> stationList = this.getSavedStationList();
        FMLog.d$default(this.log, (manager == null ? "Adding" : "Updating") + " offline station " + station, null, 2, null);
        stationList.add(station);
        if (manager != null) {
            Station oldStation = manager.getStation();
            stationList.remove(oldStation);
            ArrayList<AudioFile> deleteList = new ArrayList<AudioFile>();
            List<AudioFile> oldAudioFiles = oldStation.getAudioFiles();
            if (oldAudioFiles != null) {
                List<AudioFile> newAudioFiles = station.getAudioFiles();
                if (newAudioFiles == null) {
                    this.deleteAudioItemsFromOfflineStationManager(manager, oldAudioFiles);
                } else {
                    for (AudioFile file : oldAudioFiles) {
                        if (newAudioFiles.contains(file)) continue;
                        deleteList.add(file);
                    }
                    this.deleteAudioItemsFromOfflineStationManager(manager, (List<AudioFile>)deleteList);
                }
            }
        }
        this.saveStationList(stationList);
        OfflineStationManager newManager = new OfflineStationManager(station, this.fileStoragePath, this.sharedPreferences);
        if (manager != null) {
            this.offlineStationManagers.remove(manager);
        }
        this.offlineStationManagers.add(newManager);
        if (this.currentManager != null) {
            OfflineStationManager offlineStationManager = this.currentManager;
            Intrinsics.checkNotNull((Object)offlineStationManager);
            if (Intrinsics.areEqual((Object)offlineStationManager.getStation().getName(), (Object)newManager.getStation().getName())) {
                this.currentManager = newManager;
            }
        }
        newManager.downloadStation(listener2);
    }

    private final void saveStationList(List<Station> stationList) {
        if (stationList.isEmpty()) {
            this.sharedPreferences.edit().remove(OFFLINE_STATIONS_SHARED_PREF_KEY).apply();
        } else {
            Gson gson = new Gson();
            String json = gson.toJson(stationList);
            this.sharedPreferences.edit().putString(OFFLINE_STATIONS_SHARED_PREF_KEY, json).apply();
        }
    }

    private final OfflineStationManager getStationManagerForStationName(String name) {
        OfflineStationManager smg = null;
        for (OfflineStationManager mg : this.offlineStationManagers) {
            if (!Intrinsics.areEqual((Object)mg.getStation().getName(), (Object)name)) continue;
            smg = mg;
            break;
        }
        return smg;
    }

    public final void deleteAllStations() {
        for (OfflineStationManager manager : this.offlineStationManagers) {
            manager.deleteFilesForAudioItems(manager.getAudioFilesAvailable());
            manager.deleteConfig();
        }
        this.offlineStationManagers.clear();
        this.deleteExtraneousFilesIn(new File(this.fileStoragePath));
        this.saveStationList(new LinkedList());
    }

    public final void deleteLocalStationWithName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        OfflineStationManager osm = this.getStationManagerForStationName(name);
        if (osm != null) {
            Station station = osm.getStation();
            FMLog.d$default(this.log, "Deleting station " + station, null, 2, null);
            this.deleteAudioItemsFromOfflineStationManager(osm, osm.getAudioFilesAvailable());
            osm.deleteConfig();
            this.offlineStationManagers.remove(osm);
            List<Station> stationList = this.getSavedStationList();
            stationList.remove(osm.getStation());
            this.saveStationList(stationList);
        }
    }

    @NotNull
    public final List<AudioFile> getAudioItemsForLocalStationWithName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        OfflineStationManager manager = this.getStationManagerForStationName(name);
        Object object = manager;
        if (object == null || (object = ((OfflineStationManager)object).getAudioFilesAvailable()) == null) {
            object = new ArrayList();
        }
        return object;
    }

    private final void deleteAudioItemsFromOfflineStationManager(OfflineStationManager manager, List<AudioFile> audioItems) {
        Map<AudioFile, Integer> counts = this.computeAudioItemCounts();
        LinkedList<AudioFile> toDelete = new LinkedList<AudioFile>();
        for (AudioFile audioFile : audioItems) {
            Integer count = counts.get(audioFile);
            if (count != null && count > 1) continue;
            toDelete.add(audioFile);
        }
        manager.deleteFilesForAudioItems((List<AudioFile>)toDelete);
    }

    private final void deleteExtraneousFilesIn(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            try {
                FMLog.d$default(this.log, "Deleting extraneous file:" + file, null, 2, null);
                if (!file.delete()) {
                    FMLog.w$default(this.log, "Unable to delete extraneous file:" + file, null, 2, null);
                }
            }
            catch (SecurityException e) {
                FMLog.e$default(this.log, "Problem cleaning up excess storage " + e, null, 2, null);
            }
            return;
        }
        File[] array = file.listFiles();
        if (array != null) {
            for (File child : array) {
                try {
                    File file2 = child;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"child");
                    if (file2.isDirectory()) {
                        this.deleteExtraneousFilesIn(child);
                        continue;
                    }
                    FMLog.d$default(this.log, "Deleting extraneous file:" + child, null, 2, null);
                    if (child.delete()) continue;
                    FMLog.w$default(this.log, "Unable to delete extraneous file: " + child, null, 2, null);
                }
                catch (SecurityException e) {
                    FMLog.e$default(this.log, "Problem cleaning up excess storage" + e, null, 2, null);
                }
            }
        }
    }

    public final long calculateOfflineStorageUsed() {
        File file = new File(this.fileStoragePath);
        if (!file.exists()) {
            return 0L;
        }
        if (!file.isDirectory()) {
            FMLog.v$default(this.log, "  in storage: " + file + ": " + file.length(), null, 2, null);
            return file.length();
        }
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(file);
        long result = 0L;
        while (!dirs.isEmpty()) {
            File[] listFiles;
            Object e = dirs.remove(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"dirs.removeAt(0)");
            File dir = (File)e;
            if (!dir.exists() || (listFiles = dir.listFiles()) == null) continue;
            File[] fileArray = listFiles;
            int n = 0;
            if (fileArray.length == 0) continue;
            for (File child : listFiles) {
                FMLog.v$default(this.log, "  in storage: " + child + ": " + child.length(), null, 2, null);
                result += child.length();
                File file2 = child;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"child");
                if (!file2.isDirectory()) continue;
                dirs.add(child);
            }
        }
        return result;
    }

    private final Map<AudioFile, Integer> computeAudioItemCounts() {
        HashMap map = new HashMap();
        for (OfflineStationManager sm : this.offlineStationManagers) {
            List<AudioFile> audioFiles = sm.getAudioFilesAvailable();
            for (AudioFile audioFile : audioFiles) {
                Integer count = (Integer)map.get(audioFile);
                if (count == null) {
                    ((Map)map).put(audioFile, 1);
                    continue;
                }
                ((Map)map).put(audioFile, count + 1);
            }
        }
        return map;
    }

    public final boolean isStationAvailableWithName(@NotNull String name) {
        OfflineStationManager manager;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        OfflineStationManager offlineStationManager = manager = this.getStationManagerForStationName(name);
        return offlineStationManager != null ? offlineStationManager.isStationAvailableOffline() : false;
    }

    public final void requestNextItem() {
        block7: {
            FMLog.v$default(this.log, "Looking for next item", null, 2, null);
            if (this.nextItem != null) {
                FMLog.d$default(this.log, "Not Requesting next item since we already have one", null, 2, null);
                return;
            }
            if (this.currentManager == null) {
                FMLog.d$default(this.log, "Not Requesting next item since there is no current manager", null, 2, null);
                return;
            }
            OfflineStationManager offlineStationManager = this.currentManager;
            if (offlineStationManager == null) break block7;
            OfflineStationManager offlineStationManager2 = offlineStationManager;
            boolean bl = false;
            boolean bl2 = false;
            OfflineStationManager it = offlineStationManager2;
            boolean bl3 = false;
            this.nextItem = it.getNextPlay();
            if (this.nextItem != null) {
                StringBuilder stringBuilder = new StringBuilder().append("Next offline item set to ");
                Play play2 = this.nextItem;
                Intrinsics.checkNotNull((Object)play2);
                FMLog.d$default(this.log, stringBuilder.append(play2).toString(), null, 2, null);
                this.eventListener.nextItemAvailable();
            } else {
                OfflineStationManager offlineStationManager3 = this.currentManager;
                if (offlineStationManager3 != null) {
                    offlineStationManager3.shuffleStation();
                }
                this.nextItem = it.getNextPlay();
                if (this.nextItem != null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Next offline item set to ");
                    Play play3 = this.nextItem;
                    Intrinsics.checkNotNull((Object)play3);
                    FMLog.d$default(this.log, stringBuilder.append(play3).toString(), null, 2, null);
                    this.eventListener.nextItemAvailable();
                } else {
                    this.eventListener.noMoreMusic();
                }
            }
        }
    }

    public final void updatePlayTime(float time) {
        block2: {
            Play play2 = this.currentItem;
            if (play2 == null) break block2;
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("event", (Object)"elapse");
                jsonObject.put("play_id", (Object)it.getId());
                jsonObject.put("seconds", (double)time);
                jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
                this.appendLogEntry(jsonObject);
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "unable to encode play time event" + (Object)((Object)e), null, 2, null);
            }
        }
    }

    public final boolean canSkip() {
        return true;
    }

    public final boolean requestSkip(float time) {
        Play play2 = this.currentItem;
        if (play2 != null) {
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("event", (Object)"skip");
                jsonObject.put("play_id", (Object)it.getId());
                jsonObject.put("seconds", (double)time);
                jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
                this.appendLogEntry(jsonObject);
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "Unable to encode skip request event" + (Object)((Object)e), null, 2, null);
            }
            return true;
        }
        return false;
    }

    public final void playStarted() {
        block2: {
            this.currentItem = this.nextItem;
            this.eventListener.currentItemDidChange();
            this.nextItem = null;
            this.requestNextItem();
            Play play2 = this.currentItem;
            if (play2 == null) break block2;
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("event", (Object)"start");
                jsonObject.put("play_id", (Object)it.getId());
                jsonObject.put("audio_file_id", (Object)it.getAudioFile().getId());
                jsonObject.put("format", (Object)it.getAudioFile().getCodec());
                jsonObject.put("max_bitrate", (Object)it.getAudioFile().getBitrate());
                Station station = it.getStation();
                jsonObject.put("station_id", (Object)(station != null ? station.getId() : null));
                jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
                this.appendLogEntry(jsonObject);
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "Unable to encode play started event" + (Object)((Object)e), null, 2, null);
            }
        }
    }

    public final void updatePlayCompleted() {
        block3: {
            if (this.currentItem == null) {
                FMLog.d$default(this.log, "Trying to mark play completed when there is none!", null, 2, null);
                return;
            }
            Play play2 = this.currentItem;
            if (play2 == null) break block3;
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play it = play3;
            boolean bl3 = false;
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("event", (Object)"skip");
                jsonObject.put("play_id", (Object)it.getId());
                jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
                this.appendLogEntry(jsonObject);
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "Unable to encode play completed event" + (Object)((Object)e), null, 2, null);
            }
        }
    }

    public final void requestLikeForItem(@NotNull AudioFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("event", (Object)"like");
            jsonObject.put("audio_file_id", (Object)file.getId());
            jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
            this.appendLogEntry(jsonObject);
        }
        catch (JSONException e) {
            FMLog.e$default(this.log, "Unable to encode like request event " + (Object)((Object)e), null, 2, null);
        }
    }

    public final void requestUnlikeForItem(@NotNull AudioFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("event", (Object)"unlike");
            jsonObject.put("audio_file_id", (Object)file.getId());
            jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
            this.appendLogEntry(jsonObject);
        }
        catch (JSONException e) {
            FMLog.e$default(this.log, "Unable to encode unlike event" + (Object)((Object)e), null, 2, null);
        }
    }

    public final void requestDislikeForItem(@NotNull AudioFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("event", (Object)"dislike");
            jsonObject.put("audio_file_id", (Object)file.getId());
            jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
            this.appendLogEntry(jsonObject);
        }
        catch (JSONException e) {
            FMLog.e$default(this.log, "Unable to encode dislike event" + (Object)((Object)e), null, 2, null);
        }
    }

    public final void logEvent(@NotNull String event, @Nullable String parms) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("event", (Object)"event");
            jsonObject.put("name", (Object)event);
            jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
            if (parms != null) {
                jsonObject.put("parameters", (Object)parms);
            }
            this.appendLogEntry(jsonObject);
        }
        catch (JSONException e) {
            FMLog.e$default(this.log, "Unable to encode generic event event" + (Object)((Object)e), null, 2, null);
        }
    }

    public final void rejectItem(@NotNull AudioFile file) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Play play2 = this.currentItem;
            if (play2 == null) break block6;
            Play play3 = play2;
            boolean bl = false;
            boolean bl2 = false;
            Play play4 = play3;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)file.getId(), (Object)play4.getAudioFile().getId())) {
                this.currentItem = this.nextItem;
                this.nextItem = null;
                this.requestNextItem();
            } else {
                Play play5 = this.nextItem;
                if (play5 != null) {
                    Play play6 = play5;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Play it = play6;
                    boolean bl6 = false;
                    if (Intrinsics.areEqual((Object)file.getId(), (Object)it.getId())) {
                        this.nextItem = null;
                        this.requestNextItem();
                    }
                }
            }
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("event", (Object)"invalidate");
                jsonObject.put("audio_file_id", (Object)play4.getAudioFile().getId());
                jsonObject.put("format", (Object)play4.getAudioFile().getCodec());
                jsonObject.put("max_bitrate", (Object)play4.getAudioFile().getBitrate());
                Station station = play4.getStation();
                jsonObject.put("station_id", (Object)(station != null ? station.getId() : null));
                jsonObject.put("ts", System.currentTimeMillis() / (long)1000);
                this.appendLogEntry(jsonObject);
            }
            catch (JSONException e) {
                FMLog.e$default(this.log, "Unable to encode invalidate event " + (Object)((Object)e), null, 2, null);
            }
        }
    }

    public OfflineSession(@NotNull Context context, @NotNull OfflineEventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.eventListener = eventListener;
        this.log = new FMLog("fm.feed.OfflineSession");
        this.offlineStationManagers = new ArrayList();
        SharedPreferences sharedPreferences = context.getSharedPreferences(OFFLINE_PREFS_SHARED_PREF_KEY, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026EY, Context.MODE_PRIVATE)");
        this.sharedPreferences = sharedPreferences;
        StringBuilder stringBuilder = new StringBuilder();
        File file = context.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.filesDir");
        this.fileStoragePath = stringBuilder.append(file.getPath()).append(FILES_SUBDIR).toString();
        List<Station> stationList = this.getSavedStationList();
        Date dateNow = new Date();
        for (Station st : stationList) {
            OfflineStationManager manager;
            Date date;
            if (st.getExpiry() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            Date it = date;
            boolean bl3 = false;
            if (it.after(dateNow)) {
                manager = new OfflineStationManager(st, this.fileStoragePath, this.sharedPreferences);
                this.offlineStationManagers.add(manager);
                continue;
            }
            manager = new OfflineStationManager(st, this.fileStoragePath, this.sharedPreferences);
            this.offlineStationManagers.add(manager);
            this.deleteLocalStationWithName(st.getName());
        }
        if (this.offlineStationManagers.size() > 0) {
            this.currentManager = this.offlineStationManagers.get(0);
        }
        this.retrieveLogs();
    }

    static {
        Companion = new Companion(null);
        OFFLINE_PREFS_SHARED_PREF_KEY = "FeedFMOffline";
        OFFLINE_STATIONS_SHARED_PREF_KEY = "OfflineStations";
        LOGS_SHARED_PREF_KEY = "logs";
        FILES_SUBDIR = "/feedfm";
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lfm/feed/android/playersdk/OfflineSession$OfflineEventListener;", "", "activeStationDidChange", "", "currentItemDidChange", "nextItemAvailable", "noMoreMusic", "PlayerSdk_exo2118Release"})
    public static interface OfflineEventListener {
        public void currentItemDidChange();

        public void nextItemAvailable();

        public void activeStationDidChange();

        public void noMoreMusic();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lfm/feed/android/playersdk/OfflineSession$Companion;", "", "()V", "FILES_SUBDIR", "", "LOGS_SHARED_PREF_KEY", "OFFLINE_PREFS_SHARED_PREF_KEY", "OFFLINE_STATIONS_SHARED_PREF_KEY", "PlayerSdk_exo2118Release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

