/*
 * Decompiled with CFR 0.152.
 */
package fm.feed.android.playersdk.models.webservice;

import com.google.gson.annotations.SerializedName;
import fm.feed.android.playersdk.ApiErrorEnum;
import fm.feed.android.playersdk.PlayerError;

public class FeedFMError
extends Exception {
    @SerializedName(value="code")
    private int code;
    @SerializedName(value="message")
    private String message;
    @SerializedName(value="status")
    private int status;
    private PlayerError mPlayerError;
    private ApiErrorEnum mApiError;
    private Type type;

    public FeedFMError(int code, String message, int status) {
        this.code = code;
        this.message = message;
        this.status = status;
        this.setPlayerError(code);
        if (this.mPlayerError != null) {
            this.type = Type.Player;
        }
        this.setApiError(code);
        if (this.mApiError != null) {
            this.type = Type.Api;
        }
    }

    public FeedFMError(ApiErrorEnum errorEnum) {
        this.mApiError = errorEnum;
        this.code = this.mApiError.getCode();
        this.message = this.mApiError.getMessage();
        this.status = this.mApiError.getStatus();
        this.type = Type.Api;
    }

    public FeedFMError(PlayerError errorEnum) {
        this.mPlayerError = errorEnum;
        this.code = this.mPlayerError.getCode();
        this.message = this.mPlayerError.getMessage();
        this.status = -1;
        this.type = Type.Player;
    }

    public void updateErrorType() {
        this.setPlayerError(this.code);
        this.setApiError(this.code);
    }

    private void setPlayerError(int code) {
        this.mPlayerError = PlayerError.Companion.fromCode(code);
    }

    private void setApiError(int code) {
        this.mApiError = ApiErrorEnum.fromCode(code);
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public PlayerError getPlayerError() {
        return this.mPlayerError;
    }

    public ApiErrorEnum getApiError() {
        return this.mApiError;
    }

    public boolean isPlayerError() {
        if (this.mPlayerError != null) {
            return true;
        }
        this.setPlayerError(this.code);
        return this.mPlayerError != null;
    }

    public boolean isApiError() {
        if (this.mApiError != null) {
            return true;
        }
        this.setApiError(this.code);
        return this.mApiError != null;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.format("{ type: \"%s Error\", code: %d, message: \"%s\", status: %s }", new Object[]{this.getType(), this.getCode(), this.getMessage(), this.getStatus()});
    }

    private static enum Type {
        Player,
        Api;

    }
}

