/*
 * Decompiled with CFR 0.152.
 */
package foundation.metaplex.solana.transactions;

import com.ditchoom.buffer.BufferFactoryJvm;
import com.ditchoom.buffer.PlatformBuffer;
import foundation.metaplex.base58.Base58Kt;
import foundation.metaplex.solana.transactions.CompiledInstruction;
import foundation.metaplex.solana.transactions.Message;
import foundation.metaplex.solana.transactions.MessageHeader;
import foundation.metaplex.solana.transactions.WrappedInstruction;
import foundation.metaplex.solana.util.Shortvec;
import foundation.metaplex.solanapublickeys.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lfoundation/metaplex/solana/transactions/SolanaMessage;", "Lfoundation/metaplex/solana/transactions/Message;", "header", "Lfoundation/metaplex/solana/transactions/MessageHeader;", "accountKeys", "", "Lfoundation/metaplex/solanapublickeys/PublicKey;", "recentBlockhash", "", "instructions", "Lfoundation/metaplex/solana/transactions/CompiledInstruction;", "feePayer", "indexToProgramIds", "", "", "(Lfoundation/metaplex/solana/transactions/MessageHeader;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Lfoundation/metaplex/solanapublickeys/PublicKey;Ljava/util/Map;)V", "getAccountKeys", "()Ljava/util/List;", "getHeader", "()Lfoundation/metaplex/solana/transactions/MessageHeader;", "getInstructions", "getRecentBlockhash", "()Ljava/lang/String;", "isAccountSigner", "", "index", "isAccountWritable", "isProgramId", "nonProgramIds", "programIds", "serialize", "", "setFeePayer", "", "publicKey", "Companion", "solana"})
@SourceDebugExtension(value={"SMAP\nSolanaMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolanaMessage.kt\nfoundation/metaplex/solana/transactions/SolanaMessage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1855#2,2:175\n777#2:177\n788#2:178\n1864#2,2:179\n789#2,2:181\n1866#2:183\n791#2:184\n1549#2:186\n1620#2,2:187\n1549#2:189\n1620#2,3:190\n1622#2:193\n1#3:185\n*S KotlinDebug\n*F\n+ 1 SolanaMessage.kt\nfoundation/metaplex/solana/transactions/SolanaMessage\n*L\n35#1:175,2\n58#1:177\n58#1:178\n58#1:179,2\n58#1:181,2\n58#1:183\n58#1:184\n66#1:186\n66#1:187,2\n76#1:189\n76#1:190,3\n66#1:193\n*E\n"})
public final class SolanaMessage
implements Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageHeader header;
    @NotNull
    private final List<PublicKey> accountKeys;
    @NotNull
    private final String recentBlockhash;
    @NotNull
    private final List<CompiledInstruction> instructions;
    @Nullable
    private PublicKey feePayer;
    @NotNull
    private Map<Integer, PublicKey> indexToProgramIds;
    private static final int RECENT_BLOCK_HASH_LENGTH = 32;

    public SolanaMessage(@NotNull MessageHeader header, @NotNull List<PublicKey> accountKeys, @NotNull String recentBlockhash, @NotNull List<CompiledInstruction> instructions, @Nullable PublicKey feePayer, @NotNull Map<Integer, PublicKey> indexToProgramIds) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(accountKeys, (String)"accountKeys");
        Intrinsics.checkNotNullParameter((Object)recentBlockhash, (String)"recentBlockhash");
        Intrinsics.checkNotNullParameter(instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(indexToProgramIds, (String)"indexToProgramIds");
        this.header = header;
        this.accountKeys = accountKeys;
        this.recentBlockhash = recentBlockhash;
        this.instructions = instructions;
        this.feePayer = feePayer;
        this.indexToProgramIds = indexToProgramIds;
        Iterable $this$forEach$iv = this.getInstructions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompiledInstruction ix = (CompiledInstruction)element$iv;
            boolean bl = false;
            this.indexToProgramIds.put(ix.getProgramIdIndex(), this.getAccountKeys().get(ix.getProgramIdIndex()));
        }
    }

    public /* synthetic */ SolanaMessage(MessageHeader messageHeader, List list, String string, List list2, PublicKey publicKey, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            publicKey = null;
        }
        if ((n & 0x20) != 0) {
            map = new LinkedHashMap();
        }
        this(messageHeader, list, string, list2, publicKey, map);
    }

    @Override
    @NotNull
    public MessageHeader getHeader() {
        return this.header;
    }

    @Override
    @NotNull
    public List<PublicKey> getAccountKeys() {
        return this.accountKeys;
    }

    @Override
    @NotNull
    public String getRecentBlockhash() {
        return this.recentBlockhash;
    }

    @Override
    @NotNull
    public List<CompiledInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public boolean isAccountSigner(int index) {
        return index < this.getHeader().getNumRequiredSignatures();
    }

    @Override
    public boolean isAccountWritable(int index) {
        return index < this.getHeader().getNumRequiredSignatures() - this.getHeader().getNumReadonlySignedAccounts() || index >= this.getHeader().getNumRequiredSignatures() && index < ((Collection)this.getAccountKeys()).size() - this.getHeader().getNumReadonlyUnsignedAccounts();
    }

    @Override
    public boolean isProgramId(int index) {
        return this.indexToProgramIds.containsKey(index);
    }

    @Override
    @NotNull
    public List<PublicKey> programIds() {
        return CollectionsKt.toList((Iterable)this.indexToProgramIds.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PublicKey> nonProgramIds() {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv = this.getAccountKeys();
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            PublicKey cfr_ignored_0 = (PublicKey)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!(!this.isProgramId(index))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] serialize() {
        void $this$mapTo$iv$iv3;
        if (!(((CharSequence)this.getRecentBlockhash()).length() > 0)) {
            boolean $i$a$-require-SolanaMessage$serialize$32 = false;
            String $i$a$-require-SolanaMessage$serialize$32 = "recentBlockhash required";
            throw new IllegalArgumentException($i$a$-require-SolanaMessage$serialize$32.toString());
        }
        if (!(!((Collection)this.getInstructions()).isEmpty())) {
            boolean $i$a$-require-SolanaMessage$serialize$42 = false;
            String $i$a$-require-SolanaMessage$serialize$42 = "No instructions provided";
            throw new IllegalArgumentException($i$a$-require-SolanaMessage$serialize$42.toString());
        }
        int numKeys = ((Collection)this.getAccountKeys()).size();
        byte[] keyCount = Shortvec.INSTANCE.encodeLength(numKeys);
        Iterable $this$map$iv = this.getInstructions();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Collection<Byte> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void instruction;
            CompiledInstruction compiledInstruction = (CompiledInstruction)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            int programIdIndex = instruction.component1();
            List<Integer> accounts = instruction.component2();
            byte[] data = Base58Kt.decodeBase58((String)instruction.getData());
            byte[] keyIndicesCount = Shortvec.INSTANCE.encodeLength(((Collection)accounts).size());
            byte[] dataCount = Shortvec.INSTANCE.encodeLength(data.length);
            Iterable iterable2 = accounts;
            byte[] byArray = keyIndicesCount;
            byte by = (byte)programIdIndex;
            boolean $i$f$map = false;
            void var22_31 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                int n = ((Number)item$iv$iv2).intValue();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((byte)it);
            }
            collection = (List)destination$iv$iv2;
            byte[] byArray2 = data;
            byte[] byArray3 = dataCount;
            byte[] byArray4 = CollectionsKt.toByteArray((Collection)collection);
            byte[] byArray5 = byArray;
            byte by2 = by;
            collection2.add(new WrappedInstruction(by2, byArray5, byArray4, byArray3, byArray2));
        }
        List instructions = (List)destination$iv$iv;
        Iterable $i$f$map22 = instructions;
        int $this$mapTo$iv$iv3 = 0;
        for (Object e : $i$f$map22) {
            void it;
            WrappedInstruction wrappedInstruction = (WrappedInstruction)e;
            int n = $this$mapTo$iv$iv3;
            boolean bl = false;
            int n2 = it.getLength();
            $this$mapTo$iv$iv3 = n + n2;
        }
        int compiledInstructionsLength = $this$mapTo$iv$iv3;
        byte[] instructionCount = Shortvec.INSTANCE.encodeLength(instructions.size());
        int bufferSize = 35 + keyCount.length + numKeys * 32 + instructionCount.length + compiledInstructionsLength;
        PlatformBuffer buffer = BufferFactoryJvm.allocate$default((PlatformBuffer.Companion)PlatformBuffer.Companion, (int)bufferSize, null, null, (int)6, null);
        buffer.writeByte(this.getHeader().getNumRequiredSignatures());
        buffer.writeByte(this.getHeader().getNumReadonlySignedAccounts());
        buffer.writeByte(this.getHeader().getNumReadonlyUnsignedAccounts());
        buffer.writeBytes(keyCount);
        for (PublicKey accountKey : this.getAccountKeys()) {
            buffer.writeBytes(accountKey.getPublicKeyBytes());
        }
        buffer.writeBytes(Base58Kt.decodeBase58((String)this.getRecentBlockhash()));
        buffer.writeBytes(instructionCount);
        for (WrappedInstruction instruction : instructions) {
            buffer.writeByte(instruction.getProgramIdIndex());
            buffer.writeBytes(instruction.getKeyIndicesCount());
            buffer.writeBytes(instruction.getKeyIndices());
            buffer.writeBytes(instruction.getDataLength());
            buffer.writeBytes(instruction.getData());
        }
        buffer.resetForRead();
        return buffer.readByteArray(bufferSize);
    }

    @Override
    public void setFeePayer(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.feePayer = publicKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lfoundation/metaplex/solana/transactions/SolanaMessage$Companion;", "", "()V", "RECENT_BLOCK_HASH_LENGTH", "", "from", "Lfoundation/metaplex/solana/transactions/Message;", "buffer", "", "solana"})
    @SourceDebugExtension(value={"SMAP\nSolanaMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolanaMessage.kt\nfoundation/metaplex/solana/transactions/SolanaMessage$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1#2:175\n1549#3:176\n1620#3,3:177\n1549#3:180\n1620#3,3:181\n*S KotlinDebug\n*F\n+ 1 SolanaMessage.kt\nfoundation/metaplex/solana/transactions/SolanaMessage$Companion\n*L\n143#1:176\n143#1:177,3\n165#1:180\n165#1:181,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Message from(@NotNull byte[] buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String data;
            byte by;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Object byteArray = null;
            byteArray = buffer;
            byte it = by = ArraysKt.first((byte[])byteArray);
            boolean bl = false;
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
            byte numRequiredSignatures = by;
            byte it2 = it = ArraysKt.first((byte[])byteArray);
            boolean bl2 = false;
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
            byte numReadonlySignedAccounts = it;
            byte it3 = it2 = ArraysKt.first((byte[])byteArray);
            boolean bl3 = false;
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
            byte numReadonlyUnsignedAccounts = it2;
            Pair<Integer, byte[]> accountCount = Shortvec.INSTANCE.decodeLength((byte[])byteArray);
            byteArray = accountCount.getSecond();
            List accountKeys = new ArrayList();
            int n = ((Number)accountCount.getFirst()).intValue();
            for (int i = 0; i < n; ++i) {
                List account = ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)32));
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)32));
                accountKeys.add(Base58Kt.encodeToBase58String((byte[])CollectionsKt.toByteArray((Collection)account)));
            }
            byte[] recentBlockhash = CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)32)));
            byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)32));
            Pair<Integer, byte[]> instructionCount = Shortvec.INSTANCE.decodeLength((byte[])byteArray);
            byteArray = instructionCount.getSecond();
            List instructions = new ArrayList();
            int n2 = ((Number)instructionCount.getFirst()).intValue();
            for (int i = 0; i < n2; ++i) {
                void $this$mapTo$iv$iv2;
                byte by2;
                byte it4 = by2 = ArraysKt.first((byte[])byteArray);
                boolean bl4 = false;
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)1));
                byte programIdIndex = by2;
                Pair<Integer, byte[]> accountCount2 = Shortvec.INSTANCE.decodeLength((byte[])byteArray);
                byteArray = accountCount2.getSecond();
                Iterable $this$map$iv2 = ArraysKt.toList((byte[])CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)((Number)accountCount2.getFirst()).intValue()))));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void p0;
                    byte by3 = ((Number)item$iv$iv).byteValue();
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add((int)p0);
                }
                List accounts = (List)destination$iv$iv;
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)((Number)accountCount2.getFirst()).intValue()));
                Pair<Integer, byte[]> dataLength = Shortvec.INSTANCE.decodeLength((byte[])byteArray);
                byteArray = dataLength.getSecond();
                byte[] dataSlice = CollectionsKt.toByteArray((Collection)ArraysKt.slice((byte[])byteArray, (IntRange)RangesKt.until((int)0, (int)((Number)dataLength.getFirst()).intValue())));
                data = Base58Kt.encodeToBase58String((byte[])dataSlice);
                byteArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])byteArray, (int)((Number)dataLength.getFirst()).intValue()));
                instructions.add(new CompiledInstruction(programIdIndex, accounts, data));
            }
            Object i = new MessageHeader(0, 0, 0, 7, null);
            MessageHeader $this$from_u24lambda_u244 = i;
            boolean $i$a$-apply-SolanaMessage$Companion$from$22 = false;
            $this$from_u24lambda_u244.setNumRequiredSignatures(numRequiredSignatures);
            $this$from_u24lambda_u244.setNumReadonlySignedAccounts(numReadonlySignedAccounts);
            $this$from_u24lambda_u244.setNumReadonlyUnsignedAccounts(numReadonlyUnsignedAccounts);
            MessageHeader messageHeader = i;
            i = accountKeys;
            MessageHeader messageHeader2 = messageHeader;
            boolean $i$f$map = false;
            void $i$a$-apply-SolanaMessage$Companion$from$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                data = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(new PublicKey((String)it5));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 48;
            Map map = null;
            PublicKey publicKey = null;
            List list = instructions;
            String string = new String() + Base58Kt.encodeToBase58String((byte[])recentBlockhash);
            List list2 = (List)destination$iv$iv;
            MessageHeader messageHeader3 = messageHeader2;
            return new SolanaMessage(messageHeader3, list2, string, list, publicKey, map, n3, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

