/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.NameLookup;
import org.apache.hivemind.lib.RemoteExceptionCoordinator;
import org.apache.hivemind.lib.impl.EJBProxyParameters;
import org.apache.hivemind.lib.impl.ImplMessages;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodIterator;
import org.apache.hivemind.service.MethodSignature;

public class EJBProxyFactory
extends BaseLocatable
implements ServiceImplementationFactory {
    private NameLookup _nameLookup;
    private RemoteExceptionCoordinator _coordinator;
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$org$apache$hivemind$lib$impl$AbstractEJBProxy;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$apache$hivemind$lib$NameLookup;
    static /* synthetic */ Class class$org$apache$hivemind$lib$RemoteExceptionCoordinator;

    public Object createCoreServiceImplementation(String serviceId, Class serviceInterface, Log serviceLog, Module invokingModule, List parameters) {
        EJBProxyParameters proxyParameters = (EJBProxyParameters)parameters.get(0);
        String jndiName = proxyParameters.getJndiName();
        String homeInterfaceClassName = proxyParameters.getHomeInterfaceClassName();
        Class homeInterface = invokingModule.getClassResolver().findClass(homeInterfaceClassName);
        String proxyClassName = ClassFabUtils.generateClassName((String)"EJBProxy");
        ClassFab classFab = this._classFactory.newClass(proxyClassName, class$org$apache$hivemind$lib$impl$AbstractEJBProxy == null ? (class$org$apache$hivemind$lib$impl$AbstractEJBProxy = EJBProxyFactory.class$("org.apache.hivemind.lib.impl.AbstractEJBProxy")) : class$org$apache$hivemind$lib$impl$AbstractEJBProxy, invokingModule.getClassResolver().getClassLoader());
        classFab.addInterface(serviceInterface);
        classFab.addField("_remote", serviceInterface);
        this.addClearCachedMethod(classFab);
        this.addLookupMethod(classFab, homeInterface, serviceInterface, jndiName);
        this.addServiceMethods(classFab, serviceInterface, serviceId, jndiName);
        this.addConstructor(classFab);
        Class proxyClass = classFab.createClass();
        return this.invokeConstructor(proxyClass, proxyParameters.getNameLookup(this._nameLookup));
    }

    private void addClearCachedMethod(ClassFab classFab) {
        classFab.addMethod(4, new MethodSignature(Void.TYPE, "_clearCachedReferences", null, null), "_remote = null;");
    }

    private void addLookupMethod(ClassFab classFab, Class homeInterface, Class remoteInterface, String jndiName) {
        String homeInterfaceName = homeInterface.getName();
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (_remote != null)");
        builder.addln("  return _remote;");
        builder.add(homeInterfaceName);
        builder.add(" home = (");
        builder.add(homeInterfaceName);
        builder.add(") _lookup(");
        builder.addQuoted(jndiName);
        builder.addln(");");
        builder.add("try");
        builder.begin();
        builder.add("_remote = home.create();");
        builder.end();
        builder.add("catch (javax.ejb.CreateException ex)");
        builder.begin();
        builder.add("throw new java.rmi.RemoteException(ex.getMessage(), ex);");
        builder.end();
        builder.add("return _remote;");
        builder.end();
        classFab.addMethod(34, new MethodSignature(remoteInterface, "_lookupRemote", null, new Class[]{class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = EJBProxyFactory.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException}), builder.toString());
    }

    private void addServiceMethods(ClassFab classFab, Class serviceInterface, String serviceId, String jndiName) {
        MethodIterator mi = new MethodIterator(serviceInterface);
        while (mi.hasNext()) {
            this.addServiceMethod(classFab, mi.next());
        }
        if (!mi.getToString()) {
            this.addToStringMethod(classFab, serviceInterface, serviceId, jndiName);
        }
    }

    private void addServiceMethod(ClassFab classFab, MethodSignature sig) {
        String methodName = sig.getName();
        boolean isVoid = sig.getReturnType().equals(Void.TYPE);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("boolean first = true;");
        builder.add("while (true)");
        builder.begin();
        builder.add("try");
        builder.begin();
        if (!isVoid) {
            builder.add("return ");
        }
        builder.add("_lookupRemote().");
        builder.add(methodName);
        builder.addln("($$);");
        if (isVoid) {
            builder.addln("return;");
        }
        builder.end();
        builder.add("catch (java.rmi.RemoteException ex)");
        builder.begin();
        builder.addln("if (first)");
        builder.begin();
        builder.addln("_handleRemoteException(ex);");
        builder.addln("first = false;");
        builder.end();
        builder.addln("else");
        builder.add("  throw ex;");
        builder.end();
        builder.end();
        builder.end();
        classFab.addMethod(1, sig, builder.toString());
    }

    private void addToStringMethod(ClassFab classFab, Class serviceInterface, String serviceId, String jndiName) {
        ClassFabUtils.addToStringMethod((ClassFab)classFab, (String)ImplMessages.ejbProxyDescription(serviceId, serviceInterface, jndiName));
    }

    private void addConstructor(ClassFab classFab) {
        classFab.addConstructor(new Class[]{class$org$apache$hivemind$lib$NameLookup == null ? (class$org$apache$hivemind$lib$NameLookup = EJBProxyFactory.class$("org.apache.hivemind.lib.NameLookup")) : class$org$apache$hivemind$lib$NameLookup, class$org$apache$hivemind$lib$RemoteExceptionCoordinator == null ? (class$org$apache$hivemind$lib$RemoteExceptionCoordinator = EJBProxyFactory.class$("org.apache.hivemind.lib.RemoteExceptionCoordinator")) : class$org$apache$hivemind$lib$RemoteExceptionCoordinator}, null, "super($1, $2);");
    }

    private Object invokeConstructor(Class proxyClass, NameLookup nameLookup) {
        try {
            Constructor c = proxyClass.getConstructor(class$org$apache$hivemind$lib$NameLookup == null ? (class$org$apache$hivemind$lib$NameLookup = EJBProxyFactory.class$("org.apache.hivemind.lib.NameLookup")) : class$org$apache$hivemind$lib$NameLookup, class$org$apache$hivemind$lib$RemoteExceptionCoordinator == null ? (class$org$apache$hivemind$lib$RemoteExceptionCoordinator = EJBProxyFactory.class$("org.apache.hivemind.lib.RemoteExceptionCoordinator")) : class$org$apache$hivemind$lib$RemoteExceptionCoordinator);
            return c.newInstance(nameLookup, this._coordinator);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
    }

    public void setClassFactory(ClassFactory factory) {
        this._classFactory = factory;
    }

    public void setCoordinator(RemoteExceptionCoordinator coordinator) {
        this._coordinator = coordinator;
    }

    public void setNameLookup(NameLookup lookup) {
        this._nameLookup = lookup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

