/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.pipeline;

import org.apache.hivemind.service.MethodSignature;

class FilterMethodAnalyzer {
    private Class _serviceInterface;

    FilterMethodAnalyzer(Class serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    public int findServiceInterfacePosition(MethodSignature ms, MethodSignature fms) {
        Class[] serviceParameters;
        if (ms.getReturnType() != fms.getReturnType()) {
            return -1;
        }
        if (!ms.getName().equals(fms.getName())) {
            return -1;
        }
        Class[] filterParameters = fms.getParameterTypes();
        int filterParameterCount = filterParameters.length;
        if (filterParameterCount != (serviceParameters = ms.getParameterTypes()).length + 1) {
            return -1;
        }
        boolean found = false;
        int result = -1;
        int i = 0;
        while (i < filterParameterCount) {
            if (filterParameters[i] == this._serviceInterface) {
                result = i;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            return -1;
        }
        int i2 = 0;
        while (i2 < result) {
            if (filterParameters[i2] != serviceParameters[i2]) {
                return -1;
            }
            ++i2;
        }
        int i3 = result + 1;
        while (i3 < filterParameterCount) {
            if (filterParameters[i3] != serviceParameters[i3 - 1]) {
                return -1;
            }
            ++i3;
        }
        return result;
    }
}

