/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp;

import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class Address
implements Serializable {
    static final long serialVersionUID = -1899181032052084902L;
    private int ton = 0;
    private int npi = 0;
    private String address = "";

    public Address() {
    }

    public Address(int n, int n2, String string) {
        this.ton = n;
        this.npi = n2;
        this.address = string;
    }

    public int getTON() {
        return this.ton;
    }

    public void setTON(int n) {
        this.ton = n;
    }

    public int getNPI() {
        return this.npi;
    }

    public void setNPI(int n) {
        this.npi = n;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string != null ? string : "";
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toString(this.ton)).append(':');
        stringBuffer.append(Integer.toString(this.npi)).append(':');
        if (this.address != null) {
            stringBuffer.append(this.address);
        }
        return stringBuffer.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Address) {
            Address address = (Address)object;
            return address.ton == this.ton && address.npi == this.npi && address.address.equals(this.address);
        }
        return false;
    }

    public int getLength() {
        return 3 + this.address.length();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        SMPPIO.writeInt(this.ton, 1, outputStream);
        SMPPIO.writeInt(this.npi, 1, outputStream);
        SMPPIO.writeCString(this.address, outputStream);
    }

    public void readFrom(byte[] byArray, int n) {
        this.ton = SMPPIO.bytesToInt(byArray, n++, 1);
        this.npi = SMPPIO.bytesToInt(byArray, n++, 1);
        this.address = SMPPIO.readCString(byArray, n);
    }

    public String toString() {
        return new StringBuffer(25).append(Integer.toString(this.ton)).append(':').append(Integer.toString(this.npi)).append(':').append(this.address).toString();
    }
}

