/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp;

import ie.omk.smpp.AlreadyBoundException;
import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.InvalidOperationException;
import ie.omk.smpp.NotBoundException;
import ie.omk.smpp.SMPPException;
import ie.omk.smpp.SMPPRuntimeException;
import ie.omk.smpp.UnsupportedOperationException;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.EventDispatcher;
import ie.omk.smpp.event.ReceiverExceptionEvent;
import ie.omk.smpp.event.ReceiverExitEvent;
import ie.omk.smpp.event.ReceiverStartEvent;
import ie.omk.smpp.event.SimpleEventDispatcher;
import ie.omk.smpp.message.Bind;
import ie.omk.smpp.message.BindResp;
import ie.omk.smpp.message.DeliverSM;
import ie.omk.smpp.message.DeliverSMResp;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.EnquireLinkResp;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.message.Unbind;
import ie.omk.smpp.message.UnbindResp;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.net.SmscLink;
import ie.omk.smpp.net.TcpLink;
import ie.omk.smpp.util.APIConfig;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.DefaultSequenceScheme;
import ie.omk.smpp.util.PacketFactory;
import ie.omk.smpp.util.PropertyNotFoundException;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.util.SequenceNumberScheme;
import ie.omk.smpp.version.SMPPVersion;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connection
implements Runnable {
    public static final int TRANSMITTER = 1;
    public static final int RECEIVER = 2;
    public static final int TRANSCEIVER = 3;
    public static final int UNBOUND = 0;
    public static final int BINDING = 1;
    public static final int BOUND = 2;
    public static final int UNBINDING = 3;
    private static final Log LOGGER = LogFactory.getLog((Class)Connection.class);
    private int connectionType;
    private Thread rcvThread;
    private List packetQueue;
    private EventDispatcher eventDispatcher;
    private byte[] buf = new byte[300];
    private SequenceNumberScheme seqNumScheme = new DefaultSequenceScheme();
    private SmscLink link;
    protected SMPPVersion interfaceVersion = SMPPVersion.getDefaultVersion();
    protected boolean supportOptionalParams = true;
    private transient int state = 0;
    protected boolean ackQryLinks = true;
    protected boolean ackDeliverSm;
    protected boolean asyncComms;
    protected AlphabetEncoding defaultAlphabet;

    public Connection(String string, int n) throws UnknownHostException {
        this(new TcpLink(string, n), false);
    }

    public Connection(String string, int n, boolean bl) throws UnknownHostException {
        this(new TcpLink(string, n), bl);
    }

    public Connection(SmscLink smscLink) {
        this(smscLink, false);
    }

    public Connection(SmscLink smscLink, boolean bl) {
        this.link = smscLink;
        this.asyncComms = bl;
        if (this.asyncComms) {
            this.initAsyncComms();
        } else {
            this.initSyncComms();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAsyncComms() {
        String string = "";
        try {
            string = APIConfig.getInstance().getProperty("smppapi.event.dispatcher");
            if (string != null && !"".equals(string)) {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.eventDispatcher = (EventDispatcher)constructor.newInstance(new Object[0]);
            } else {
                LOGGER.info((Object)"EventDispatcher property value is empty.");
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            LOGGER.debug((Object)"No event dispatcher specified in properties. Using default.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error((Object)("Cannot locate event dispatcher class " + string), (Throwable)classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            LOGGER.error((Object)(string + " does not implement the EventDispatcher interface."), (Throwable)classCastException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.error((Object)(string + " does not have a no-argument constructor."));
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.error((Object)(string + " constructor is not visible."), (Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)"Internal error in the SMPPAPI. Please inform the maintainer.", (Throwable)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.error((Object)("Could not instantiate an instance of " + string), (Throwable)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.error((Object)(string + " constructor threw an exception."), (Throwable)invocationTargetException);
        }
        finally {
            if (this.eventDispatcher == null) {
                this.eventDispatcher = new SimpleEventDispatcher();
            }
        }
        LOGGER.info((Object)("Using event dispatcher " + this.eventDispatcher.getClass().getName()));
        this.eventDispatcher.init();
        this.createRecvThread();
    }

    private void initSyncComms() {
        this.packetQueue = new ArrayList();
    }

    private void createRecvThread() {
        LOGGER.info((Object)"Creating receiver thread");
        this.rcvThread = new Thread((Runnable)this, "ReceiverDaemon");
        this.rcvThread.setDaemon(true);
    }

    public void setDefaultAlphabet(AlphabetEncoding alphabetEncoding) {
        this.defaultAlphabet = alphabetEncoding;
    }

    public AlphabetEncoding getDefaultAlphabet() {
        return this.defaultAlphabet;
    }

    private void setState(int n) {
        LOGGER.info((Object)("Setting state " + n));
        this.state = n;
    }

    public void setVersion(SMPPVersion sMPPVersion) throws VersionException {
        if (this.getState() != 0) {
            throw new VersionException("Cannot set SMPP version after binding");
        }
        this.interfaceVersion = sMPPVersion == null ? SMPPVersion.getDefaultVersion() : sMPPVersion;
    }

    public SMPPVersion getVersion() {
        return this.interfaceVersion;
    }

    public int getState() {
        return this.state;
    }

    protected void openLink() throws IOException {
        if (!this.link.isConnected()) {
            LOGGER.info((Object)"Opening network link.");
            this.link.open();
            if (this.seqNumScheme != null) {
                this.seqNumScheme.reset();
            }
        } else {
            LOGGER.debug((Object)"openLink called, link already open");
        }
    }

    public void closeLink() throws IOException {
        if (this.getState() != 0) {
            throw new IllegalStateException("Cannot close the link while bound to the SMSC");
        }
        if (this.link.isConnected()) {
            LOGGER.info((Object)"Shutting down the network link");
            this.link.close();
        } else {
            LOGGER.debug((Object)"closeLink called on an unopen connection");
        }
    }

    public SMPPVersion getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public void setInterfaceVersion(SMPPVersion sMPPVersion) {
        LOGGER.info((Object)("setInterfaceVersion " + sMPPVersion));
        this.interfaceVersion = sMPPVersion;
        this.supportOptionalParams = sMPPVersion.isSupportOptionalParams();
    }

    public void autoAckLink(boolean bl) {
        this.ackQryLinks = bl;
    }

    public void autoAckMessages(boolean bl) {
        this.ackDeliverSm = bl;
    }

    public boolean isAckingLinks() {
        return this.ackQryLinks;
    }

    public boolean isAckingMessages() {
        return this.ackDeliverSm;
    }

    public void ackDeliverSm(DeliverSM deliverSM) throws IOException {
        DeliverSMResp deliverSMResp = new DeliverSMResp(deliverSM);
        this.sendResponse(deliverSMResp);
        LOGGER.info((Object)"deliver_sm_resp sent.");
    }

    public SMPPResponse sendRequest(SMPPRequest sMPPRequest) throws SocketTimeoutException, IOException, AlreadyBoundException, VersionException, SMPPProtocolException, UnsupportedOperationException {
        int n = sMPPRequest.getCommandId();
        if (this.state != 2) {
            throw new NotBoundException("Must be bound to the SMSC before sending packets");
        }
        if (n == 1 || n == 9 || n == 2 || n == 6) {
            throw new UnsupportedOperationException("You must use the bind and unbind methods to send those requests");
        }
        if (this.connectionType == 2 && n != 21) {
            throw new UnsupportedOperationException("Operation not permitted over receiver connection");
        }
        return this.sendRequestInternal(sMPPRequest);
    }

    protected SMPPResponse sendRequestInternal(SMPPRequest sMPPRequest) throws SocketTimeoutException, IOException, AlreadyBoundException, VersionException, SMPPProtocolException {
        SMPPResponse sMPPResponse = null;
        if (this.link == null) {
            throw new IOException("No SMSC connection.");
        }
        this.processOutboundPacket(sMPPRequest);
        this.link.write(sMPPRequest, this.supportOptionalParams);
        if (!this.asyncComms) {
            sMPPResponse = this.waitForResponsePacket(sMPPRequest);
        }
        return sMPPResponse;
    }

    protected SMPPResponse waitForResponsePacket(SMPPPacket sMPPPacket) throws SocketTimeoutException, IOException, SMPPProtocolException {
        try {
            SMPPPacket sMPPPacket2 = null;
            int n = sMPPPacket.getSequenceNum();
            while ((sMPPPacket2 = this.readNextPacketInternal()).isRequest() || sMPPPacket2.getSequenceNum() != n) {
                LOGGER.info((Object)"Queuing unexpected sequence numbered packet.");
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Expected:").append(n).append(" but got ").append(sMPPPacket2.getSequenceNum()).append(" type: ").append(sMPPPacket2.getCommandId());
                    LOGGER.debug((Object)stringBuffer.toString());
                }
                this.packetQueue.add(sMPPPacket2);
            }
            return (SMPPResponse)sMPPPacket2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            LOGGER.error((Object)"Received a socket timeout exception", (Throwable)socketTimeoutException);
            throw socketTimeoutException;
        }
    }

    public int packetAvailable() {
        int n = 0;
        if (!this.asyncComms) {
            if (this.packetQueue.size() > 0) {
                n = 2;
            } else if (this.link.available() > 0) {
                n = 1;
            }
        }
        return n;
    }

    public void sendResponse(SMPPResponse sMPPResponse) throws IOException {
        if (this.link == null) {
            throw new IOException("Connection to SMSC is not valid.");
        }
        try {
            this.link.write(sMPPResponse, this.supportOptionalParams);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            LOGGER.warn((Object)"Got a socket timeout exception", (Throwable)socketTimeoutException);
            this.setState(0);
            throw socketTimeoutException;
        }
        this.processOutboundPacket(sMPPResponse);
    }

    public BindResp bind(int n, String string, String string2, String string3) throws IOException, InvalidParameterValueException, IllegalArgumentException, AlreadyBoundException, VersionException, SMPPProtocolException {
        return this.bind(n, string, string2, string3, 0, 0, null);
    }

    public BindResp bind(int n, String string, String string2, String string3, int n2, int n3, String string4) throws IOException, InvalidParameterValueException, IllegalArgumentException, AlreadyBoundException, VersionException, SMPPProtocolException {
        Bind bind = null;
        try {
            switch (n) {
                case 1: {
                    bind = (Bind)this.newInstance(2);
                    break;
                }
                case 2: {
                    bind = (Bind)this.newInstance(1);
                    break;
                }
                case 3: {
                    if (this.interfaceVersion.isOlder(SMPPVersion.V34)) {
                        throw new VersionException("Cannot bind as transceiver in " + this.interfaceVersion.toString());
                    }
                    bind = (Bind)this.newInstance(9);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such connection type.");
                }
            }
        }
        catch (BadCommandIDException badCommandIDException) {
            LOGGER.error((Object)"Internal error in the smppapi. Please inform the maintainer.", (Throwable)badCommandIDException);
        }
        this.connectionType = n;
        LOGGER.info((Object)("Binding to the SMSC as type " + n));
        bind.setVersion(this.interfaceVersion);
        bind.setSystemId(string);
        bind.setPassword(string2);
        bind.setSystemType(string3);
        bind.setAddressTon(n2);
        bind.setAddressNpi(n3);
        bind.setAddressRange(string4);
        return (BindResp)this.sendRequestInternal(bind);
    }

    public UnbindResp unbind() throws IOException, NotBoundException, SMPPProtocolException {
        if (this.state != 2 || !this.link.isConnected()) {
            throw new NotBoundException();
        }
        try {
            LOGGER.info((Object)"Unbinding from the SMSC");
            Unbind unbind = (Unbind)this.newInstance(6);
            return (UnbindResp)this.sendRequestInternal(unbind);
        }
        catch (BadCommandIDException badCommandIDException) {
            throw new SMPPRuntimeException("Internal smppapi error");
        }
    }

    public void unbind(UnbindResp unbindResp) throws IOException, SMPPException {
        if (this.state != 3) {
            throw new NotBoundException("Link is not connected.");
        }
        if (!this.link.isConnected()) {
            throw new AlreadyBoundException("No unbind request received.");
        }
        this.sendResponse(unbindResp);
    }

    public void force_unbind() {
        LOGGER.warn((Object)"Attempting to force SMPP connection down.");
        try {
            this.setState(0);
            Thread.yield();
            if (this.rcvThread != null && this.rcvThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.debug((Object)"Interrupted exception waiting on receiver to die", (Throwable)interruptedException);
                }
                if (this.rcvThread != null) {
                    LOGGER.error((Object)"Listener thread has not died.");
                }
                this.rcvThread = null;
            }
            this.link.close();
        }
        catch (Throwable throwable) {
            LOGGER.warn((Object)"Exception when trying to force unbind", throwable);
        }
    }

    public void ackEnquireLink(EnquireLink enquireLink) throws IOException {
        EnquireLinkResp enquireLinkResp = new EnquireLinkResp(enquireLink);
        this.sendResponse(enquireLinkResp);
        LOGGER.info((Object)"enquire_link_resp sent.");
    }

    public EnquireLinkResp enquireLink() throws IOException, SMPPProtocolException {
        try {
            EnquireLink enquireLink = (EnquireLink)this.newInstance(21);
            SMPPResponse sMPPResponse = this.sendRequest(enquireLink);
            LOGGER.debug((Object)"enquire_link request sent.");
            if (sMPPResponse != null) {
                LOGGER.debug((Object)"enquire_link_response received.");
            }
            return (EnquireLinkResp)sMPPResponse;
        }
        catch (BadCommandIDException badCommandIDException) {
            throw new SMPPRuntimeException("Internal smppapi error");
        }
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public boolean isBound() {
        return this.state == 2;
    }

    public void reset() throws AlreadyBoundException {
        if (this.state == 2) {
            LOGGER.warn((Object)"Attempt to reset sequence numbering on a bound connection");
            throw new AlreadyBoundException("Cannot reset connection while bound");
        }
        if (this.seqNumScheme != null) {
            this.seqNumScheme.reset();
        }
        LOGGER.info((Object)"Sequence numbering reset.");
    }

    public void setSeqNumScheme(SequenceNumberScheme sequenceNumberScheme) {
        this.seqNumScheme = sequenceNumberScheme;
    }

    public SequenceNumberScheme getSeqNumScheme() {
        return this.seqNumScheme;
    }

    public SMPPPacket readNextPacket() throws IOException, InvalidOperationException, SMPPProtocolException {
        if (this.asyncComms) {
            throw new InvalidOperationException("Asynchronous comms in use.");
        }
        if (this.packetQueue.size() > 0) {
            return (SMPPPacket)this.packetQueue.remove(0);
        }
        return this.readNextPacketInternal();
    }

    private SMPPPacket readNextPacketInternal() throws IOException, SMPPProtocolException {
        try {
            SMPPPacket sMPPPacket = null;
            int n = -1;
            this.buf = this.link.read(this.buf);
            n = SMPPIO.bytesToInt(this.buf, 4, 4);
            sMPPPacket = PacketFactory.newInstance(n);
            if (sMPPPacket != null) {
                sMPPPacket.readFrom(this.buf, 0);
                if (LOGGER.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Packet Received: ");
                    int n2 = sMPPPacket.getLength();
                    int n3 = sMPPPacket.getCommandStatus();
                    int n4 = sMPPPacket.getSequenceNum();
                    stringBuffer.append("id:").append(Integer.toHexString(n)).append(" len:").append(Integer.toString(n2)).append(" st:").append(Integer.toString(n3)).append(" sq:").append(Integer.toString(n4));
                    LOGGER.debug((Object)stringBuffer.toString());
                }
                this.processInboundPacket(sMPPPacket);
            }
            return sMPPPacket;
        }
        catch (BadCommandIDException badCommandIDException) {
            throw new SMPPProtocolException("Unrecognised command received", badCommandIDException);
        }
    }

    private void processOutboundPacket(SMPPPacket sMPPPacket) throws IOException {
        int n = sMPPPacket.getCommandId();
        if (!this.interfaceVersion.isSupported(n)) {
            StringBuffer stringBuffer = new StringBuffer(120).append(this.interfaceVersion.toString()).append(" does not support command ID 0x").append(Integer.toHexString(n));
            throw new VersionException(stringBuffer.toString());
        }
        switch (n) {
            case 1: 
            case 2: 
            case 9: {
                this.processOutboundBind((Bind)sMPPPacket);
                break;
            }
            case 6: {
                this.processOutboundUnbind((Unbind)sMPPPacket);
                break;
            }
            case -2147483642: {
                this.processOutboundUnbindResp((UnbindResp)sMPPPacket);
            }
        }
    }

    private void processOutboundBind(Bind bind) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("Cannot bind while in state " + this.state);
        }
        try {
            int n = APIConfig.getInstance().getInt("smppapi.connection.bind_timeout", 0);
            if (n > 0) {
                this.link.setTimeout(n);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Set bind timeout to " + n));
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.warn((Object)"Link does not support read timeouts - bind timeout will not work");
        }
        this.openLink();
        this.setState(1);
        if (this.asyncComms) {
            if (this.rcvThread == null) {
                this.createRecvThread();
            }
            if (!this.rcvThread.isAlive()) {
                this.rcvThread.start();
            }
        }
    }

    private void processOutboundUnbind(Unbind unbind) {
        if (!this.asyncComms && this.packetQueue.size() > 0) {
            throw new IllegalStateException("Cannot unbind while there are incoming packets awaiting responses");
        }
        if (this.state != 2) {
            throw new IllegalStateException("Not currently bound");
        }
        this.setState(3);
    }

    private void processOutboundUnbindResp(UnbindResp unbindResp) {
        if (unbindResp.getCommandStatus() == 0) {
            this.setState(0);
        }
    }

    private void processInboundPacket(SMPPPacket sMPPPacket) throws IOException {
        switch (sMPPPacket.getCommandId()) {
            case -2147483647: 
            case -2147483646: 
            case -2147483639: {
                this.processInboundBindResp((BindResp)sMPPPacket);
                break;
            }
            case -2147483642: {
                this.processInboundUnbindResp((UnbindResp)sMPPPacket);
                break;
            }
            case 6: {
                this.processInboundUnbind((Unbind)sMPPPacket);
                break;
            }
            case 5: {
                if (!this.ackDeliverSm) break;
                this.ackDeliverSm((DeliverSM)sMPPPacket);
                break;
            }
            case 21: {
                if (!this.ackQryLinks) break;
                this.ackEnquireLink((EnquireLink)sMPPPacket);
            }
        }
        if (sMPPPacket.getCommandStatus() == 0 && this.defaultAlphabet != null && sMPPPacket.getDataCoding() == 0) {
            sMPPPacket.setAlphabet(this.defaultAlphabet);
        }
    }

    private void processInboundBindResp(BindResp bindResp) {
        int n = bindResp.getCommandStatus();
        if (this.state != 1) {
            throw new IllegalStateException("A bind response was received in bound state " + this.state);
        }
        if (n != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Bind failed. Setting state to unbound.");
            }
            try {
                this.setState(0);
                this.link.close();
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"I/O Exception shutting down link after failed bind.", (Throwable)iOException);
            }
            return;
        }
        this.setState(2);
        Number number = (Number)bindResp.getOptionalParameter(Tag.SC_INTERFACE_VERSION);
        if (number != null) {
            SMPPVersion sMPPVersion = SMPPVersion.getVersion(number.intValue());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("SMSC reports its supported SMPP version as " + sMPPVersion.toString()));
            }
            if (sMPPVersion.isOlder(this.interfaceVersion)) {
                LOGGER.info((Object)("Downgrading this connection's SMPP version to " + sMPPVersion.toString()));
                this.setInterfaceVersion(sMPPVersion);
            }
        } else {
            this.supportOptionalParams = false;
            LOGGER.warn((Object)"Disabling optional parameter support as no sc_interface_version parameter was received");
        }
        try {
            int n2 = APIConfig.getInstance().getInt("smppapi.net.link_timeout");
            this.link.setTimeout(n2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Set the link timeout to " + n2));
            }
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"No link timeout specified in configuration");
            }
        }
        catch (java.lang.UnsupportedOperationException unsupportedOperationException) {
            LOGGER.warn((Object)"Configuration specified a link timeout but the link implementation does not support it");
        }
    }

    private void processInboundUnbind(Unbind unbind) {
        LOGGER.info((Object)"SMSC requested unbind");
        this.setState(3);
    }

    private void processInboundUnbindResp(UnbindResp unbindResp) {
        try {
            if (this.state == 3 && unbindResp.getCommandStatus() == 0) {
                LOGGER.info((Object)"Successfully unbound");
                this.setState(0);
                this.link.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        if (eventDispatcher == null) {
            throw new NullPointerException("Event dispatcher cannot be null");
        }
        eventDispatcher.init();
        EventDispatcher eventDispatcher2 = this.eventDispatcher;
        synchronized (eventDispatcher2) {
            Iterator iterator = this.eventDispatcher.observerIterator();
            while (iterator.hasNext()) {
                eventDispatcher.addObserver((ConnectionObserver)iterator.next());
            }
        }
        eventDispatcher2 = this.eventDispatcher;
        this.eventDispatcher = eventDispatcher;
        eventDispatcher2.destroy();
    }

    public void addObserver(ConnectionObserver connectionObserver) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addObserver(connectionObserver);
        }
    }

    public void removeObserver(ConnectionObserver connectionObserver) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeObserver(connectionObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SMPPPacket sMPPPacket = null;
        int n = 0;
        ReceiverExitEvent receiverExitEvent = null;
        int n2 = 5;
        LOGGER.info((Object)"Receiver thread started");
        APIConfig aPIConfig = APIConfig.getInstance();
        try {
            n2 = aPIConfig.getInt("smppapi.connection.rcv_daemon.ioex_count");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            LOGGER.debug((Object)("Didn't find I/O exception config. Using default of " + n2));
        }
        this.eventDispatcher.notifyObservers(this, new ReceiverStartEvent(this));
        try {
            while (this.state != 0) {
                try {
                    sMPPPacket = this.readNextPacketInternal();
                    if (sMPPPacket == null) {
                        LOGGER.warn((Object)"Received an unidentified packet from the SMSC");
                        continue;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Caught a socket timeout exception: " + socketTimeoutException.getMessage()));
                    }
                    if (this.state == 1) {
                        LOGGER.debug((Object)"Bind timeout.");
                        receiverExitEvent = new ReceiverExitEvent(this, null, this.state);
                        receiverExitEvent.setReason(1);
                        this.setState(0);
                        continue;
                    }
                    this.eventDispatcher.notifyObservers(this, new ReceiverExceptionEvent(this, socketTimeoutException));
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)"I/O Exception caught", (Throwable)iOException);
                    ReceiverExceptionEvent receiverExceptionEvent = new ReceiverExceptionEvent(this, iOException, this.state);
                    this.eventDispatcher.notifyObservers(this, receiverExceptionEvent);
                    if (++n <= n2) continue;
                    LOGGER.warn((Object)"Too many IOExceptions in receiver thread", (Throwable)iOException);
                    throw iOException;
                }
                n = 0;
                LOGGER.info((Object)"Notifying observers of packet received");
                this.eventDispatcher.notifyObservers(this, sMPPPacket);
            }
            if (receiverExitEvent == null) {
                receiverExitEvent = new ReceiverExitEvent(this, null, this.state);
            }
        }
        catch (Exception exception) {
            LOGGER.debug((Object)("Fatal exception in receiver thread: " + exception.getMessage()), (Throwable)exception);
            receiverExitEvent = new ReceiverExitEvent(this, exception, this.state);
            this.setState(0);
        }
        finally {
            this.rcvThread = null;
        }
        if (receiverExitEvent != null) {
            this.eventDispatcher.notifyObservers(this, receiverExitEvent);
        }
        this.eventDispatcher.destroy();
    }

    public void ackLinkQuery(EnquireLink enquireLink) throws IOException {
        this.ackEnquireLink(enquireLink);
    }

    public SMPPPacket newInstance(int n) throws BadCommandIDException, VersionException {
        if (!this.interfaceVersion.isSupported(n)) {
            throw new VersionException("Command is not supported in this SMPP version");
        }
        SMPPPacket sMPPPacket = PacketFactory.newInstance(n);
        sMPPPacket.setVersion(this.interfaceVersion);
        if (this.seqNumScheme != null) {
            sMPPPacket.setSequenceNum(this.seqNumScheme.nextNumber());
        }
        if (this.defaultAlphabet != null) {
            sMPPPacket.setAlphabet(this.defaultAlphabet, 0);
        }
        return sMPPPacket;
    }
}

