/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.NotificationDetails;
import ie.omk.smpp.event.QueueFullException;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.SMPPPacket;

class FIFOQueue {
    private int head;
    private int tail;
    private NotificationDetails[] queue;

    public FIFOQueue(int n) {
        if (n < 1) {
            n = 100;
        }
        this.queue = new NotificationDetails[n];
        for (int i = 0; i < n; ++i) {
            this.queue[i] = new NotificationDetails();
        }
    }

    public void put(Connection connection, SMPPPacket sMPPPacket) throws QueueFullException {
        if (this.isFull()) {
            throw new QueueFullException();
        }
        this.queue[this.tail++].setDetails(connection, null, sMPPPacket);
        if (this.tail >= this.queue.length) {
            this.tail = 0;
        }
    }

    public void put(Connection connection, SMPPEvent sMPPEvent) throws QueueFullException {
        if (this.isFull()) {
            throw new QueueFullException();
        }
        this.queue[this.tail++].setDetails(connection, sMPPEvent, null);
        if (this.tail >= this.queue.length) {
            this.tail = 0;
        }
    }

    public NotificationDetails get() {
        NotificationDetails notificationDetails = null;
        if (!this.isEmpty()) {
            notificationDetails = this.queue[this.head++];
            if (this.head >= this.queue.length) {
                this.head = 0;
            }
        }
        return notificationDetails;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public boolean isFull() {
        if (this.tail > this.head) {
            return this.tail == this.queue.length - 1 && this.head == 0;
        }
        return this.tail == this.head - 1;
    }
}

