/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.ReceiverExceptionEvent;
import ie.omk.smpp.event.ReceiverExitEvent;
import ie.omk.smpp.event.ReceiverStartEvent;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.BindResp;
import ie.omk.smpp.message.CancelSMResp;
import ie.omk.smpp.message.DeliverSM;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.EnquireLinkResp;
import ie.omk.smpp.message.GenericNack;
import ie.omk.smpp.message.ParamRetrieveResp;
import ie.omk.smpp.message.ReplaceSMResp;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.message.SubmitMultiResp;
import ie.omk.smpp.message.SubmitSMResp;
import ie.omk.smpp.message.Unbind;
import ie.omk.smpp.message.UnbindResp;
import org.apache.commons.logging.LogFactory;

public abstract class SMPPEventAdapter
implements ConnectionObserver {
    public final void update(Connection connection, SMPPEvent sMPPEvent) {
        try {
            switch (sMPPEvent.getType()) {
                case 2: {
                    this.receiverStart(connection, (ReceiverStartEvent)sMPPEvent);
                    break;
                }
                case 3: {
                    ReceiverExitEvent receiverExitEvent = (ReceiverExitEvent)sMPPEvent;
                    if (receiverExitEvent.getReason() == 2) {
                        this.receiverExitException(connection, receiverExitEvent);
                        break;
                    }
                    this.receiverExit(connection, receiverExitEvent);
                    break;
                }
                case 4: {
                    this.receiverException(connection, (ReceiverExceptionEvent)sMPPEvent);
                    break;
                }
                default: {
                    this.userEvent(connection, sMPPEvent);
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            LogFactory.getLog((Class)SMPPEventAdapter.class).error((Object)"Class cast exception", (Throwable)classCastException);
        }
    }

    public final void packetReceived(Connection connection, SMPPPacket sMPPPacket) {
        switch (sMPPPacket.getCommandId()) {
            case 5: {
                this.deliverSM(connection, (DeliverSM)sMPPPacket);
                break;
            }
            case -2147483644: {
                this.submitSMResponse(connection, (SubmitSMResp)sMPPPacket);
                break;
            }
            case -2147483615: {
                this.submitMultiResponse(connection, (SubmitMultiResp)sMPPPacket);
                break;
            }
            case -2147483640: {
                this.cancelSMResponse(connection, (CancelSMResp)sMPPPacket);
                break;
            }
            case -2147483641: {
                this.replaceSMResponse(connection, (ReplaceSMResp)sMPPPacket);
                break;
            }
            case -2147483614: {
                this.paramRetrieveResponse(connection, (ParamRetrieveResp)sMPPPacket);
                break;
            }
            case -2147483645: 
            case -2147483613: 
            case -2147483612: {
                this.queryResponse(connection, (SMPPResponse)sMPPPacket);
                break;
            }
            case 21: {
                this.queryLink(connection, (EnquireLink)sMPPPacket);
                break;
            }
            case -2147483627: {
                this.queryLinkResponse(connection, (EnquireLinkResp)sMPPPacket);
                break;
            }
            case 6: {
                this.unbind(connection, (Unbind)sMPPPacket);
                break;
            }
            case -2147483642: {
                this.unbindResponse(connection, (UnbindResp)sMPPPacket);
                break;
            }
            case -2147483647: 
            case -2147483646: 
            case -2147483639: {
                this.bindResponse(connection, (BindResp)sMPPPacket);
                break;
            }
            case -2147483648: {
                this.genericNack(connection, (GenericNack)sMPPPacket);
                break;
            }
            default: {
                this.unidentified(connection, sMPPPacket);
            }
        }
    }

    public void receiverExit(Connection connection, ReceiverExitEvent receiverExitEvent) {
    }

    public void receiverExitException(Connection connection, ReceiverExitEvent receiverExitEvent) {
    }

    public void receiverException(Connection connection, ReceiverExceptionEvent receiverExceptionEvent) {
    }

    public void receiverStart(Connection connection, ReceiverStartEvent receiverStartEvent) {
    }

    public void userEvent(Connection connection, SMPPEvent sMPPEvent) {
    }

    public void deliverSM(Connection connection, DeliverSM deliverSM) {
    }

    public void submitSMResponse(Connection connection, SubmitSMResp submitSMResp) {
    }

    public void submitMultiResponse(Connection connection, SubmitMultiResp submitMultiResp) {
    }

    public void cancelSMResponse(Connection connection, CancelSMResp cancelSMResp) {
    }

    public void replaceSMResponse(Connection connection, ReplaceSMResp replaceSMResp) {
    }

    public void paramRetrieveResponse(Connection connection, ParamRetrieveResp paramRetrieveResp) {
    }

    public void queryResponse(Connection connection, SMPPResponse sMPPResponse) {
    }

    public void queryLink(Connection connection, EnquireLink enquireLink) {
    }

    public void queryLinkResponse(Connection connection, EnquireLinkResp enquireLinkResp) {
    }

    public void unbind(Connection connection, Unbind unbind) {
    }

    public void unbindResponse(Connection connection, UnbindResp unbindResp) {
    }

    public void bindResponse(Connection connection, BindResp bindResp) {
    }

    public void genericNack(Connection connection, GenericNack genericNack) {
    }

    public void unidentified(Connection connection, SMPPPacket sMPPPacket) {
    }
}

