/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.EventDispatcher;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.SMPPPacket;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleEventDispatcher
implements EventDispatcher {
    public static final int INCREMENT = 3;
    private static final Log LOGGER;
    private ConnectionObserver[] observers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SimpleEventDispatcher() {
        this.observers = new ConnectionObserver[3];
    }

    public SimpleEventDispatcher(ConnectionObserver connectionObserver) {
        this.observers = new ConnectionObserver[1];
        this.addObserver(connectionObserver);
    }

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ConnectionObserver connectionObserver) {
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            if (this.indexOf(connectionObserver) < 0) {
                int n = this.findSlot();
                if (n < 0) {
                    this.growArray(connectionObserver);
                } else {
                    this.observers[n] = connectionObserver;
                }
            } else {
                LOGGER.info((Object)"Not adding observer because it's already registered");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ConnectionObserver connectionObserver) {
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            int n = this.indexOf(connectionObserver);
            if (n > -1) {
                this.observers[n] = null;
            } else {
                LOGGER.info((Object)"Cannot remove an observer that was not added");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator observerIterator() {
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            ArrayList<ConnectionObserver> arrayList = new ArrayList<ConnectionObserver>(this.observers.length);
            for (int i = 0; i < this.observers.length; ++i) {
                if (this.observers[i] == null) continue;
                arrayList.add(this.observers[i]);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return arrayList.iterator();
        }
    }

    public boolean contains(ConnectionObserver connectionObserver) {
        return this.indexOf(connectionObserver) > -1;
    }

    public void notifyObservers(Connection connection, SMPPEvent sMPPEvent) {
        for (int i = 0; i < this.observers.length; ++i) {
            ConnectionObserver connectionObserver = this.observers[i];
            if (connectionObserver == null) continue;
            try {
                connectionObserver.update(connection, sMPPEvent);
                continue;
            }
            catch (Throwable throwable) {
                LOGGER.warn((Object)"An observer threw an exception during event processing", throwable);
            }
        }
    }

    public void notifyObservers(Connection connection, SMPPPacket sMPPPacket) {
        for (int i = 0; i < this.observers.length; ++i) {
            ConnectionObserver connectionObserver = this.observers[i];
            if (connectionObserver == null) continue;
            try {
                connectionObserver.packetReceived(connection, sMPPPacket);
                continue;
            }
            catch (Throwable throwable) {
                LOGGER.warn((Object)"An observer threw an exception during packet processing", throwable);
            }
        }
    }

    public int capacity() {
        return this.observers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            for (int i = 0; i < this.observers.length; ++i) {
                if (this.observers[i] == null) continue;
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    void growArray(ConnectionObserver connectionObserver) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.observers)) {
            throw new AssertionError();
        }
        ConnectionObserver[] connectionObserverArray = new ConnectionObserver[this.observers.length + 3];
        System.arraycopy(this.observers, 0, connectionObserverArray, 0, this.observers.length);
        connectionObserverArray[this.observers.length] = connectionObserver;
        this.observers = connectionObserverArray;
    }

    private int findSlot() {
        int n;
        if (!$assertionsDisabled && !Thread.holdsLock(this.observers)) {
            throw new AssertionError();
        }
        for (n = 0; n < this.observers.length && this.observers[n] != null; ++n) {
        }
        if (n == this.observers.length) {
            n = -1;
        }
        return n;
    }

    private int indexOf(ConnectionObserver connectionObserver) {
        for (int i = this.observers.length - 1; i >= 0; --i) {
            if (this.observers[i] != connectionObserver) continue;
            return i;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !SimpleEventDispatcher.class.desiredAssertionStatus();
        LOGGER = LogFactory.getLog((Class)SimpleEventDispatcher.class);
    }
}

