/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.EventDispatcher;
import ie.omk.smpp.event.FIFOQueue;
import ie.omk.smpp.event.NotificationDetails;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.util.APIConfig;
import ie.omk.smpp.util.PropertyNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadedEventDispatcher
implements EventDispatcher,
Runnable {
    private static final Log LOGGER = LogFactory.getLog((Class)ThreadedEventDispatcher.class);
    private boolean running = true;
    private int poolSize;
    private ThreadGroup threadPool = new ThreadGroup("DispatcherPool");
    private FIFOQueue queue;
    private int threadsWaiting;
    private List observers = new ArrayList();

    public void init() {
        int n;
        try {
            APIConfig aPIConfig = APIConfig.getInstance();
            this.poolSize = aPIConfig.getInt("smppapi.event.threaded_dispatcher.pool_size");
            n = aPIConfig.getInt("smppapi.event.threaded_dispatcher.queue_size");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this.poolSize = 3;
            n = 100;
        }
        this.queue = new FIFOQueue(n);
        this.initialiseThreadPool();
    }

    private void initialiseThreadPool() {
        for (int i = 0; i < this.poolSize; ++i) {
            Thread thread = new Thread(this.threadPool, this, "EventDispatch" + i);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void destroy() {
        Thread[] threadArray;
        LOGGER.debug((Object)"Shutting down dispatch threads.");
        if (Thread.currentThread().getThreadGroup() == this.threadPool) {
            LOGGER.error((Object)"Cannot shut down the thread pool with one of it's own threads.");
            throw new RuntimeException();
        }
        this.running = false;
        FIFOQueue fIFOQueue = this.queue;
        // MONITORENTER : fIFOQueue
        this.queue.notifyAll();
        // MONITOREXIT : fIFOQueue
        LOGGER.info((Object)"Waiting for threads in pool to die.");
        int n = 0;
        Thread[] threadArray2 = new Thread[this.poolSize];
        block6: while (true) {
            try {
                while (true) {
                    threadArray2[0] = null;
                    this.threadPool.enumerate(threadArray2, false);
                    if (threadArray2[0] == null) break block6;
                    LOGGER.debug((Object)"There's still some threads running. Doing another loop..");
                    if (n >= 20) break block6;
                    Thread.sleep(50L);
                    threadArray = this.queue;
                    // MONITORENTER : this.queue
                    this.queue.notifyAll();
                    // MONITOREXIT : threadArray
                }
            }
            catch (InterruptedException interruptedException) {
                this.threadPool.interrupt();
                Thread.yield();
                continue;
            }
            break;
        }
        if (this.threadPool.activeCount() <= 0) return;
        LOGGER.error((Object)(this.threadPool.activeCount() + " dispatcher threads refused to die."));
        if (!LOGGER.isDebugEnabled()) return;
        threadArray = new Thread[this.threadPool.activeCount()];
        this.threadPool.enumerate(threadArray, false);
        int n2 = 0;
        while (n2 < threadArray2.length) {
            LOGGER.debug((Object)threadArray2[n2].getName());
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ConnectionObserver connectionObserver) {
        List list = this.observers;
        synchronized (list) {
            if (!this.observers.contains(connectionObserver)) {
                this.observers.add(connectionObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ConnectionObserver connectionObserver) {
        List list = this.observers;
        synchronized (list) {
            this.observers.remove(connectionObserver);
        }
    }

    public Iterator observerIterator() {
        return Collections.unmodifiableList(this.observers).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ConnectionObserver connectionObserver) {
        List list = this.observers;
        synchronized (list) {
            return this.observers.contains(connectionObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Connection connection, SMPPEvent sMPPEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Notifying observers of a new SMPP event " + sMPPEvent.getType()));
        }
        this.queue.put(connection, sMPPEvent);
        if (this.threadsWaiting > 0) {
            FIFOQueue fIFOQueue = this.queue;
            synchronized (fIFOQueue) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Connection connection, SMPPPacket sMPPPacket) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Notifying observers of a new SMPP packet (" + Integer.toHexString(sMPPPacket.getCommandId()) + "," + Integer.toString(sMPPPacket.getSequenceNum()) + ")"));
        }
        this.queue.put(connection, sMPPPacket);
        if (this.threadsWaiting > 0) {
            FIFOQueue fIFOQueue = this.queue;
            synchronized (fIFOQueue) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Thread start: " + Thread.currentThread().getName()));
            }
            while (this.running) {
                NotificationDetails notificationDetails = null;
                try {
                    FIFOQueue fIFOQueue = this.queue;
                    synchronized (fIFOQueue) {
                        if (this.queue.isEmpty()) {
                            ++this.threadsWaiting;
                            this.queue.wait();
                            --this.threadsWaiting;
                        }
                        notificationDetails = this.queue.get();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                if (notificationDetails == null) continue;
                for (int i = this.observers.size() - 1; i >= 0; --i) {
                    ConnectionObserver connectionObserver = (ConnectionObserver)this.observers.get(i);
                    if (notificationDetails.hasEvent()) {
                        connectionObserver.packetReceived(notificationDetails.getConnection(), notificationDetails.getPacket());
                        continue;
                    }
                    connectionObserver.update(notificationDetails.getConnection(), notificationDetails.getEvent());
                }
            }
            LOGGER.debug((Object)("Thread exit: " + Thread.currentThread().getName()));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Exception in dispatcher thread", (Throwable)exception);
        }
    }
}

