/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.version.SMPPVersion;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Bind
extends SMPPRequest {
    private String sysId;
    private String password;
    private String sysType;
    private String addressRange;
    private int addrTon;
    private int addrNpi;

    public Bind(int n) {
        super(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSystemId(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validateSystemId(string)) throw new InvalidParameterValueException("Invalid system ID", string);
            this.sysId = string;
            return;
        } else {
            this.sysId = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPassword(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validatePassword(string)) throw new InvalidParameterValueException("Invalid password", string);
            this.password = string;
            return;
        } else {
            this.password = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSystemType(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validateSystemType(string)) throw new InvalidParameterValueException("Invalid system type", string);
            this.sysType = string;
            return;
        } else {
            this.sysType = null;
        }
    }

    public void setAddressTon(int n) throws InvalidParameterValueException {
        this.addrTon = n;
    }

    public void setAddressNpi(int n) throws InvalidParameterValueException {
        this.addrNpi = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAddressRange(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validateAddressRange(string)) throw new InvalidParameterValueException("Invalid address range", string);
            this.addressRange = string;
            return;
        } else {
            this.addressRange = null;
        }
    }

    public String getSystemId() {
        return this.sysId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystemType() {
        return this.sysType;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public int getAddressTon() {
        return this.addrTon;
    }

    public int getAddressNpi() {
        return this.addrNpi;
    }

    public int getInterfaceVersion() {
        return this.version.getVersionID();
    }

    public int getBodyLength() {
        int n = (this.sysId != null ? this.sysId.length() : 0) + (this.password != null ? this.password.length() : 0) + (this.sysType != null ? this.sysType.length() : 0) + (this.addressRange != null ? this.addressRange.length() : 0);
        return n + 3 + 4;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        SMPPIO.writeCString(this.sysId, outputStream);
        SMPPIO.writeCString(this.password, outputStream);
        SMPPIO.writeCString(this.sysType, outputStream);
        SMPPIO.writeInt(this.version.getVersionID(), 1, outputStream);
        SMPPIO.writeInt(this.addrTon, 1, outputStream);
        SMPPIO.writeInt(this.addrNpi, 1, outputStream);
        SMPPIO.writeCString(this.addressRange, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        try {
            this.sysId = SMPPIO.readCString(byArray, n);
            this.password = SMPPIO.readCString(byArray, n += this.sysId.length() + 1);
            this.sysType = SMPPIO.readCString(byArray, n += this.password.length() + 1);
            n += this.sysType.length() + 1;
            int n2 = SMPPIO.bytesToInt(byArray, n++, 1);
            this.version = SMPPVersion.getVersion(n2);
            this.addrTon = SMPPIO.bytesToInt(byArray, n++, 1);
            this.addrNpi = SMPPIO.bytesToInt(byArray, n++, 1);
            this.addressRange = SMPPIO.readCString(byArray, n);
        }
        catch (VersionException versionException) {
            throw new SMPPProtocolException("Invalid interface version in response", versionException);
        }
    }

    public String toString() {
        return new String("bind");
    }
}

