/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.Bind;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BindResp
extends SMPPResponse {
    private String sysId;

    protected BindResp(int n) {
        super(n);
    }

    public BindResp(Bind bind) {
        super(bind);
    }

    public void setSystemId(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validateSystemId(string)) {
                throw new InvalidParameterValueException("Invalid system Id", string);
            }
        } else {
            this.sysId = null;
            return;
        }
        this.sysId = string;
    }

    public String getSystemId() {
        return this.sysId;
    }

    public int getBodyLength() {
        return (this.sysId != null ? this.sysId.length() : 0) + 1;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        SMPPIO.writeCString(this.sysId, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        this.sysId = SMPPIO.readCString(byArray, n);
    }

    public String toString() {
        return new String("bind_resp");
    }
}

