/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.LogFactory;

public class DeliverSM
extends SMPPRequest {
    private static final String SPEC_VIOLATION = "Setting the {0} on a deliver_sm is in violation of the SMPP specification";

    public DeliverSM() {
        super(5);
    }

    public DeliverSM(int n) {
        super(5, n);
    }

    public void setDeliveryTime(SMPPDate sMPPDate) {
        LogFactory.getLog((Class)DeliverSM.class).warn((Object)MessageFormat.format(SPEC_VIOLATION, "delivery time"));
        super.setDeliveryTime(sMPPDate);
    }

    public void setExpiryTime(SMPPDate sMPPDate) {
        LogFactory.getLog((Class)DeliverSM.class).warn((Object)MessageFormat.format(SPEC_VIOLATION, "expiry time"));
        super.setExpiryTime(sMPPDate);
    }

    public int getBodyLength() {
        int n = (this.serviceType != null ? this.serviceType.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.destination != null ? this.destination.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.toString().length() : 0) + (this.expiryTime != null ? this.expiryTime.toString().length() : 0) + (this.message != null ? this.message.length : 0);
        return n + 8 + 3;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        int n = 0;
        if (this.message != null) {
            n = this.message.length;
        }
        SMPPIO.writeCString(this.serviceType, outputStream);
        if (this.source != null) {
            this.source.writeTo(outputStream);
        } else {
            new Address(0, 0, "").writeTo(outputStream);
        }
        if (this.destination != null) {
            this.destination.writeTo(outputStream);
        } else {
            new Address(0, 0, "").writeTo(outputStream);
        }
        String string = this.deliveryTime == null ? "" : this.deliveryTime.toString();
        String string2 = this.expiryTime == null ? "" : this.expiryTime.toString();
        SMPPIO.writeInt(this.esmClass, 1, outputStream);
        SMPPIO.writeInt(this.protocolID, 1, outputStream);
        SMPPIO.writeInt(this.priority, 1, outputStream);
        SMPPIO.writeCString(string, outputStream);
        SMPPIO.writeCString(string2, outputStream);
        SMPPIO.writeInt(this.registered, 1, outputStream);
        SMPPIO.writeInt(this.replaceIfPresent, 1, outputStream);
        SMPPIO.writeInt(this.dataCoding, 1, outputStream);
        SMPPIO.writeInt(this.defaultMsg, 1, outputStream);
        SMPPIO.writeInt(n, 1, outputStream);
        if (this.message != null) {
            outputStream.write(this.message);
        }
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        try {
            int n2 = 0;
            this.serviceType = SMPPIO.readCString(byArray, n);
            this.source = new Address();
            this.source.readFrom(byArray, n += this.serviceType.length() + 1);
            this.destination = new Address();
            this.destination.readFrom(byArray, n += this.source.getLength());
            n += this.destination.getLength();
            this.esmClass = SMPPIO.bytesToInt(byArray, n++, 1);
            this.protocolID = SMPPIO.bytesToInt(byArray, n++, 1);
            this.priority = SMPPIO.bytesToInt(byArray, n++, 1);
            String string = SMPPIO.readCString(byArray, n);
            n += string.length() + 1;
            if (string.length() > 0) {
                this.deliveryTime = SMPPDate.parseSMPPDate(string);
            }
            String string2 = SMPPIO.readCString(byArray, n);
            n += string2.length() + 1;
            if (string2.length() > 0) {
                this.expiryTime = SMPPDate.parseSMPPDate(string2);
            }
            this.registered = SMPPIO.bytesToInt(byArray, n++, 1);
            this.replaceIfPresent = SMPPIO.bytesToInt(byArray, n++, 1);
            this.dataCoding = SMPPIO.bytesToInt(byArray, n++, 1);
            this.defaultMsg = SMPPIO.bytesToInt(byArray, n++, 1);
            if ((n2 = SMPPIO.bytesToInt(byArray, n++, 1)) > 0) {
                this.message = new byte[n2];
                System.arraycopy(byArray, n, this.message, 0, n2);
            }
        }
        catch (InvalidDateFormatException invalidDateFormatException) {
            throw new SMPPProtocolException("Unrecognized date format", invalidDateFormatException);
        }
    }

    public String toString() {
        if (this.esmClass == 4 || this.esmClass == 16) {
            return new String("delivery receipt");
        }
        return new String("deliver_sm");
    }
}

