/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.LogFactory;

public class DestinationTable
implements Cloneable {
    private List dests = new ArrayList();
    private int length;
    static /* synthetic */ Class class$ie$omk$smpp$message$DestinationTable;

    DestinationTable() {
    }

    synchronized void add(Address address) {
        this.dests.add(address);
        this.length += address.getLength() + 1;
    }

    synchronized void add(String string) {
        this.dests.add(string);
        this.length += string.length() + 2;
    }

    public synchronized void remove(Address address) {
        int n = this.dests.indexOf(address);
        if (n > -1) {
            this.length -= ((Address)this.dests.remove(n)).getLength() + 1;
        }
    }

    public synchronized void remove(String string) {
        int n = this.dests.indexOf(string);
        if (n > -1) {
            this.length -= ((String)this.dests.remove(n)).length() + 2;
        }
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.dests).iterator();
    }

    public ListIterator listIterator() {
        return Collections.unmodifiableList(this.dests).listIterator();
    }

    public synchronized int getLength() {
        return this.length;
    }

    public int size() {
        return this.dests.size();
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        Iterator iterator = this.dests.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Address) {
                SMPPIO.writeInt(1, 1, outputStream);
                ((Address)e).writeTo(outputStream);
                continue;
            }
            SMPPIO.writeInt(2, 1, outputStream);
            SMPPIO.writeCString((String)e, outputStream);
        }
    }

    public synchronized void readFrom(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3;
            if ((n3 = SMPPIO.bytesToInt(byArray, n++, 1)) == 1) {
                object = new Address();
                ((Address)object).readFrom(byArray, n);
                n += ((Address)object).getLength();
                this.dests.add(object);
                continue;
            }
            if (n3 == 2) {
                object = SMPPIO.readCString(byArray, n);
                n += ((String)object).length() + 1;
                this.dests.add(object);
                continue;
            }
            LogFactory.getLog((Class)(class$ie$omk$smpp$message$DestinationTable == null ? DestinationTable.class$("ie.omk.smpp.message.DestinationTable") : class$ie$omk$smpp$message$DestinationTable)).warn((Object)"Unidentified destination type on input.");
        }
        this.calculateLength();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported", cloneNotSupportedException);
        }
    }

    private void calculateLength() {
        this.length = 0;
        Iterator iterator = this.dests.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ++this.length;
            if (e instanceof Address) {
                this.length += ((Address)e).getLength();
                continue;
            }
            this.length += ((String)e).length() + 1;
        }
    }
}

