/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class ParamRetrieve
extends SMPPRequest {
    private String paramName = null;

    public ParamRetrieve() {
        super(34);
    }

    public ParamRetrieve(int n) {
        super(34, n);
    }

    public void setParamName(String string) throws InvalidParameterValueException {
        if (string == null) {
            this.paramName = null;
            return;
        }
        if (string.length() >= 32) {
            throw new InvalidParameterValueException("Parameter name is invalid", string);
        }
        this.paramName = string;
    }

    public String getParamName() {
        return this.paramName;
    }

    public int getBodyLength() {
        int n = this.paramName != null ? this.paramName.length() : 0;
        return n + 1;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        SMPPIO.writeCString(this.paramName, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        this.paramName = SMPPIO.readCString(byArray, n);
    }

    public String toString() {
        return new String("param_retrieve");
    }
}

