/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class QueryLastMsgs
extends SMPPRequest {
    private int msgCount = 0;

    public QueryLastMsgs() {
        super(35);
    }

    public QueryLastMsgs(int n) {
        super(35, n);
    }

    public void setMsgCount(int n) throws InvalidParameterValueException {
        if (n <= 0 || n > 100) {
            throw new InvalidParameterValueException("Message count must be between 1 and 100", n);
        }
        this.msgCount = n;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public int getBodyLength() {
        int n = this.source != null ? this.source.getLength() : 3;
        return n + 1;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        if (this.source != null) {
            this.source.writeTo(outputStream);
        } else {
            new Address(0, 0, "").writeTo(outputStream);
        }
        SMPPIO.writeInt(this.msgCount, 1, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        this.source = new Address();
        this.source.readFrom(byArray, n);
        n += this.source.getLength();
        this.msgCount = SMPPIO.bytesToInt(byArray, n++, 1);
    }

    public String toString() {
        return new String("query_last_msgs");
    }
}

