/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class QueryMsgDetails
extends SMPPRequest {
    private int smLength;

    public QueryMsgDetails() {
        super(36);
    }

    public QueryMsgDetails(int n) {
        super(36, n);
    }

    public void setSmLength(int n) {
        this.smLength = n;
        if (this.smLength < 0) {
            this.smLength = 0;
        }
        if (this.smLength > 160) {
            this.smLength = 160;
        }
    }

    public int getSmLength() {
        return this.smLength;
    }

    public int getBodyLength() {
        int n = (this.messageId != null ? this.messageId.length() : 0) + (this.source != null ? this.source.getLength() : 3);
        return n + 1 + 1;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        SMPPIO.writeCString(this.getMessageId(), outputStream);
        if (this.source != null) {
            this.source.writeTo(outputStream);
        } else {
            new Address(0, 0, "").writeTo(outputStream);
        }
        SMPPIO.writeInt(this.smLength, 1, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        this.messageId = SMPPIO.readCString(byArray, n);
        this.source = new Address();
        this.source.readFrom(byArray, n += this.messageId.length() + 1);
        n += this.source.getLength();
        this.smLength = SMPPIO.bytesToInt(byArray, n++, 1);
    }

    public String toString() {
        return new String("query_msg_details");
    }
}

