/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.DestinationTable;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.QueryMsgDetails;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class QueryMsgDetailsResp
extends SMPPResponse {
    private DestinationTable destinationTable = new DestinationTable();

    public QueryMsgDetailsResp() {
        super(-2147483612);
    }

    public QueryMsgDetailsResp(int n) {
        super(-2147483612, n);
    }

    public QueryMsgDetailsResp(QueryMsgDetails queryMsgDetails) {
        super(queryMsgDetails);
        this.messageId = queryMsgDetails.getMessageId();
        this.source = queryMsgDetails.getSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(Address address) {
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(address);
            return this.destinationTable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(String string) throws InvalidParameterValueException {
        if (!this.version.validateDistListName(string)) {
            throw new InvalidParameterValueException("Distribution list is invalid", string);
        }
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(string);
            return this.destinationTable.size();
        }
    }

    public int getNoOfDests() {
        return this.destinationTable.size();
    }

    public int getNumDests() {
        return this.destinationTable.size();
    }

    public DestinationTable getDestinationTable() {
        return this.destinationTable;
    }

    public int getBodyLength() {
        int n = (this.serviceType != null ? this.serviceType.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.toString().length() : 0) + (this.expiryTime != null ? this.expiryTime.toString().length() : 0) + (this.message != null ? this.message.length : 0) + (this.messageId != null ? this.messageId.length() : 0) + (this.finalDate != null ? this.finalDate.toString().length() : 0);
        return (n += this.destinationTable.getLength()) + 8 + 5;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        int n = 0;
        if (this.message != null) {
            n = this.message.length;
        }
        SMPPIO.writeCString(this.serviceType, outputStream);
        if (this.source != null) {
            this.source.writeTo(outputStream);
        } else {
            new Address(0, 0, "").writeTo(outputStream);
        }
        DestinationTable destinationTable = (DestinationTable)this.destinationTable.clone();
        int n2 = destinationTable.size();
        SMPPIO.writeInt(n2, 1, outputStream);
        destinationTable.writeTo(outputStream);
        String string = this.deliveryTime == null ? null : this.deliveryTime.toString();
        String string2 = this.expiryTime == null ? null : this.expiryTime.toString();
        String string3 = this.finalDate == null ? null : this.finalDate.toString();
        SMPPIO.writeInt(this.protocolID, 1, outputStream);
        SMPPIO.writeInt(this.priority, 1, outputStream);
        SMPPIO.writeCString(string, outputStream);
        SMPPIO.writeCString(string2, outputStream);
        SMPPIO.writeInt(this.registered, 1, outputStream);
        SMPPIO.writeInt(this.dataCoding, 1, outputStream);
        SMPPIO.writeInt(n, 1, outputStream);
        if (this.message != null) {
            outputStream.write(this.message);
        }
        SMPPIO.writeCString(this.getMessageId(), outputStream);
        SMPPIO.writeCString(string3, outputStream);
        SMPPIO.writeInt(this.messageStatus, 1, outputStream);
        SMPPIO.writeInt(this.errorCode, 1, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        try {
            int n2 = 0;
            int n3 = 0;
            this.serviceType = SMPPIO.readCString(byArray, n);
            this.source = new Address();
            this.source.readFrom(byArray, n += this.serviceType.length() + 1);
            n += this.source.getLength();
            n2 = SMPPIO.bytesToInt(byArray, n++, 1);
            DestinationTable destinationTable = new DestinationTable();
            destinationTable.readFrom(byArray, n, n2);
            n += destinationTable.getLength();
            this.destinationTable = destinationTable;
            this.protocolID = SMPPIO.bytesToInt(byArray, n++, 1);
            this.priority = SMPPIO.bytesToInt(byArray, n++, 1);
            String string = SMPPIO.readCString(byArray, n);
            n += string.length() + 1;
            if (string.length() > 0) {
                this.deliveryTime = SMPPDate.parseSMPPDate(string);
            }
            String string2 = SMPPIO.readCString(byArray, n);
            n += string2.length() + 1;
            if (string2.length() > 0) {
                this.expiryTime = SMPPDate.parseSMPPDate(string2);
            }
            this.registered = SMPPIO.bytesToInt(byArray, n++, 1);
            this.dataCoding = SMPPIO.bytesToInt(byArray, n++, 1);
            if ((n3 = SMPPIO.bytesToInt(byArray, n++, 1)) > 0) {
                this.message = new byte[n3];
                System.arraycopy(byArray, n, this.message, 0, n3);
                n += n3;
            }
            this.messageId = SMPPIO.readCString(byArray, n);
            String string3 = SMPPIO.readCString(byArray, n += this.messageId.length() + 1);
            n += string3.length() + 1;
            if (string3.length() > 0) {
                this.finalDate = SMPPDate.parseSMPPDate(string3);
            }
            this.messageStatus = SMPPIO.bytesToInt(byArray, n++, 1);
            this.errorCode = SMPPIO.bytesToInt(byArray, n++, 1);
        }
        catch (InvalidDateFormatException invalidDateFormatException) {
            throw new SMPPProtocolException("Unrecognized date format", invalidDateFormatException);
        }
    }

    public String toString() {
        return new String("query_msg_details_resp");
    }
}

