/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.QuerySM;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class QuerySMResp
extends SMPPResponse {
    public QuerySMResp() {
        super(-2147483645);
    }

    public QuerySMResp(int n) {
        super(-2147483645, n);
    }

    public QuerySMResp(QuerySM querySM) {
        super(querySM);
        this.messageId = querySM.getMessageId();
        this.finalDate = null;
        this.messageStatus = 0;
        this.errorCode = 0;
    }

    public int getBodyLength() {
        int n = (this.messageId != null ? this.messageId.length() : 0) + (this.finalDate != null ? this.finalDate.toString().length() : 0);
        return n + 2 + 2;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        String string = this.finalDate == null ? null : this.finalDate.toString();
        SMPPIO.writeCString(this.getMessageId(), outputStream);
        SMPPIO.writeCString(string, outputStream);
        SMPPIO.writeInt(this.messageStatus, 1, outputStream);
        SMPPIO.writeInt(this.errorCode, 1, outputStream);
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        try {
            this.messageId = SMPPIO.readCString(byArray, n);
            String string = SMPPIO.readCString(byArray, n += this.messageId.length() + 1);
            n += string.length() + 1;
            if (string.length() > 0) {
                this.finalDate = SMPPDate.parseSMPPDate(string);
            }
            this.messageStatus = SMPPIO.bytesToInt(byArray, n++, 1);
            this.errorCode = SMPPIO.bytesToInt(byArray, n++, 1);
        }
        catch (InvalidDateFormatException invalidDateFormatException) {
            throw new SMPPProtocolException("Unrecognized date format", invalidDateFormatException);
        }
    }

    public String toString() {
        return new String("query_sm_resp");
    }
}

