/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class ReplaceSM
extends SMPPRequest {
    public ReplaceSM() {
        super(7);
    }

    public ReplaceSM(int n) {
        super(7, n);
    }

    public int getBodyLength() {
        int n = (this.messageId != null ? this.messageId.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.toString().length() : 0) + (this.expiryTime != null ? this.expiryTime.toString().length() : 0) + (this.message != null ? this.message.length : 0);
        return n + 3 + 3;
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
        int n = 0;
        if (this.message != null) {
            n = this.message.length;
        }
        SMPPIO.writeCString(this.getMessageId(), outputStream);
        if (this.source != null) {
            this.source.writeTo(outputStream);
        } else {
            new Address(0, 0, "").writeTo(outputStream);
        }
        String string = this.deliveryTime == null ? null : this.deliveryTime.toString();
        String string2 = this.expiryTime == null ? null : this.expiryTime.toString();
        SMPPIO.writeCString(string, outputStream);
        SMPPIO.writeCString(string2, outputStream);
        SMPPIO.writeInt(this.registered, 1, outputStream);
        SMPPIO.writeInt(this.defaultMsg, 1, outputStream);
        SMPPIO.writeInt(n, 1, outputStream);
        if (this.message != null) {
            outputStream.write(this.message);
        }
    }

    public void readBodyFrom(byte[] byArray, int n) throws SMPPProtocolException {
        try {
            int n2 = 0;
            this.messageId = SMPPIO.readCString(byArray, n);
            this.source = new Address();
            this.source.readFrom(byArray, n += this.messageId.length() + 1);
            String string = SMPPIO.readCString(byArray, n += this.source.getLength());
            n += string.length() + 1;
            if (string.length() > 0) {
                this.deliveryTime = SMPPDate.parseSMPPDate(string);
            }
            String string2 = SMPPIO.readCString(byArray, n);
            n += string2.length() + 1;
            if (string2.length() > 0) {
                this.expiryTime = SMPPDate.parseSMPPDate(string2);
            }
            this.registered = SMPPIO.bytesToInt(byArray, n++, 1);
            this.defaultMsg = SMPPIO.bytesToInt(byArray, n++, 1);
            if ((n2 = SMPPIO.bytesToInt(byArray, n++, 1)) > 0) {
                this.message = new byte[n2];
                System.arraycopy(byArray, n, this.message, 0, n2);
            }
        }
        catch (InvalidDateFormatException invalidDateFormatException) {
            throw new SMPPProtocolException("Unrecognized date format", invalidDateFormatException);
        }
    }

    public String toString() {
        return new String("replace_sm");
    }
}

