/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.tlv.TLVTable;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.BinaryEncoding;
import ie.omk.smpp.util.EncodingFactory;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import ie.omk.smpp.version.SMPPVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public abstract class SMPPPacket {
    public static final int GENERIC_NACK = Integer.MIN_VALUE;
    public static final int BIND_RECEIVER = 1;
    public static final int BIND_RECEIVER_RESP = -2147483647;
    public static final int BIND_TRANSMITTER = 2;
    public static final int BIND_TRANSMITTER_RESP = -2147483646;
    public static final int QUERY_SM = 3;
    public static final int QUERY_SM_RESP = -2147483645;
    public static final int SUBMIT_SM = 4;
    public static final int SUBMIT_SM_RESP = -2147483644;
    public static final int DELIVER_SM = 5;
    public static final int DELIVER_SM_RESP = -2147483643;
    public static final int UNBIND = 6;
    public static final int UNBIND_RESP = -2147483642;
    public static final int REPLACE_SM = 7;
    public static final int REPLACE_SM_RESP = -2147483641;
    public static final int CANCEL_SM = 8;
    public static final int CANCEL_SM_RESP = -2147483640;
    public static final int BIND_TRANSCEIVER = 9;
    public static final int BIND_TRANSCEIVER_RESP = -2147483639;
    public static final int OUTBIND = 11;
    public static final int ENQUIRE_LINK = 21;
    public static final int ENQUIRE_LINK_RESP = -2147483627;
    public static final int SUBMIT_MULTI = 33;
    public static final int SUBMIT_MULTI_RESP = -2147483615;
    public static final int PARAM_RETRIEVE = 34;
    public static final int PARAM_RETRIEVE_RESP = -2147483614;
    public static final int QUERY_LAST_MSGS = 35;
    public static final int QUERY_LAST_MSGS_RESP = -2147483613;
    public static final int QUERY_MSG_DETAILS = 36;
    public static final int QUERY_MSG_DETAILS_RESP = -2147483612;
    public static final int ALERT_NOTIFICATION = 258;
    public static final int DATA_SM = 259;
    public static final int DATA_SM_RESP = -2147483389;
    public static final int SM_STATE_EN_ROUTE = 1;
    public static final int SM_STATE_DELIVERED = 2;
    public static final int SM_STATE_EXPIRED = 3;
    public static final int SM_STATE_DELETED = 4;
    public static final int SM_STATE_UNDELIVERABLE = 5;
    public static final int SM_STATE_ACCEPTED = 6;
    public static final int SM_STATE_INVALID = 7;
    public static final int SMC_MT = 1;
    public static final int SMC_MO = 2;
    public static final int SMC_MOMT = 3;
    public static final int SMC_RECEIPT = 4;
    public static final int SMC_DEFMSG = 8;
    public static final int SMC_LOOPBACK_RECEIPT = 16;
    public static final int SMC_RECEIPT_SWAP = 20;
    public static final int SMC_STORE = 32;
    public static final int SMC_STORE_FORWARD = 36;
    public static final int SMC_DLIST = 64;
    public static final int SMC_MULTI = 128;
    public static final int SMC_CAS_DL = 256;
    public static final int SMC_ESCALATED = 512;
    public static final int SMC_SUBMIT_REPLACE = 1024;
    public static final int SMC_MCE = 2048;
    public static final int ESME_ROK = 0;
    protected SMPPVersion version = SMPPVersion.getDefaultVersion();
    protected int commandId;
    protected int commandStatus;
    protected int sequenceNum;
    protected Address source;
    protected Address destination;
    protected byte[] message;
    protected String serviceType;
    protected SMPPDate deliveryTime;
    protected SMPPDate expiryTime;
    protected SMPPDate finalDate;
    protected String messageId;
    protected int messageStatus;
    protected int errorCode;
    protected int priority;
    protected int registered;
    protected int replaceIfPresent;
    protected int esmClass;
    protected int protocolID;
    private MessageEncoding encoding = EncodingFactory.getInstance().getDefaultAlphabet();
    protected int dataCoding = this.encoding.getDataCoding();
    protected int defaultMsg;
    protected TLVTable tlvTable = new TLVTable();

    protected SMPPPacket(int n) {
        this(n, 0);
    }

    protected SMPPPacket(int n, int n2) {
        this.commandId = n;
        this.sequenceNum = n2;
    }

    protected SMPPPacket(int n, SMPPVersion sMPPVersion) {
        this.commandId = n;
        this.version = sMPPVersion;
    }

    protected SMPPPacket(int n, int n2, SMPPVersion sMPPVersion) {
        this.commandId = n;
        this.sequenceNum = n2;
        this.version = sMPPVersion;
    }

    public SMPPVersion getVersion() {
        return this.version;
    }

    public boolean isRequest() {
        return false;
    }

    public void setVersion(SMPPVersion sMPPVersion) {
        this.version = sMPPVersion == null ? SMPPVersion.getDefaultVersion() : sMPPVersion;
    }

    public final int getCommandLen() {
        return this.getLength();
    }

    public final int getLength() {
        return 16 + this.getBodyLength() + this.tlvTable.getLength();
    }

    public abstract int getBodyLength();

    public int getCommandId() {
        return this.commandId;
    }

    public int getCommandStatus() {
        return this.commandStatus;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public void setSequenceNum(int n) {
        this.sequenceNum = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSource(Address address) throws InvalidParameterValueException {
        if (address != null) {
            if (!this.version.validateAddress(address)) throw new InvalidParameterValueException("Bad source address.", address);
            this.source = address;
            return;
        } else {
            this.source = null;
        }
    }

    public Address getSource() {
        return this.source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDestination(Address address) {
        if (address != null) {
            if (!this.version.validateAddress(address)) throw new InvalidParameterValueException("Bad destination address.", address);
            this.destination = address;
            return;
        } else {
            this.destination = null;
        }
    }

    public Address getDestination() {
        return this.destination;
    }

    public void setPriority(int n) throws InvalidParameterValueException {
        if (!this.version.validatePriorityFlag(n)) {
            throw new InvalidParameterValueException("Bad priority flag value", n);
        }
        this.priority = n;
    }

    public void setRegistered(boolean bl) {
        this.registered = bl ? 1 : 0;
    }

    public void setRegistered(int n) throws InvalidParameterValueException {
        if (!this.version.validateRegisteredDelivery(n)) {
            throw new InvalidParameterValueException("Bad registered delivery flag value", n);
        }
        this.registered = n;
    }

    public void setReplaceIfPresent(boolean bl) {
        this.replaceIfPresent = bl ? 1 : 0;
    }

    public void setReplaceIfPresent(int n) throws InvalidParameterValueException {
        if (!this.version.validateReplaceIfPresent(n)) {
            throw new InvalidParameterValueException("Bad replace if present flag value", n);
        }
        this.replaceIfPresent = n;
    }

    public void setEsmClass(int n) throws InvalidParameterValueException {
        if (!this.version.validateEsmClass(n)) {
            throw new InvalidParameterValueException("Bad ESM class", n);
        }
        this.esmClass = n;
    }

    public void setProtocolId(int n) {
        this.protocolID = n;
    }

    public void setProtocolID(int n) throws InvalidParameterValueException {
        if (!this.version.validateProtocolID(n)) {
            throw new InvalidParameterValueException("Bad Protocol ID", n);
        }
        this.protocolID = n;
    }

    public void setDataCoding(int n) throws InvalidParameterValueException {
        if (this.version.validateDataCoding(n)) {
            this.dataCoding = n;
            if (n > 0) {
                this.encoding = EncodingFactory.getInstance().getEncoding(n);
            }
        } else {
            throw new InvalidParameterValueException("Bad data coding", n);
        }
    }

    public void setDefaultMsg(int n) throws InvalidParameterValueException {
        if (!this.version.validateDefaultMsg(n)) {
            throw new InvalidParameterValueException("Default message ID out of range", n);
        }
        this.defaultMsg = n;
    }

    public boolean isRegistered() {
        return this.registered > 0;
    }

    public int getRegistered() {
        return this.registered;
    }

    public boolean isPriority() {
        return this.priority != 0;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isReplaceIfPresent() {
        return this.replaceIfPresent > 0;
    }

    public int getReplaceIfPresent() {
        return this.replaceIfPresent;
    }

    public int getEsmClass() {
        return this.esmClass;
    }

    public int getProtocolId() {
        return this.protocolID;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public int getDataCoding() {
        return this.dataCoding;
    }

    public int getDefaultMsgId() {
        return this.defaultMsg;
    }

    public int getDefaultMsg() {
        return this.defaultMsg;
    }

    public void setMessageText(String string) throws InvalidParameterValueException {
        if (!(this.encoding instanceof AlphabetEncoding)) {
            this.encoding = EncodingFactory.getInstance().getDefaultAlphabet();
        }
        AlphabetEncoding alphabetEncoding = (AlphabetEncoding)this.encoding;
        this.setMessage(alphabetEncoding.encodeString(string), alphabetEncoding);
    }

    public void setMessageText(String string, AlphabetEncoding alphabetEncoding) throws InvalidParameterValueException {
        if (alphabetEncoding == null) {
            throw new NullPointerException("Alphabet cannot be null");
        }
        this.setMessage(alphabetEncoding.encodeString(string), alphabetEncoding);
    }

    public void setMessage(byte[] byArray) throws InvalidParameterValueException {
        this.setMessage(byArray, 0, byArray.length, null);
    }

    public void setMessage(byte[] byArray, MessageEncoding messageEncoding) throws InvalidParameterValueException {
        this.setMessage(byArray, 0, byArray.length, messageEncoding);
    }

    public void setMessage(byte[] byArray, int n, int n2, MessageEncoding messageEncoding) throws InvalidParameterValueException {
        int n3 = -1;
        if (messageEncoding == null) {
            messageEncoding = new BinaryEncoding();
        }
        n3 = messageEncoding.getDataCoding();
        if (byArray != null) {
            if (n < 0 || n2 < 0 || byArray.length < n + n2) {
                throw new ArrayIndexOutOfBoundsException("Not enough bytes in array");
            }
            int n4 = n2;
            int n5 = messageEncoding.getEncodingLength();
            if (n5 != 8) {
                n4 = n2 * n5 / 8;
            }
            if (n4 > this.version.getMaxLength(5)) {
                throw new InvalidParameterValueException("Message is too long", byArray);
            }
            this.message = new byte[n2];
            System.arraycopy(byArray, n, this.message, 0, n2);
            this.dataCoding = n3;
        } else {
            this.message = null;
        }
    }

    public byte[] getMessage() {
        byte[] byArray = null;
        if (this.message != null) {
            byArray = new byte[this.message.length];
            System.arraycopy(this.message, 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public String getMessageText() {
        if (this.encoding instanceof AlphabetEncoding) {
            return ((AlphabetEncoding)this.encoding).decodeString(this.message);
        }
        return null;
    }

    public String getMessageText(AlphabetEncoding alphabetEncoding) {
        return alphabetEncoding.decodeString(this.message);
    }

    public int getMessageLen() {
        return this.message == null ? 0 : this.message.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setServiceType(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validateServiceType(string)) throw new InvalidParameterValueException("Bad service type", string);
            this.serviceType = string;
            return;
        } else {
            this.serviceType = null;
        }
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setDeliveryTime(SMPPDate sMPPDate) {
        this.deliveryTime = sMPPDate;
    }

    public void setDeliveryTime(Date date) {
        this.deliveryTime = new SMPPDate(date);
    }

    public SMPPDate getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setExpiryTime(SMPPDate sMPPDate) {
        this.expiryTime = sMPPDate;
    }

    public void setExpiryTime(Date date) {
        this.expiryTime = new SMPPDate(date);
    }

    public SMPPDate getExpiryTime() {
        return this.expiryTime;
    }

    public void setFinalDate(SMPPDate sMPPDate) {
        this.finalDate = sMPPDate;
    }

    public void setFinalDate(Date date) {
        this.finalDate = new SMPPDate(date);
    }

    public SMPPDate getFinalDate() {
        return this.finalDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMessageId(String string) throws InvalidParameterValueException {
        if (string != null) {
            if (!this.version.validateMessageId(string)) throw new InvalidParameterValueException("Bad message Id", string);
            this.messageId = string;
            return;
        } else {
            this.messageId = null;
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageStatus(int n) throws InvalidParameterValueException {
        if (!this.version.validateMessageState(n)) {
            throw new InvalidParameterValueException("Invalid message state", n);
        }
        this.messageStatus = n;
    }

    public int getMessageStatus() {
        return this.messageStatus;
    }

    public void setErrorCode(int n) throws InvalidParameterValueException {
        if (!this.version.validateErrorCode(n)) {
            throw new InvalidParameterValueException("Invalid error code", n);
        }
        this.errorCode = n;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public TLVTable getTLVTable() {
        return this.tlvTable;
    }

    public TLVTable setTLVTable(TLVTable tLVTable) {
        TLVTable tLVTable2 = this.tlvTable;
        this.tlvTable = tLVTable == null ? new TLVTable() : tLVTable;
        return tLVTable2;
    }

    public Object setOptionalParameter(Tag tag, Object object) {
        return this.tlvTable.set(tag, object);
    }

    public Object getOptionalParameter(Tag tag) {
        return this.tlvTable.get(tag);
    }

    public boolean isSet(Tag tag) {
        return this.tlvTable.isSet(tag);
    }

    public void setAlphabet(AlphabetEncoding alphabetEncoding) {
        this.encoding = alphabetEncoding == null ? EncodingFactory.getInstance().getDefaultAlphabet() : alphabetEncoding;
        this.dataCoding = alphabetEncoding.getDataCoding();
    }

    public void setAlphabet(AlphabetEncoding alphabetEncoding, int n) {
        if (alphabetEncoding == null) {
            this.encoding = EncodingFactory.getInstance().getDefaultAlphabet();
            this.dataCoding = alphabetEncoding.getDataCoding();
        } else {
            this.encoding = alphabetEncoding;
            this.dataCoding = n;
        }
    }

    public void setMessageEncoding(MessageEncoding messageEncoding) {
        this.encoding = messageEncoding == null ? EncodingFactory.getInstance().getDefaultAlphabet() : messageEncoding;
    }

    public MessageEncoding getMessageEncoding() {
        return this.encoding;
    }

    public String toString() {
        return "SMPP(l:" + Integer.toString(this.getLength()) + ", c:0x" + Integer.toHexString(this.commandId) + ", s:" + Integer.toString(this.commandStatus) + ", n:" + Integer.toString(this.sequenceNum) + ")";
    }

    protected void encodeBody(OutputStream outputStream) throws IOException {
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(outputStream, true);
    }

    public final void writeTo(OutputStream outputStream, boolean bl) throws IOException {
        int n = this.getLength();
        SMPPIO.writeInt(n, 4, outputStream);
        SMPPIO.writeInt(this.commandId, 4, outputStream);
        SMPPIO.writeInt(this.commandStatus, 4, outputStream);
        SMPPIO.writeInt(this.sequenceNum, 4, outputStream);
        this.encodeBody(outputStream);
        if (bl) {
            this.tlvTable.writeTo(outputStream);
        }
    }

    public void readFrom(byte[] byArray, int n) throws SMPPProtocolException {
        this.tlvTable.clear();
        if (byArray.length < n + 16) {
            throw new SMPPProtocolException("Not enough bytes for a header: " + (byArray.length - (n + 16)));
        }
        int n2 = SMPPIO.bytesToInt(byArray, n, 4);
        int n3 = SMPPIO.bytesToInt(byArray, n + 4, 4);
        if (n3 != this.commandId) {
            throw new SMPPProtocolException("The packet on the input stream is not the same as this packet's type.");
        }
        if (byArray.length < n + n2) {
            throw new SMPPProtocolException("Header specifies the packet length is longer than the number of bytes available.");
        }
        this.commandStatus = SMPPIO.bytesToInt(byArray, n + 8, 4);
        this.sequenceNum = SMPPIO.bytesToInt(byArray, n + 12, 4);
        try {
            if (this.commandStatus == 0) {
                int n4 = 16 + n;
                this.readBodyFrom(byArray, n4);
                int n5 = this.getBodyLength();
                if ((n2 -= 16 + n5) > 0) {
                    this.tlvTable.readFrom(byArray, n4 + n5, n2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SMPPProtocolException("Ran out of bytes to read for packet body", arrayIndexOutOfBoundsException);
        }
        if (this.dataCoding != 0) {
            this.encoding = EncodingFactory.getInstance().getEncoding(this.dataCoding);
        }
        if (this.encoding == null) {
            this.encoding = EncodingFactory.getInstance().getDefaultAlphabet();
        }
    }

    protected abstract void readBodyFrom(byte[] var1, int var2) throws SMPPProtocolException;
}

