/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.Tag;
import java.io.UnsupportedEncodingException;

public class StringEncoder
implements Encoder {
    private static final String ASCII_UNSUPPORTED_MSG = "Your JVM doesn't support ASCII!";
    private static final String ASCII = "US-ASCII";

    public void writeTo(Tag tag, Object object, byte[] byArray, int n) {
        try {
            String string = object.toString();
            int n2 = string.length();
            byte[] byArray2 = string.getBytes(ASCII);
            System.arraycopy(byArray2, 0, byArray, n, n2);
            byArray[n + n2] = 0;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(ASCII_UNSUPPORTED_MSG);
        }
    }

    public Object readFrom(Tag tag, byte[] byArray, int n, int n2) {
        try {
            String string = new String(byArray, n, n2 - 1, ASCII);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(ASCII_UNSUPPORTED_MSG);
        }
    }

    public int getValueLength(Tag tag, Object object) {
        return object.toString().length() + 1;
    }
}

