/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BadValueTypeException;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.InvalidSizeForValueException;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TLVTable
implements Serializable {
    static final long serialVersionUID = -4113000096792513355L;
    private Map map = new HashMap();
    private byte[] opts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(byte[] byArray, int n, int n2) {
        Map map = this.map;
        synchronized (map) {
            this.opts = new byte[n2];
            System.arraycopy(byArray, n, this.opts, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        Map map = this.map;
        synchronized (map) {
            byte[] byArray = new byte[1024];
            Iterator iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                Object v;
                Tag tag = (Tag)iterator.next();
                Encoder encoder = tag.getEncoder();
                int n = encoder.getValueLength(tag, v = this.map.get(tag));
                if (byArray.length < n + 4) {
                    byArray = new byte[n + 4];
                }
                SMPPIO.intToBytes(tag.intValue(), 2, byArray, 0);
                SMPPIO.intToBytes(n, 2, byArray, 2);
                encoder.writeTo(tag, v, byArray, 4);
                outputStream.write(byArray, 0, n + 4);
            }
        }
    }

    public Object get(Tag tag) {
        Object object = this.map.get(tag);
        if (object == null) {
            object = this.getValueFromBytes(tag);
        }
        return object;
    }

    public Object get(int n) {
        Tag tag = Tag.getTag(n);
        Object object = this.map.get(tag);
        if (object == null) {
            object = this.getValueFromBytes(tag);
        }
        return object;
    }

    public boolean isSet(Tag tag) {
        return this.map.containsKey(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(Tag tag, Object object) throws BadValueTypeException, InvalidSizeForValueException {
        Map map = this.map;
        synchronized (map) {
            boolean bl;
            if (this.opts != null) {
                this.parseAllOpts();
            }
            if (tag.getType() == null) {
                if (object != null) {
                    throw new BadValueTypeException("Tag " + Integer.toHexString(tag.intValue()) + " does not accept a value.");
                }
            } else if (!tag.getType().isAssignableFrom(object.getClass())) {
                throw new BadValueTypeException("Tag " + Integer.toHexString(tag.intValue()) + " expects a value of type " + tag.getType());
            }
            int n = tag.getMinLength();
            int n2 = tag.getMaxLength();
            int n3 = tag.getEncoder().getValueLength(tag, object);
            boolean bl2 = bl = n > -1 && n3 < n;
            if (!bl) {
                boolean bl3 = bl = n2 > -1 && n3 > n2;
            }
            if (bl) {
                throw new InvalidSizeForValueException("Tag " + Integer.toHexString(tag.intValue()) + " must have a length in the range " + n + " <= len <= " + n2);
            }
            return this.map.put(tag, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseAllOpts() {
        Map map = this.map;
        synchronized (map) {
            int n;
            for (int i = 0; i < this.opts.length; i += 4 + n) {
                Object object = null;
                Tag tag = Tag.getTag(SMPPIO.bytesToInt(this.opts, i, 2));
                Encoder encoder = tag.getEncoder();
                n = SMPPIO.bytesToInt(this.opts, i + 2, 2);
                object = encoder.readFrom(tag, this.opts, i + 4, n);
                this.map.put(tag, object);
            }
            this.opts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValueFromBytes(Tag tag) {
        int n;
        if (this.opts == null || this.opts.length < 4) {
            return null;
        }
        Encoder encoder = tag.getEncoder();
        Object object = null;
        int n2 = 0;
        do {
            int n3 = SMPPIO.bytesToInt(this.opts, n2, 2);
            n = SMPPIO.bytesToInt(this.opts, n2 + 2, 2);
            if (!tag.equals(n3)) continue;
            object = encoder.readFrom(tag, this.opts, n2 + 4, n);
            Map map = this.map;
            synchronized (map) {
                this.map.put(tag, object);
                break;
            }
        } while ((n2 += 4 + n) < this.opts.length);
        return object;
    }

    public int getLength() {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        int n = this.map.size() * 4;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            Encoder encoder = tag.getEncoder();
            n += encoder.getValueLength(tag, this.map.get(tag));
        }
        return n;
    }

    public Set tagSet() {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        return this.map.keySet();
    }

    public Collection values() {
        if (this.opts != null) {
            this.parseAllOpts();
        }
        return this.map.values();
    }
}

