/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BitmaskEncoder;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.NoEncoderException;
import ie.omk.smpp.message.tlv.NullEncoder;
import ie.omk.smpp.message.tlv.NumberEncoder;
import ie.omk.smpp.message.tlv.OctetEncoder;
import ie.omk.smpp.message.tlv.StringEncoder;
import ie.omk.smpp.message.tlv.TagDefinedException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public final class Tag
implements Serializable {
    private static Map tagTable = new HashMap();
    static final long serialVersionUID = -418561932897398277L;
    public static final Tag DEST_ADDR_SUBUNIT = new Tag(5, Number.class, 1);
    public static final Tag DEST_NETWORK_TYPE = new Tag(6, Number.class, 1);
    public static final Tag DEST_BEARER_TYPE = new Tag(7, Number.class, 1);
    public static final Tag DEST_TELEMATICS_ID = new Tag(8, Number.class, 2);
    public static final Tag SOURCE_ADDR_SUBUNIT = new Tag(13, Number.class, 1);
    public static final Tag SOURCE_NETWORK_TYPE = new Tag(14, Number.class, 1);
    public static final Tag SOURCE_BEARER_TYPE = new Tag(15, Number.class, 1);
    public static final Tag SOURCE_TELEMATICS_ID = new Tag(16, Number.class, 1);
    public static final Tag QOS_TIME_TO_LIVE = new Tag(23, Number.class, 4);
    public static final Tag PAYLOAD_TYPE = new Tag(25, Number.class, 1);
    public static final Tag ADDITIONAL_STATUS_INFO_TEXT = new Tag(29, String.class, 1, 256);
    public static final Tag RECEIPTED_MESSAGE_ID = new Tag(30, String.class, 1, 65);
    public static final Tag MS_MSG_WAIT_FACILITIES = new Tag(48, BitSet.class, 1);
    public static final Tag PRIVACY_INDICATOR = new Tag(513, Number.class, 1);
    public static final Tag SOURCE_SUBADDRESS = new Tag(514, [B.class, 2, 23);
    public static final Tag DEST_SUBADDRESS = new Tag(515, [B.class, 2, 23);
    public static final Tag USER_MESSAGE_REFERENCE = new Tag(516, Number.class, 2);
    public static final Tag USER_RESPONSE_CODE = new Tag(517, Number.class, 2);
    public static final Tag SOURCE_PORT = new Tag(522, Number.class, 2);
    public static final Tag DESTINATION_PORT = new Tag(523, Number.class, 2);
    public static final Tag SAR_MSG_REF_NUM = new Tag(524, Number.class, 2);
    public static final Tag LANGUAGE_INDICATOR = new Tag(525, Number.class, 1);
    public static final Tag SAR_TOTAL_SEGMENTS = new Tag(526, Number.class, 1);
    public static final Tag SAR_SEGMENT_SEQNUM = new Tag(527, Number.class, 1);
    public static final Tag SC_INTERFACE_VERSION = new Tag(528, Number.class, 1);
    public static final Tag CALLBACK_NUM_PRES_IND = new Tag(770, BitSet.class, 1);
    public static final Tag CALLBACK_NUM_ATAG = new Tag(771, [B.class, 0, 65);
    public static final Tag NUMBER_OF_MESSAGES = new Tag(772, Number.class, 1);
    public static final Tag CALLBACK_NUM = new Tag(897, [B.class, 4, 19);
    public static final Tag DPF_RESULT = new Tag(1056, Number.class, 1);
    public static final Tag SET_DPF = new Tag(1057, Number.class, 1);
    public static final Tag MS_AVAILABILITY_STATUS = new Tag(1058, Number.class, 1);
    public static final Tag NETWORK_ERROR_CODE = new Tag(1059, [B.class, 3);
    public static final Tag MESSAGE_PAYLOAD = new Tag(1060, [B.class, -1);
    public static final Tag DELIVERY_FAILURE_REASON = new Tag(1061, Number.class, 1);
    public static final Tag MORE_MESSAGES_TO_SEND = new Tag(1062, Number.class, 1);
    public static final Tag MESSAGE_STATE = new Tag(1063, Number.class, 1);
    public static final Tag USSD_SERVICE_OP = new Tag(1281, [B.class, 1);
    public static final Tag DISPLAY_TIME = new Tag(4609, Number.class, 1);
    public static final Tag SMS_SIGNAL = new Tag(4611, Number.class, 2);
    public static final Tag MS_VALIDITY = new Tag(4612, Number.class, 1);
    public static final Tag ALERT_ON_MESSAGE_DELIVERY = new Tag(4876, null, 0);
    public static final Tag ITS_REPLY_TYPE = new Tag(4992, Number.class, 1);
    public static final Tag ITS_SESSION_INFO = new Tag(4995, [B.class, 2);
    private Integer tag;
    private int minLength = -1;
    private int maxLength = -1;
    private Class type;
    private Encoder encoder;

    private Tag(int n, Class clazz, int n2) throws TagDefinedException {
        this(n, clazz, null, n2, n2);
    }

    private Tag(int n, Class clazz, int n2, int n3) throws TagDefinedException {
        this(n, clazz, null, n2, n3);
    }

    private Tag(int n, Class clazz, Encoder encoder, int n2) throws TagDefinedException {
        this(n, clazz, encoder, n2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tag(int n, Class clazz, Encoder encoder, int n2, int n3) throws TagDefinedException {
        this.tag = new Integer(n);
        this.type = clazz;
        this.minLength = n2;
        this.maxLength = n3;
        this.encoder = encoder == null ? this.getEncoderForType(clazz) : encoder;
        Map map = tagTable;
        synchronized (map) {
            if (tagTable.containsKey(this.tag)) {
                throw new TagDefinedException(n, "Tag 0x" + Integer.toHexString(n) + " is already defined.");
            }
            tagTable.put(this.tag, this);
        }
    }

    private Encoder getEncoderForType(Class clazz) {
        Encoder encoder;
        if (clazz == null) {
            encoder = new NullEncoder();
        } else if (Number.class.isAssignableFrom(clazz)) {
            encoder = new NumberEncoder();
        } else if (String.class.isAssignableFrom(clazz)) {
            encoder = new StringEncoder();
        } else if (BitSet.class.isAssignableFrom(clazz)) {
            encoder = new BitmaskEncoder();
        } else if ([B.class.isAssignableFrom(clazz)) {
            encoder = new OctetEncoder();
        } else {
            throw new NoEncoderException(clazz, "No encoder for class type " + clazz.getName());
        }
        return encoder;
    }

    public int intValue() {
        return this.tag;
    }

    public int getLength() {
        return this.maxLength < 0 ? this.minLength : this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Class getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object instanceof Tag) {
            return ((Tag)object).tag.equals(this.tag);
        }
        return false;
    }

    public boolean equals(int n) {
        return n == this.tag;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    public String toHexString() {
        return Integer.toHexString(this.tag);
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public static Tag getTag(int n) {
        Tag tag = (Tag)tagTable.get(new Integer(n));
        if (tag == null) {
            return Tag.defineTag(n, [B.class, null, -1, -1);
        }
        return tag;
    }

    public static Tag defineTag(int n, Class clazz, Encoder encoder, int n2) throws TagDefinedException {
        return new Tag(n, clazz, encoder, n2);
    }

    public static Tag defineTag(int n, Class clazz, Encoder encoder, int n2, int n3) throws TagDefinedException {
        return new Tag(n, clazz, encoder, n2, n3);
    }

    public static boolean isTagDefined(int n) {
        return tagTable.containsKey(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag undefineTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        Map map = tagTable;
        synchronized (map) {
            return (Tag)tagTable.remove(tag.tag);
        }
    }
}

