/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.net;

import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.util.APIConfig;
import ie.omk.smpp.util.PropertyNotFoundException;
import ie.omk.smpp.util.SMPPIO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SmscLink {
    private static final String TIMEOUT_UNSUPPORTED_ERR = "Timeout not supported";
    private static final String END_OF_STREAM_ERR = "EOS reached. No data available";
    private static final String LINK_NOT_UP_ERR = "Link not established.";
    private static final Log LOGGER;
    private BufferedInputStream in;
    private BufferedOutputStream out;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private OutputStream snoopIn;
    private OutputStream snoopOut;
    private boolean autoFlush;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmscLink() {
        try {
            this.autoFlush = APIConfig.getInstance().getBoolean("smppapi.net.autoflush");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this.autoFlush = true;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("autoFlush set to " + this.autoFlush));
            }
        }
    }

    public final void open() throws IOException {
        this.implOpen();
        int n = -1;
        int n2 = -1;
        APIConfig aPIConfig = APIConfig.getInstance();
        n = this.getBufferSize(aPIConfig, "smppapi.net.buffersize_in");
        n2 = this.getBufferSize(aPIConfig, "smppapi.net.buffersize_out");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("IN buffer size: " + n));
            LOGGER.debug((Object)("OUT buffer size: " + n2));
        }
        this.in = n < 1 ? new BufferedInputStream(this.getInputStream()) : new BufferedInputStream(this.getInputStream(), n);
        this.out = n2 < 1 ? new BufferedOutputStream(this.getOutputStream()) : new BufferedOutputStream(this.getOutputStream(), n2);
    }

    private int getBufferSize(APIConfig aPIConfig, String string) {
        int n = -1;
        try {
            String string2 = aPIConfig.getProperty(string);
            n = string2.toLowerCase().endsWith("k") ? Integer.parseInt(string2.substring(0, string2.length() - 1)) * 1024 : (string2.toLowerCase().endsWith("m") ? Integer.parseInt(string2.substring(0, string2.length() - 1)) * 0x100000 : Integer.parseInt(string2, 10));
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Buffer size is not set in configuration: " + string + ", using default."));
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)("Bad value for config property " + string), (Throwable)numberFormatException);
        }
        return n;
    }

    protected abstract void implOpen() throws IOException;

    public final void close() throws IOException {
        this.out = null;
        this.in = null;
        this.implClose();
        boolean bl = true;
        try {
            bl = APIConfig.getInstance().getBoolean("smppapi.net.autoclose_snoop");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            LOGGER.debug((Object)("smppapi.net.autoclose_snoop property not found. Using the default of " + bl));
        }
        if (bl) {
            try {
                if (this.snoopOut != null) {
                    this.snoopOut.close();
                }
                if (this.snoopIn != null) {
                    this.snoopIn.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"Exception while closing snoop streams.", (Throwable)iOException);
            }
        } else {
            try {
                if (this.snoopOut != null) {
                    this.snoopOut.flush();
                }
                if (this.snoopIn != null) {
                    this.snoopIn.flush();
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"Exception while flushing snoop streams.", (Throwable)iOException);
            }
        }
    }

    protected abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SMPPPacket sMPPPacket, boolean bl) throws IOException {
        if (this.out == null) {
            throw new IOException(LINK_NOT_UP_ERR);
        }
        Object object = this.writeLock;
        synchronized (object) {
            try {
                if (this.snoopOut != null) {
                    sMPPPacket.writeTo(this.snoopOut);
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"IOException writing to snoop output stream.", (Throwable)iOException);
            }
            sMPPPacket.writeTo(this.out);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean bl) {
        this.autoFlush = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(byte[] byArray) throws IOException {
        if (this.in == null) {
            throw new IOException(LINK_NOT_UP_ERR);
        }
        byte[] byArray2 = byArray;
        int n = 0;
        Object object = this.readLock;
        synchronized (object) {
            try {
                n = this.readBytes(byArray2, 0, 4, 16);
                int n2 = SMPPIO.bytesToInt(byArray2, 0, 4);
                if (n2 > byArray2.length) {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray2, 0, byArray3, 0, n);
                    byArray2 = byArray3;
                }
                int n3 = n2 - n;
                this.readBytes(byArray2, n, n3, n3);
            }
            finally {
                this.dump(this.snoopIn, byArray, 0, n);
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int available() {
        try {
            Object object = this.readLock;
            synchronized (object) {
                return this.in.available();
            }
        }
        catch (IOException iOException) {
            LOGGER.debug((Object)"IOException in available", (Throwable)iOException);
            return 0;
        }
    }

    private int readBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.readLock)) {
            throw new AssertionError();
        }
        int n4 = this.in.read(byArray, n, n3);
        if (n4 < n2) {
            if (n4 == -1) {
                throw new EOFException(END_OF_STREAM_ERR);
            }
            while (n4 < n2) {
                int n5 = this.in.read(byArray, n + n4, n3 - n4);
                if (n5 < 0) {
                    throw new EOFException(END_OF_STREAM_ERR);
                }
                n4 += n5;
            }
        }
        return n4;
    }

    private void dump(OutputStream outputStream, byte[] byArray, int n, int n2) {
        try {
            if (outputStream != null) {
                outputStream.write(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Couldn't write incoming bytes to input snooper.", (Throwable)iOException);
        }
    }

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract InputStream getInputStream() throws IOException;

    public abstract boolean isConnected();

    public void setTimeout(long l) {
        throw new UnsupportedOperationException(TIMEOUT_UNSUPPORTED_ERR);
    }

    public void setTimeout(int n) {
        throw new UnsupportedOperationException(TIMEOUT_UNSUPPORTED_ERR);
    }

    public int getTimeout() {
        throw new UnsupportedOperationException(TIMEOUT_UNSUPPORTED_ERR);
    }

    public void setSnoopStreams(OutputStream outputStream, OutputStream outputStream2) {
        this.snoopIn = outputStream;
        this.snoopOut = outputStream2;
    }

    static {
        $assertionsDisabled = !SmscLink.class.desiredAssertionStatus();
        LOGGER = LogFactory.getLog((Class)SmscLink.class);
    }
}

