/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.InvalidConfigurationException;
import ie.omk.smpp.util.PropertyNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class APIConfig
extends Properties {
    private static final String BAD_PROPERTY_VALUE = "Bad property value";
    static final long serialVersionUID = 3668742926704484281L;
    public static final String TCP_SOCKET_TIMEOUT = "smppapi.net.tcp.so_timeout";
    public static final String LINK_BUFFERSIZE_IN = "smppapi.net.buffersize_in";
    public static final String LINK_BUFFERSIZE_OUT = "smppapi.net.buffersize_out";
    public static final String LINK_AUTO_FLUSH = "smppapi.net.autoflush";
    public static final String LINK_AUTOCLOSE_SNOOP = "smppapi.net.autoclose_snoop";
    public static final String LINK_TIMEOUT = "smppapi.net.link_timeout";
    public static final String TOO_MANY_IO_EXCEPTIONS = "smppapi.connection.rcv_daemon.ioex_count";
    public static final String EVENT_DISPATCHER_CLASS = "smppapi.event.dispatcher";
    public static final String EVENT_THREAD_POOL_SIZE = "smppapi.event.threaded_dispatcher.pool_size";
    public static final String EVENT_THREAD_FIFO_QUEUE_SIZE = "smppapi.event.threaded_dispatcher.queue_size";
    public static final String BIND_TIMEOUT = "smppapi.connection.bind_timeout";
    private static final Log LOGGER = LogFactory.getLog((Class)APIConfig.class);
    private static final String[] SEARCH_PATH = new String[]{"/", "/ie/", "/ie/omk/", "/ie/omk/smpp/", ""};
    private static final String PROPS_RESOURCE = "smppapi.properties";
    private static APIConfig instance;
    private URL propsURL;

    public APIConfig() {
        this.propsURL = this.getDefaultPropertiesResource();
    }

    public APIConfig(URL uRL) {
        this.propsURL = uRL;
    }

    public boolean reloadAPIConfig() {
        LOGGER.debug((Object)"Reloading API config properties.");
        try {
            this.loadAPIProperties();
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Could not reload API properties.", (Throwable)iOException);
            return false;
        }
        return true;
    }

    public static APIConfig getInstance() {
        if (instance == null) {
            try {
                instance = new APIConfig();
                instance.loadAPIProperties();
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Could not load API properties from default resource", (Throwable)iOException);
            }
        }
        return instance;
    }

    public static void configure(URL uRL) {
        try {
            if (instance == null) {
                instance = new APIConfig(uRL);
            } else {
                APIConfig.instance.propsURL = uRL;
            }
            instance.loadAPIProperties();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)("Could not load API config from " + uRL), (Throwable)iOException);
        }
    }

    public String getProperty(String string) throws PropertyNotFoundException {
        String string2 = super.getProperty(string);
        if (string2 == null) {
            throw new PropertyNotFoundException(string);
        }
        return string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = super.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public short getShort(String string, short s) throws InvalidConfigurationException {
        short s2;
        try {
            s2 = this.getShort(string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            s2 = s;
        }
        return s2;
    }

    public short getShort(String string) throws InvalidConfigurationException, PropertyNotFoundException {
        int n = this.getInt(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new InvalidConfigurationException("Property value exceeds valid short range: " + n, string);
        }
        return (short)n;
    }

    public int getInt(String string, int n) throws InvalidConfigurationException {
        try {
            return this.getInt(string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return n;
        }
    }

    public int getInt(String string) throws InvalidConfigurationException, PropertyNotFoundException {
        long l;
        try {
            String string2 = this.getProperty(string);
            l = this.convertToNumber(string2);
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                throw new InvalidConfigurationException("Property value exceeds valid int range: " + l, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidConfigurationException(BAD_PROPERTY_VALUE, string);
        }
        return (int)l;
    }

    public long getLong(String string, long l) throws InvalidConfigurationException {
        long l2;
        try {
            l2 = this.getLong(string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            l2 = l;
        }
        return l2;
    }

    public long getLong(String string) throws InvalidConfigurationException, PropertyNotFoundException {
        long l;
        try {
            String string2 = this.getProperty(string);
            l = this.convertToNumber(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidConfigurationException(BAD_PROPERTY_VALUE, string);
        }
        return l;
    }

    public boolean getBoolean(String string, boolean bl) throws InvalidConfigurationException {
        try {
            return this.getBoolean(string);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return bl;
        }
    }

    public boolean getBoolean(String string) throws InvalidConfigurationException, PropertyNotFoundException {
        boolean bl = false;
        String string2 = this.getProperty(string).toLowerCase();
        try {
            int n = Integer.parseInt(string2);
            bl = n > 0;
        }
        catch (NumberFormatException numberFormatException) {
            if ("yes".equals(string2) || "on".equals(string2) || "true".equals(string2) || "1".equals(string2)) {
                bl = true;
            }
            if ("no".equals(string2) || "off".equals(string2) || "false".equals(string2) || "0".equals(string2)) {
                bl = false;
            }
            throw new InvalidConfigurationException(BAD_PROPERTY_VALUE, string, string2);
        }
        return bl;
    }

    private URL getDefaultPropertiesResource() {
        URL uRL = null;
        Class<?> clazz = this.getClass();
        for (int i = 0; i < SEARCH_PATH.length && uRL == null; ++i) {
            uRL = clazz.getResource(SEARCH_PATH[i] + PROPS_RESOURCE);
        }
        return uRL;
    }

    private void loadAPIProperties() throws IOException {
        if (this.propsURL != null) {
            this.load(this.propsURL.openStream());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Loaded API properties from " + this.propsURL));
                StringWriter stringWriter = new StringWriter();
                this.list(new PrintWriter(stringWriter));
                LOGGER.debug((Object)("\n" + stringWriter.toString()));
            }
        }
    }

    long convertToNumber(String string) throws NumberFormatException {
        String string2;
        int n = 10;
        long l = 1L;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n = 16;
            string2 = string.substring(2);
        } else if (string.endsWith("b")) {
            n = 2;
            string2 = string.substring(0, string.length() - 1);
        } else if (string.endsWith("k")) {
            l = 1024L;
            string2 = string.substring(0, string.length() - 1);
        } else if (string.endsWith("m")) {
            l = 0x100000L;
            string2 = string.substring(0, string.length() - 1);
        } else if (string.startsWith("0") && string.length() > 1) {
            n = 8;
            string2 = string.substring(1);
        } else {
            string2 = string;
        }
        return Long.parseLong(string2, n) * l;
    }
}

