/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.SMPPRuntimeException;
import ie.omk.smpp.util.MessageEncoding;
import java.io.UnsupportedEncodingException;

public class AlphabetEncoding
extends MessageEncoding {
    private static final String BAD_IMPLEMENTATION = "Missing charset in implementation of AlphabetEncoding " + AlphabetEncoding.class.getName();
    private String charset;

    protected AlphabetEncoding(int n) {
        super(n);
    }

    protected void setCharset(String string) throws UnsupportedEncodingException {
        new String("probe").getBytes(string);
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public String decodeString(byte[] byArray) {
        if (this.charset == null) {
            throw new SMPPRuntimeException(BAD_IMPLEMENTATION);
        }
        try {
            if (byArray != null) {
                return new String(byArray, this.charset);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    public byte[] encodeString(String string) {
        if (this.charset == null) {
            throw new SMPPRuntimeException(BAD_IMPLEMENTATION);
        }
        try {
            if (string != null) {
                return string.getBytes(this.charset);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new byte[0];
    }
}

