/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.ASCIIEncoding;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.DefaultAlphabetEncoding;
import ie.omk.smpp.util.Latin1Encoding;
import ie.omk.smpp.util.UCS2Encoding;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public final class AlphabetFactory {
    private static final Map LANG_TO_ALPHABET = new HashMap();
    private static AlphabetEncoding defaultAlphabet;
    private static final String DEFAULT_ALPHABET_PROPNAME = "smpp.default_alphabet";

    private AlphabetFactory() {
    }

    public static AlphabetEncoding getDefaultAlphabet() {
        if (defaultAlphabet == null) {
            AlphabetFactory.init();
        }
        return defaultAlphabet;
    }

    private static void init() {
        String string = "";
        try {
            string = System.getProperty(DEFAULT_ALPHABET_PROPNAME);
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                defaultAlphabet = (AlphabetEncoding)clazz.newInstance();
            } else {
                defaultAlphabet = new DefaultAlphabetEncoding();
            }
        }
        catch (Exception exception) {
            LogFactory.getLog((Class)AlphabetFactory.class).warn((Object)("Couldn't load default alphabet " + string), (Throwable)exception);
            defaultAlphabet = new DefaultAlphabetEncoding();
        }
    }

    public static AlphabetEncoding getAlphabet(String string) {
        AlphabetEncoding alphabetEncoding = (AlphabetEncoding)LANG_TO_ALPHABET.get(string);
        if (alphabetEncoding != null) {
            return alphabetEncoding;
        }
        return (AlphabetEncoding)LANG_TO_ALPHABET.get(null);
    }

    static {
        DefaultAlphabetEncoding defaultAlphabetEncoding = new DefaultAlphabetEncoding();
        try {
            LANG_TO_ALPHABET.put(null, new UCS2Encoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                LANG_TO_ALPHABET.put(null, new Latin1Encoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                LANG_TO_ALPHABET.put(null, new ASCIIEncoding());
            }
        }
        LANG_TO_ALPHABET.put("en", defaultAlphabetEncoding);
        LANG_TO_ALPHABET.put("de", defaultAlphabetEncoding);
        LANG_TO_ALPHABET.put("fr", defaultAlphabetEncoding);
        LANG_TO_ALPHABET.put("it", defaultAlphabetEncoding);
        LANG_TO_ALPHABET.put("nl", defaultAlphabetEncoding);
        LANG_TO_ALPHABET.put("es", defaultAlphabetEncoding);
    }
}

