/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.AlphabetEncoding;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;

public class DefaultAlphabetEncoding
extends AlphabetEncoding {
    private static final int DCS = 0;
    public static final int EXTENDED_ESCAPE = 27;
    public static final int PAGE_BREAK = 10;
    private static final char[] CHAR_TABLE = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', ' ', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    private static final char[] EXT_CHAR_TABLE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '^', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '{', '}', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\\', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '[', '~', ']', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u20ac', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final DefaultAlphabetEncoding INSTANCE = new DefaultAlphabetEncoding();

    public DefaultAlphabetEncoding() {
        super(0);
    }

    public static DefaultAlphabetEncoding getInstance() {
        return INSTANCE;
    }

    public String decodeString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        char[] cArray = CHAR_TABLE;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n == 27) {
                cArray = EXT_CHAR_TABLE;
                continue;
            }
            stringBuffer.append(n >= cArray.length ? (char)'?' : cArray[n]);
            cArray = CHAR_TABLE;
        }
        return stringBuffer.toString();
    }

    public byte[] encodeString(String string) {
        if (string == null) {
            return new byte[0];
        }
        char[] cArray = string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            for (n = 0; n < CHAR_TABLE.length; ++n) {
                if (n == 27) continue;
                if (cArray[i] == CHAR_TABLE[n]) {
                    byteArrayOutputStream.write((byte)n);
                    break;
                }
                if (cArray[i] != EXT_CHAR_TABLE[n]) continue;
                byteArrayOutputStream.write(27);
                byteArrayOutputStream.write((byte)n);
                break;
            }
            if (n != CHAR_TABLE.length) continue;
            byteArrayOutputStream.write(63);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getEncodingLength() {
        return 7;
    }

    public byte[] pack(byte[] byArray) {
        int n = byArray.length - byArray.length / 8;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 8) {
            int n3 = i + 7 > byArray.length ? byArray.length - i : 7;
            int n4 = 1;
            for (int j = 0; j < n3; ++j) {
                int n5 = byArray[i + j] & 0xFF;
                int n6 = 0;
                try {
                    n6 = byArray[i + j + 1] & n4;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                byArray2[n2++] = (byte)(n5 >>> j | n6 << 8 - (j + 1));
                n4 = n4 << 1 | 1;
            }
        }
        return byArray2;
    }

    public byte[] unpack(byte[] byArray) {
        int n = byArray.length * 8 / 7;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 7) {
            int n3 = 127;
            int n4 = i + 8 > byArray.length ? byArray.length - i : 8;
            for (int j = 0; j < n4; ++j) {
                int n5 = byArray[i + j] & n3;
                int n6 = 0;
                try {
                    n6 = byArray[i + j - 1] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                byArray2[n2++] = (byte)(n5 << j | n6 >>> 8 - j);
                n3 >>= 1;
            }
        }
        return byArray2;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Table size: ").append(CHAR_TABLE.length).append('\n');
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i + 16 * j;
                objectArray[0] = new Integer(n);
                objectArray[1] = CHAR_TABLE[n] == '\r' ? "CR" : (CHAR_TABLE[n] == '\n' ? "LF" : (CHAR_TABLE[n] == ' ' ? "SP" : " " + CHAR_TABLE[n]));
                stringBuffer.append(MessageFormat.format("{0,number,000}: {1}  ", objectArray));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

