/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.ASCIIEncoding;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.BinaryEncoding;
import ie.omk.smpp.util.DefaultAlphabetEncoding;
import ie.omk.smpp.util.Latin1Encoding;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.util.UCS2Encoding;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingFactory {
    private static final Log LOGGER = LogFactory.getLog((Class)EncodingFactory.class);
    private static final String DEFAULT_ALPHABET_PROPNAME = "smpp.default_alphabet";
    private static final EncodingFactory INSTANCE = new EncodingFactory();
    private final Map mappingTable = new HashMap();
    private final Map langToAlphabet = new HashMap();
    private AlphabetEncoding defaultAlphabet;

    public EncodingFactory() {
        DefaultAlphabetEncoding defaultAlphabetEncoding = new DefaultAlphabetEncoding();
        this.addEncoding(defaultAlphabetEncoding);
        this.addEncoding(new ASCIIEncoding());
        this.addEncoding(new BinaryEncoding());
        this.addEncoding(Latin1Encoding.class);
        this.addEncoding(UCS2Encoding.class);
        this.langToAlphabet.put("en", defaultAlphabetEncoding);
        this.langToAlphabet.put("de", defaultAlphabetEncoding);
        this.langToAlphabet.put("fr", defaultAlphabetEncoding);
        this.langToAlphabet.put("it", defaultAlphabetEncoding);
        this.langToAlphabet.put("nl", defaultAlphabetEncoding);
        this.langToAlphabet.put("es", defaultAlphabetEncoding);
        try {
            this.addEncoding(new UCS2Encoding());
            this.langToAlphabet.put(null, new UCS2Encoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.langToAlphabet.put(null, new Latin1Encoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                LOGGER.debug((Object)"JVM does not support UCS2 - encoding will not be used.");
                this.langToAlphabet.put(null, new ASCIIEncoding());
            }
        }
        this.initDefaultAlphabet();
    }

    public static final EncodingFactory getInstance() {
        return INSTANCE;
    }

    public MessageEncoding getEncoding(int n) {
        return (MessageEncoding)this.mappingTable.get(new Integer(n));
    }

    public void addEncoding(MessageEncoding messageEncoding) {
        this.mappingTable.put(new Integer(messageEncoding.getDataCoding()), messageEncoding);
    }

    public void addEncoding(Class clazz) {
        try {
            if (!MessageEncoding.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Not an encoding class: " + clazz);
            }
            Constructor constructor = clazz.getConstructor(new Class[0]);
            this.addEncoding((MessageEncoding)constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.error((Object)(clazz.getName() + " does not have a" + "no-argument constructor"), (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.error((Object)(clazz.getName() + " does not have a visible" + " no-argument constructor"), (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.error((Object)("Cannot instantiate an instance of " + clazz), (Throwable)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof UnsupportedEncodingException) {
                LOGGER.debug((Object)(clazz.getName() + " is not supported by the JVM"));
            } else {
                LOGGER.error((Object)(clazz.getName() + " constructor threw " + "an exception"), (Throwable)invocationTargetException);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error((Object)"This exception shouldn't happen", (Throwable)illegalArgumentException);
        }
    }

    public Iterator getAllEncodings() {
        return this.mappingTable.values().iterator();
    }

    public AlphabetEncoding getDefaultAlphabet() {
        return this.defaultAlphabet;
    }

    public AlphabetEncoding getAlphabet(String string) {
        AlphabetEncoding alphabetEncoding = (AlphabetEncoding)this.langToAlphabet.get(string);
        if (alphabetEncoding != null) {
            return alphabetEncoding;
        }
        return (AlphabetEncoding)this.langToAlphabet.get(null);
    }

    private void initDefaultAlphabet() {
        String string = "";
        try {
            string = System.getProperty(DEFAULT_ALPHABET_PROPNAME);
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                this.defaultAlphabet = (AlphabetEncoding)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Couldn't load default alphabet " + string), (Throwable)exception);
        }
        if (this.defaultAlphabet == null) {
            this.defaultAlphabet = new DefaultAlphabetEncoding();
        }
    }
}

