/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.message.AlertNotification;
import ie.omk.smpp.message.BindReceiver;
import ie.omk.smpp.message.BindReceiverResp;
import ie.omk.smpp.message.BindTransceiver;
import ie.omk.smpp.message.BindTransceiverResp;
import ie.omk.smpp.message.BindTransmitter;
import ie.omk.smpp.message.BindTransmitterResp;
import ie.omk.smpp.message.CancelSM;
import ie.omk.smpp.message.CancelSMResp;
import ie.omk.smpp.message.DataSM;
import ie.omk.smpp.message.DataSMResp;
import ie.omk.smpp.message.DeliverSM;
import ie.omk.smpp.message.DeliverSMResp;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.EnquireLinkResp;
import ie.omk.smpp.message.GenericNack;
import ie.omk.smpp.message.ParamRetrieve;
import ie.omk.smpp.message.ParamRetrieveResp;
import ie.omk.smpp.message.QueryLastMsgs;
import ie.omk.smpp.message.QueryLastMsgsResp;
import ie.omk.smpp.message.QueryMsgDetails;
import ie.omk.smpp.message.QueryMsgDetailsResp;
import ie.omk.smpp.message.QuerySM;
import ie.omk.smpp.message.QuerySMResp;
import ie.omk.smpp.message.ReplaceSM;
import ie.omk.smpp.message.ReplaceSMResp;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SubmitMulti;
import ie.omk.smpp.message.SubmitMultiResp;
import ie.omk.smpp.message.SubmitSM;
import ie.omk.smpp.message.SubmitSMResp;
import ie.omk.smpp.message.Unbind;
import ie.omk.smpp.message.UnbindResp;

public final class PacketFactory {
    private PacketFactory() {
    }

    public static SMPPPacket newPacket(int n) throws BadCommandIDException {
        return PacketFactory.newInstance(n);
    }

    public static SMPPPacket newInstance(int n) throws BadCommandIDException {
        SMPPPacket sMPPPacket = null;
        switch (n) {
            case -2147483648: {
                sMPPPacket = new GenericNack();
                break;
            }
            case 1: {
                sMPPPacket = new BindReceiver();
                break;
            }
            case -2147483647: {
                sMPPPacket = new BindReceiverResp();
                break;
            }
            case 2: {
                sMPPPacket = new BindTransmitter();
                break;
            }
            case -2147483646: {
                sMPPPacket = new BindTransmitterResp();
                break;
            }
            case 9: {
                sMPPPacket = new BindTransceiver();
                break;
            }
            case -2147483639: {
                sMPPPacket = new BindTransceiverResp();
                break;
            }
            case 6: {
                sMPPPacket = new Unbind();
                break;
            }
            case -2147483642: {
                sMPPPacket = new UnbindResp();
                break;
            }
            case 4: {
                sMPPPacket = new SubmitSM();
                break;
            }
            case -2147483644: {
                sMPPPacket = new SubmitSMResp();
                break;
            }
            case 259: {
                sMPPPacket = new DataSM();
                break;
            }
            case -2147483389: {
                sMPPPacket = new DataSMResp();
                break;
            }
            case 258: {
                sMPPPacket = new AlertNotification();
                break;
            }
            case 33: {
                sMPPPacket = new SubmitMulti();
                break;
            }
            case -2147483615: {
                sMPPPacket = new SubmitMultiResp();
                break;
            }
            case 5: {
                sMPPPacket = new DeliverSM();
                break;
            }
            case -2147483643: {
                sMPPPacket = new DeliverSMResp();
                break;
            }
            case 3: {
                sMPPPacket = new QuerySM();
                break;
            }
            case -2147483645: {
                sMPPPacket = new QuerySMResp();
                break;
            }
            case 35: {
                sMPPPacket = new QueryLastMsgs();
                break;
            }
            case -2147483613: {
                sMPPPacket = new QueryLastMsgsResp();
                break;
            }
            case 36: {
                sMPPPacket = new QueryMsgDetails();
                break;
            }
            case -2147483612: {
                sMPPPacket = new QueryMsgDetailsResp();
                break;
            }
            case 8: {
                sMPPPacket = new CancelSM();
                break;
            }
            case -2147483640: {
                sMPPPacket = new CancelSMResp();
                break;
            }
            case 7: {
                sMPPPacket = new ReplaceSM();
                break;
            }
            case -2147483641: {
                sMPPPacket = new ReplaceSMResp();
                break;
            }
            case 21: {
                sMPPPacket = new EnquireLink();
                break;
            }
            case -2147483627: {
                sMPPPacket = new EnquireLinkResp();
                break;
            }
            case 34: {
                sMPPPacket = new ParamRetrieve();
                break;
            }
            case -2147483614: {
                sMPPPacket = new ParamRetrieveResp();
                break;
            }
            default: {
                throw new BadCommandIDException();
            }
        }
        return sMPPPacket;
    }
}

