/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.InvalidDateFormatException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SMPPDate
implements Serializable {
    static final long serialVersionUID = -2404447252053261604L;
    private static final String FORMAT = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}{6,number,0}{7,number,00}{8}";
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int tenth;
    private int utcOffset;
    private char sign = (char)43;
    private int hashCode;
    private TimeZone savedTimeZone;

    public SMPPDate() {
        this.hashCode = this.toString().hashCode();
        this.savedTimeZone = TimeZone.getDefault();
    }

    public SMPPDate(Date date) {
        if (date == null) {
            throw new NullPointerException("Cannot use a null Date");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.setFields(calendar);
    }

    public SMPPDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("Cannot use a null Calendar");
        }
        this.setFields(calendar);
    }

    public SMPPDate(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.tenth = 0;
        this.utcOffset = 0;
        this.sign = (char)82;
        this.savedTimeZone = null;
        this.hashCode = this.toString().hashCode();
    }

    private void setFields(Calendar calendar) {
        this.year = calendar.get(1) - 2000;
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.tenth = calendar.get(14) / 100;
        this.savedTimeZone = calendar.getTimeZone();
        this.sign = (char)43;
        long l = this.savedTimeZone.getRawOffset();
        if (l < 0L) {
            this.sign = (char)45;
        }
        this.utcOffset = (int)(Math.abs(l) / 900000L);
        this.hashCode = this.toString().hashCode();
    }

    private void initCalendar(Calendar calendar) {
        calendar.setTimeZone(this.savedTimeZone);
        calendar.set(1, this.year + 2000);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.tenth * 100);
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        this.initCalendar(calendar);
        return calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getTenth() {
        return this.tenth;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    public TimeZone getTimeZone() {
        return this.savedTimeZone;
    }

    public char getSign() {
        return this.sign;
    }

    public boolean isRelative() {
        return this.sign == 'R';
    }

    public boolean equals(Object object) {
        if (object instanceof SMPPDate) {
            SMPPDate sMPPDate = (SMPPDate)object;
            int n = this.year - sMPPDate.year + (this.month - sMPPDate.month) + (this.day - sMPPDate.day) + (this.hour - sMPPDate.hour) + (this.minute - sMPPDate.minute) + (this.second - sMPPDate.second) + (this.tenth - sMPPDate.tenth) + (this.sign - sMPPDate.sign);
            boolean bl = this.savedTimeZone == null ? sMPPDate.savedTimeZone == null : this.savedTimeZone.equals(sMPPDate.savedTimeZone);
            return n == 0 && bl && this.sign == sMPPDate.sign;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static SMPPDate parseSMPPDate(String string) throws InvalidDateFormatException {
        SMPPDate sMPPDate = new SMPPDate();
        if (string == null || string.length() == 0) {
            return sMPPDate;
        }
        if (string.length() != 16) {
            throw new InvalidDateFormatException("Date string is incorrect length", string);
        }
        try {
            sMPPDate.year = Integer.parseInt(string.substring(0, 2));
            sMPPDate.month = Integer.parseInt(string.substring(2, 4));
            sMPPDate.day = Integer.parseInt(string.substring(4, 6));
            sMPPDate.hour = Integer.parseInt(string.substring(6, 8));
            sMPPDate.minute = Integer.parseInt(string.substring(8, 10));
            sMPPDate.second = Integer.parseInt(string.substring(10, 12));
            sMPPDate.sign = string.charAt(15);
            if (sMPPDate.sign == 'R') {
                sMPPDate.tenth = 0;
                sMPPDate.utcOffset = 0;
                sMPPDate.savedTimeZone = null;
            } else {
                String[] stringArray;
                sMPPDate.tenth = Integer.parseInt(string.substring(12, 13));
                sMPPDate.utcOffset = Integer.parseInt(string.substring(13, 15));
                int n = sMPPDate.utcOffset * 900000;
                if (sMPPDate.sign == '-') {
                    n = -n;
                }
                if ((stringArray = TimeZone.getAvailableIDs(n)).length > 0) {
                    sMPPDate.savedTimeZone = TimeZone.getTimeZone(stringArray[0]);
                }
            }
            sMPPDate.hashCode = sMPPDate.toString().hashCode();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDateFormatException("Invalid SMPP date string", string);
        }
        return sMPPDate;
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.year), new Integer(this.month), new Integer(this.day), new Integer(this.hour), new Integer(this.minute), new Integer(this.second), new Integer(this.tenth), new Integer(this.utcOffset), new Character(this.sign)};
        return MessageFormat.format(FORMAT, objectArray);
    }
}

