/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class SMPPIO {
    private static final String US_ASCII = "US-ASCII";

    private SMPPIO() {
    }

    public static int readInt(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n - n3 && (n2 = inputStream.read(byArray, n3, n - n3)) != -1; ++i) {
            n3 += n2;
        }
        return SMPPIO.bytesToInt(byArray, 0, n);
    }

    public static String readCString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStream.read();
        while (n != 0) {
            if (n == -1) {
                throw new IOException("End of Input Stream before NULL byte");
            }
            stringBuffer.append((char)n);
            n = inputStream.read();
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String readCString(byte[] byArray, int n) {
        String string;
        try {
            int n2 = n;
            while (byArray[n2] != 0) {
                ++n2;
            }
            string = n2 > n ? new String(byArray, n, n2 - n, US_ASCII) : "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "";
        }
        return string;
    }

    public static String readString(InputStream inputStream, int n) throws IOException {
        String string = null;
        if (n >= 1) {
            int n2;
            byte[] byArray = new byte[n];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; i += n2) {
                n2 = inputStream.read(byArray, 0, n - i);
                if (n2 == -1) {
                    throw new IOException("EOS before NUL byte read.");
                }
                stringBuffer.append(new String(byArray, 0, n2, US_ASCII));
            }
            if (stringBuffer.length() > 0) {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String readString(byte[] byArray, int n, int n2) {
        String string = "";
        try {
            if (n2 > 0) {
                string = new String(byArray, n, n2 - n, US_ASCII);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static byte[] intToBytes(int n, int n2) {
        return SMPPIO.intToBytes(n, n2, null, 0);
    }

    public static byte[] intToBytes(int n, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = byArray;
        if (byArray == null) {
            byArray2 = new byte[n2];
            n3 = 0;
        }
        int n4 = (n2 - 1) * 8;
        int n5 = 255 << n4;
        for (int i = 0; i < n2; ++i) {
            byArray2[n3 + i] = (byte)((n & n5) >>> n4);
            n4 -= 8;
            n5 >>>= 8;
        }
        return byArray2;
    }

    public static byte[] longToBytes(long l, int n) {
        return SMPPIO.longToBytes(l, n, null, 0);
    }

    public static byte[] longToBytes(long l, int n, byte[] byArray, int n2) {
        if (byArray == null) {
            byArray = new byte[n];
            n2 = 0;
        }
        long l2 = (n - 1) * 8;
        long l3 = 255L << (int)l2;
        for (int i = 0; i < n; ++i) {
            byArray[n2 + i] = (byte)((l & l3) >>> (int)l2);
            l2 -= 8L;
            l3 >>>= 8;
        }
        return byArray;
    }

    public static int bytesToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 8 * (n2 - 1);
        for (int i = 0; i < n2; ++i) {
            n3 |= (byArray[n + i] & 0xFF) << n4;
            n4 -= 8;
        }
        return n3;
    }

    public static long bytesToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        long l2 = 8L * ((long)n2 - 1L);
        for (int i = 0; i < n2; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << (int)l2;
            l2 -= 8L;
        }
        return l;
    }

    public static void writeInt(int n, int n2, OutputStream outputStream) throws IOException {
        outputStream.write(SMPPIO.intToBytes(n, n2));
    }

    public static void writeCString(String string, OutputStream outputStream) throws IOException {
        SMPPIO.writeString(string, outputStream);
        outputStream.write(0);
    }

    public static void writeString(String string, int n, OutputStream outputStream) throws IOException {
        if (string == null) {
            return;
        }
        if (n > string.length()) {
            SMPPIO.writeString(string, outputStream);
        } else {
            SMPPIO.writeString(string.substring(0, n), outputStream);
        }
    }

    public static void writeString(String string, OutputStream outputStream) throws IOException {
        if (string == null) {
            return;
        }
        outputStream.write(string.getBytes());
    }
}

