/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.version;

import ie.omk.smpp.Address;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.version.SMPPVersion33;
import ie.omk.smpp.version.SMPPVersion34;
import ie.omk.smpp.version.VersionException;

public abstract class SMPPVersion {
    public static final int MESSAGE_PAYLOAD = 5;
    public static final SMPPVersion V33 = new SMPPVersion33();
    public static final SMPPVersion V34 = new SMPPVersion34();
    private int versionID;
    private String versionString;

    protected SMPPVersion(int n, String string) {
        this.versionID = n;
        this.versionString = string;
    }

    public static final SMPPVersion getDefaultVersion() {
        return V34;
    }

    public static final SMPPVersion getVersion(int n) throws VersionException {
        if (n == V33.getVersionID()) {
            return V33;
        }
        if (n == V34.getVersionID()) {
            return V34;
        }
        throw new VersionException("Unknown version id: 0x" + Integer.toHexString(n));
    }

    public int getVersionID() {
        return this.versionID;
    }

    public boolean isOlder(SMPPVersion sMPPVersion) {
        return sMPPVersion.versionID < this.versionID;
    }

    public boolean isNewer(SMPPVersion sMPPVersion) {
        return sMPPVersion.versionID > this.versionID;
    }

    public boolean equals(Object object) {
        if (object instanceof SMPPVersion) {
            return ((SMPPVersion)object).versionID == this.versionID;
        }
        return false;
    }

    public int hashCode() {
        return new Integer(this.versionID).hashCode();
    }

    public boolean equals(int n) {
        return n == this.versionID;
    }

    public String toString() {
        return this.versionString;
    }

    public abstract int getMaxLength(int var1);

    public abstract boolean isSupported(int var1);

    public abstract boolean isSupportOptionalParams();

    public abstract boolean validateAddress(Address var1);

    public abstract boolean validateEsmClass(int var1);

    public abstract boolean validateProtocolID(int var1);

    public abstract boolean validateDataCoding(int var1);

    public abstract boolean validateDefaultMsg(int var1);

    public abstract boolean validateMessageText(String var1, AlphabetEncoding var2);

    public abstract boolean validateMessage(byte[] var1, MessageEncoding var2);

    public abstract boolean validateServiceType(String var1);

    public abstract boolean validateMessageId(String var1);

    public final boolean validateMessageStatus(int n) {
        return this.validateMessageState(n);
    }

    public abstract boolean validateMessageState(int var1);

    public abstract boolean validateErrorCode(int var1);

    public abstract boolean validatePriorityFlag(int var1);

    public abstract boolean validateRegisteredDelivery(int var1);

    public abstract boolean validateReplaceIfPresent(int var1);

    public abstract boolean validateNumberOfDests(int var1);

    public abstract boolean validateNumUnsuccessful(int var1);

    public abstract boolean validateDistListName(String var1);

    public abstract boolean validateSystemId(String var1);

    public abstract boolean validatePassword(String var1);

    public abstract boolean validateSystemType(String var1);

    public abstract boolean validateAddressRange(String var1);

    public abstract boolean validateParamName(String var1);

    public abstract boolean validateParamValue(String var1);
}

