/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.version;

import ie.omk.smpp.Address;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.MessageEncoding;
import ie.omk.smpp.version.SMPPVersion;

public class SMPPVersion34
extends SMPPVersion {
    private static final int MAX_MSG_LENGTH = 254;

    SMPPVersion34() {
        super(52, "SMPP version 3.4");
    }

    public boolean isSupported(int n) {
        switch (n & Integer.MAX_VALUE) {
            case 34: 
            case 35: 
            case 36: {
                return false;
            }
        }
        return true;
    }

    public boolean isSupportOptionalParams() {
        return true;
    }

    public int getMaxLength(int n) {
        switch (n) {
            case 5: {
                return 254;
            }
        }
        return Integer.MAX_VALUE;
    }

    public boolean validateAddress(Address address) {
        int n = address.getTON();
        int n2 = address.getNPI();
        boolean bl = n >= 0 && n <= 255;
        boolean bl2 = n2 >= 0 && n2 <= 255;
        boolean bl3 = address.getAddress().length() <= 20;
        return bl && bl2 && bl3;
    }

    public boolean validateEsmClass(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validateProtocolID(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validateDataCoding(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validateDefaultMsg(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validateMessageText(String string, AlphabetEncoding alphabetEncoding) {
        if (string != null) {
            return alphabetEncoding.encodeString(string).length <= 254;
        }
        return true;
    }

    public boolean validateMessage(byte[] byArray, MessageEncoding messageEncoding) {
        if (byArray != null) {
            return byArray.length <= 254;
        }
        return true;
    }

    public boolean validateServiceType(String string) {
        return string.length() <= 5;
    }

    public boolean validateMessageId(String string) {
        return string.length() <= 64;
    }

    public boolean validateMessageState(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validateErrorCode(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validatePriorityFlag(int n) {
        return n >= 0 && n <= 3;
    }

    public boolean validateRegisteredDelivery(int n) {
        return n >= 0 && n <= 31;
    }

    public boolean validateReplaceIfPresent(int n) {
        return n == 0 || n == 1;
    }

    public boolean validateNumberOfDests(int n) {
        return n >= 0 && n <= 254;
    }

    public boolean validateNumUnsuccessful(int n) {
        return n >= 0 && n <= 255;
    }

    public boolean validateDistListName(String string) {
        return string.length() <= 20;
    }

    public boolean validateSystemId(String string) {
        return string.length() <= 15;
    }

    public boolean validatePassword(String string) {
        return string.length() <= 8;
    }

    public boolean validateSystemType(String string) {
        return string.length() <= 12;
    }

    public boolean validateAddressRange(String string) {
        return string.length() <= 40;
    }

    public boolean validateParamName(String string) {
        return false;
    }

    public boolean validateParamValue(String string) {
        return false;
    }
}

