/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.NotificationDetails;
import ie.omk.smpp.event.QueueFullException;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.SMPPPacket;

class FIFOQueue {
    private int head;
    private int tail;
    private NotificationDetails[] queue;

    public FIFOQueue(int queueSize) {
        if (queueSize < 1) {
            queueSize = 100;
        }
        this.queue = new NotificationDetails[queueSize];
        for (int i = 0; i < queueSize; ++i) {
            this.queue[i] = new NotificationDetails();
        }
    }

    public void put(Connection c, SMPPPacket p) throws QueueFullException {
        if (this.isFull()) {
            throw new QueueFullException();
        }
        this.queue[this.tail++].setDetails(c, null, p);
        if (this.tail >= this.queue.length) {
            this.tail = 0;
        }
    }

    public void put(Connection c, SMPPEvent e) throws QueueFullException {
        if (this.isFull()) {
            throw new QueueFullException();
        }
        this.queue[this.tail++].setDetails(c, e, null);
        if (this.tail >= this.queue.length) {
            this.tail = 0;
        }
    }

    public NotificationDetails get() {
        NotificationDetails nd = null;
        if (!this.isEmpty()) {
            nd = this.queue[this.head++];
            if (this.head >= this.queue.length) {
                this.head = 0;
            }
        }
        return nd;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public boolean isFull() {
        if (this.tail > this.head) {
            return this.tail == this.queue.length - 1 && this.head == 0;
        }
        return this.tail == this.head - 1;
    }
}

