/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.ReceiverExceptionEvent;
import ie.omk.smpp.event.ReceiverExitEvent;
import ie.omk.smpp.event.ReceiverStartEvent;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.BindResp;
import ie.omk.smpp.message.CancelSMResp;
import ie.omk.smpp.message.DeliverSM;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.EnquireLinkResp;
import ie.omk.smpp.message.GenericNack;
import ie.omk.smpp.message.ParamRetrieveResp;
import ie.omk.smpp.message.ReplaceSMResp;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.message.SubmitMultiResp;
import ie.omk.smpp.message.SubmitSMResp;
import ie.omk.smpp.message.Unbind;
import ie.omk.smpp.message.UnbindResp;
import org.apache.commons.logging.LogFactory;

public abstract class SMPPEventAdapter
implements ConnectionObserver {
    public final void update(Connection source, SMPPEvent event) {
        try {
            switch (event.getType()) {
                case 2: {
                    this.receiverStart(source, (ReceiverStartEvent)event);
                    break;
                }
                case 3: {
                    ReceiverExitEvent ree = (ReceiverExitEvent)event;
                    if (ree.getReason() == 2) {
                        this.receiverExitException(source, ree);
                        break;
                    }
                    this.receiverExit(source, ree);
                    break;
                }
                case 4: {
                    this.receiverException(source, (ReceiverExceptionEvent)event);
                    break;
                }
                default: {
                    this.userEvent(source, event);
                    break;
                }
            }
        }
        catch (ClassCastException x) {
            LogFactory.getLog((Class)SMPPEventAdapter.class).error((Object)"Class cast exception", (Throwable)x);
        }
    }

    public final void packetReceived(Connection source, SMPPPacket pak) {
        switch (pak.getCommandId()) {
            case 5: {
                this.deliverSM(source, (DeliverSM)pak);
                break;
            }
            case -2147483644: {
                this.submitSMResponse(source, (SubmitSMResp)pak);
                break;
            }
            case -2147483615: {
                this.submitMultiResponse(source, (SubmitMultiResp)pak);
                break;
            }
            case -2147483640: {
                this.cancelSMResponse(source, (CancelSMResp)pak);
                break;
            }
            case -2147483641: {
                this.replaceSMResponse(source, (ReplaceSMResp)pak);
                break;
            }
            case -2147483614: {
                this.paramRetrieveResponse(source, (ParamRetrieveResp)pak);
                break;
            }
            case -2147483645: 
            case -2147483613: 
            case -2147483612: {
                this.queryResponse(source, (SMPPResponse)pak);
                break;
            }
            case 21: {
                this.queryLink(source, (EnquireLink)pak);
                break;
            }
            case -2147483627: {
                this.queryLinkResponse(source, (EnquireLinkResp)pak);
                break;
            }
            case 6: {
                this.unbind(source, (Unbind)pak);
                break;
            }
            case -2147483642: {
                this.unbindResponse(source, (UnbindResp)pak);
                break;
            }
            case -2147483647: 
            case -2147483646: 
            case -2147483639: {
                this.bindResponse(source, (BindResp)pak);
                break;
            }
            case -2147483648: {
                this.genericNack(source, (GenericNack)pak);
                break;
            }
            default: {
                this.unidentified(source, pak);
            }
        }
    }

    public void receiverExit(Connection source, ReceiverExitEvent rev) {
    }

    public void receiverExitException(Connection source, ReceiverExitEvent rev) {
    }

    public void receiverException(Connection source, ReceiverExceptionEvent rev) {
    }

    public void receiverStart(Connection source, ReceiverStartEvent rs) {
    }

    public void userEvent(Connection source, SMPPEvent ev) {
    }

    public void deliverSM(Connection source, DeliverSM dm) {
    }

    public void submitSMResponse(Connection source, SubmitSMResp smr) {
    }

    public void submitMultiResponse(Connection source, SubmitMultiResp smr) {
    }

    public void cancelSMResponse(Connection source, CancelSMResp cmr) {
    }

    public void replaceSMResponse(Connection source, ReplaceSMResp rmr) {
    }

    public void paramRetrieveResponse(Connection source, ParamRetrieveResp prr) {
    }

    public void queryResponse(Connection source, SMPPResponse qr) {
    }

    public void queryLink(Connection source, EnquireLink el) {
    }

    public void queryLinkResponse(Connection source, EnquireLinkResp elr) {
    }

    public void unbind(Connection source, Unbind ubd) {
    }

    public void unbindResponse(Connection source, UnbindResp ubr) {
    }

    public void bindResponse(Connection source, BindResp br) {
    }

    public void genericNack(Connection source, GenericNack nack) {
    }

    public void unidentified(Connection source, SMPPPacket pak) {
    }
}

