/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.DestinationTable;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class SubmitMulti
extends SMPPRequest {
    private DestinationTable destinationTable = new DestinationTable();

    public SubmitMulti() {
        super(33);
    }

    public SubmitMulti(int seqNum) {
        super(33, seqNum);
    }

    public DestinationTable getDestinationTable() {
        return this.destinationTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(Address d) {
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(d);
            return this.destinationTable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDestination(String d) throws InvalidParameterValueException {
        if (!this.version.validateDistListName(d)) {
            throw new InvalidParameterValueException("Distribution list name is invalid", d);
        }
        DestinationTable destinationTable = this.destinationTable;
        synchronized (destinationTable) {
            this.destinationTable.add(d);
            return this.destinationTable.size();
        }
    }

    public int getNoOfDests() {
        return this.destinationTable.size();
    }

    public int getNumDests() {
        return this.destinationTable.size();
    }

    public int getBodyLength() {
        int size = (this.serviceType != null ? this.serviceType.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.toString().length() : 0) + (this.expiryTime != null ? this.expiryTime.toString().length() : 0) + (this.message != null ? this.message.length : 0);
        return (size += this.destinationTable.getLength()) + 9 + 3;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        int smLength = 0;
        if (this.message != null) {
            smLength = this.message.length;
        }
        DestinationTable table = (DestinationTable)this.destinationTable.clone();
        SMPPIO.writeCString(this.serviceType, out);
        if (this.source != null) {
            this.source.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        int numDests = table.size();
        SMPPIO.writeInt(numDests, 1, out);
        table.writeTo(out);
        String dt = this.deliveryTime == null ? null : this.deliveryTime.toString();
        String et = this.expiryTime == null ? null : this.expiryTime.toString();
        SMPPIO.writeInt(this.esmClass, 1, out);
        SMPPIO.writeInt(this.protocolID, 1, out);
        SMPPIO.writeInt(this.priority, 1, out);
        SMPPIO.writeCString(dt, out);
        SMPPIO.writeCString(et, out);
        SMPPIO.writeInt(this.registered, 1, out);
        SMPPIO.writeInt(this.replaceIfPresent, 1, out);
        SMPPIO.writeInt(this.dataCoding, 1, out);
        SMPPIO.writeInt(this.defaultMsg, 1, out);
        SMPPIO.writeInt(smLength, 1, out);
        if (this.message != null) {
            out.write(this.message);
        }
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        try {
            int numDests = 0;
            int smLength = 0;
            this.serviceType = SMPPIO.readCString(body, offset);
            this.source = new Address();
            this.source.readFrom(body, offset += this.serviceType.length() + 1);
            offset += this.source.getLength();
            numDests = SMPPIO.bytesToInt(body, offset++, 1);
            DestinationTable dt = new DestinationTable();
            dt.readFrom(body, offset, numDests);
            offset += dt.getLength();
            this.destinationTable = dt;
            this.esmClass = SMPPIO.bytesToInt(body, offset++, 1);
            this.protocolID = SMPPIO.bytesToInt(body, offset++, 1);
            this.priority = SMPPIO.bytesToInt(body, offset++, 1);
            String delivery = SMPPIO.readCString(body, offset);
            offset += delivery.length() + 1;
            if (delivery.length() > 0) {
                this.deliveryTime = SMPPDate.parseSMPPDate(delivery);
            }
            String valid = SMPPIO.readCString(body, offset);
            offset += valid.length() + 1;
            if (valid.length() > 0) {
                this.expiryTime = SMPPDate.parseSMPPDate(valid);
            }
            this.registered = SMPPIO.bytesToInt(body, offset++, 1);
            this.replaceIfPresent = SMPPIO.bytesToInt(body, offset++, 1);
            this.dataCoding = SMPPIO.bytesToInt(body, offset++, 1);
            this.defaultMsg = SMPPIO.bytesToInt(body, offset++, 1);
            if ((smLength = SMPPIO.bytesToInt(body, offset++, 1)) > 0) {
                this.message = new byte[smLength];
                System.arraycopy(body, offset, this.message, 0, smLength);
            }
        }
        catch (InvalidDateFormatException x) {
            throw new SMPPProtocolException("Unrecognized date format", x);
        }
    }

    public String toString() {
        return new String("submit_multi");
    }
}

