/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BadValueTypeException;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.Tag;

public class OctetEncoder
implements Encoder {
    private static final String BAD_VALUE_MSG = "Value must be of type byte[]";

    public void writeTo(Tag tag, Object value, byte[] b, int offset) {
        try {
            byte[] valBytes = (byte[])value;
            System.arraycopy(valBytes, 0, b, offset, valBytes.length);
        }
        catch (ClassCastException x) {
            throw new BadValueTypeException(BAD_VALUE_MSG);
        }
    }

    public Object readFrom(Tag tag, byte[] b, int offset, int length) {
        byte[] val = new byte[length];
        System.arraycopy(b, offset, val, 0, length);
        return val;
    }

    public int getValueLength(Tag tag, Object value) {
        try {
            byte[] b = (byte[])value;
            return b.length;
        }
        catch (ClassCastException x) {
            throw new BadValueTypeException(BAD_VALUE_MSG);
        }
    }
}

