/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.message.AlertNotification;
import ie.omk.smpp.message.BindReceiver;
import ie.omk.smpp.message.BindReceiverResp;
import ie.omk.smpp.message.BindTransceiver;
import ie.omk.smpp.message.BindTransceiverResp;
import ie.omk.smpp.message.BindTransmitter;
import ie.omk.smpp.message.BindTransmitterResp;
import ie.omk.smpp.message.CancelSM;
import ie.omk.smpp.message.CancelSMResp;
import ie.omk.smpp.message.DataSM;
import ie.omk.smpp.message.DataSMResp;
import ie.omk.smpp.message.DeliverSM;
import ie.omk.smpp.message.DeliverSMResp;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.EnquireLinkResp;
import ie.omk.smpp.message.GenericNack;
import ie.omk.smpp.message.ParamRetrieve;
import ie.omk.smpp.message.ParamRetrieveResp;
import ie.omk.smpp.message.QueryLastMsgs;
import ie.omk.smpp.message.QueryLastMsgsResp;
import ie.omk.smpp.message.QueryMsgDetails;
import ie.omk.smpp.message.QueryMsgDetailsResp;
import ie.omk.smpp.message.QuerySM;
import ie.omk.smpp.message.QuerySMResp;
import ie.omk.smpp.message.ReplaceSM;
import ie.omk.smpp.message.ReplaceSMResp;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SubmitMulti;
import ie.omk.smpp.message.SubmitMultiResp;
import ie.omk.smpp.message.SubmitSM;
import ie.omk.smpp.message.SubmitSMResp;
import ie.omk.smpp.message.Unbind;
import ie.omk.smpp.message.UnbindResp;

public final class PacketFactory {
    private PacketFactory() {
    }

    public static SMPPPacket newPacket(int id) throws BadCommandIDException {
        return PacketFactory.newInstance(id);
    }

    public static SMPPPacket newInstance(int id) throws BadCommandIDException {
        SMPPPacket response = null;
        switch (id) {
            case -2147483648: {
                response = new GenericNack();
                break;
            }
            case 1: {
                response = new BindReceiver();
                break;
            }
            case -2147483647: {
                response = new BindReceiverResp();
                break;
            }
            case 2: {
                response = new BindTransmitter();
                break;
            }
            case -2147483646: {
                response = new BindTransmitterResp();
                break;
            }
            case 9: {
                response = new BindTransceiver();
                break;
            }
            case -2147483639: {
                response = new BindTransceiverResp();
                break;
            }
            case 6: {
                response = new Unbind();
                break;
            }
            case -2147483642: {
                response = new UnbindResp();
                break;
            }
            case 4: {
                response = new SubmitSM();
                break;
            }
            case -2147483644: {
                response = new SubmitSMResp();
                break;
            }
            case 259: {
                response = new DataSM();
                break;
            }
            case -2147483389: {
                response = new DataSMResp();
                break;
            }
            case 258: {
                response = new AlertNotification();
                break;
            }
            case 33: {
                response = new SubmitMulti();
                break;
            }
            case -2147483615: {
                response = new SubmitMultiResp();
                break;
            }
            case 5: {
                response = new DeliverSM();
                break;
            }
            case -2147483643: {
                response = new DeliverSMResp();
                break;
            }
            case 3: {
                response = new QuerySM();
                break;
            }
            case -2147483645: {
                response = new QuerySMResp();
                break;
            }
            case 35: {
                response = new QueryLastMsgs();
                break;
            }
            case -2147483613: {
                response = new QueryLastMsgsResp();
                break;
            }
            case 36: {
                response = new QueryMsgDetails();
                break;
            }
            case -2147483612: {
                response = new QueryMsgDetailsResp();
                break;
            }
            case 8: {
                response = new CancelSM();
                break;
            }
            case -2147483640: {
                response = new CancelSMResp();
                break;
            }
            case 7: {
                response = new ReplaceSM();
                break;
            }
            case -2147483641: {
                response = new ReplaceSMResp();
                break;
            }
            case 21: {
                response = new EnquireLink();
                break;
            }
            case -2147483627: {
                response = new EnquireLinkResp();
                break;
            }
            case 34: {
                response = new ParamRetrieve();
                break;
            }
            case -2147483614: {
                response = new ParamRetrieveResp();
                break;
            }
            default: {
                throw new BadCommandIDException();
            }
        }
        return response;
    }
}

